/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owshortcut;

import com.wewebu.ow.server.ecm.OwRepository;
import com.wewebu.ow.server.plug.owshortcut.OwShortCutItem;
import com.wewebu.ow.server.plug.std.log.OwLog;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OwShortCutDocumentHelper {
    private static final Logger LOG = OwLog.getLogger(OwShortCutDocumentHelper.class);
    private Map<String, OwShortCutItem> m_shortcutsMap = new HashMap<String, OwShortCutItem>();

    public boolean addShortCut(Collection oShortCuts_p) {
        boolean addedFlag = false;
        if (oShortCuts_p != null) {
            for (OwShortCutItem object : oShortCuts_p) {
                if (!this.addShortCut(object)) continue;
                addedFlag = true;
            }
        }
        return addedFlag;
    }

    public boolean addShortCut(OwShortCutItem oObject_p) {
        boolean addedFlag = false;
        try {
            String id = oObject_p.getId();
            if (!this.m_shortcutsMap.containsKey(id)) {
                this.m_shortcutsMap.put(id, oObject_p);
                addedFlag = true;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"OwShortCutDocumentHelper.addShortCut(): Exception", (Throwable)e);
        }
        return addedFlag;
    }

    public boolean deleteShortCut(Collection oShortCuts_p) {
        boolean deletedFlag = false;
        if (oShortCuts_p != null) {
            for (OwShortCutItem object : oShortCuts_p) {
                if (!this.deleteShortCut(object)) continue;
                deletedFlag = true;
            }
        }
        return deletedFlag;
    }

    public boolean deleteShortCut(String shortcutId_p) {
        boolean deletedFlag = false;
        if (shortcutId_p != null && !shortcutId_p.equals("") && this.m_shortcutsMap.containsKey(shortcutId_p)) {
            this.m_shortcutsMap.remove(shortcutId_p);
            deletedFlag = true;
        }
        return deletedFlag;
    }

    public boolean deleteShortCut(OwShortCutItem oObject_p) {
        boolean deletedFlag = false;
        try {
            deletedFlag = this.deleteShortCut(oObject_p.getId());
        }
        catch (Exception e) {
            LOG.warn((Object)"OwShortCutDocumentHelper.deleteShortCut(): Exception", (Throwable)e);
        }
        return deletedFlag;
    }

    public void cleanShortCut() {
        this.m_shortcutsMap.clear();
    }

    public List getShortcuts() {
        return this.getShortcuts(new ShortCutComparator());
    }

    public List getShortcuts(Comparator comparator_p) {
        Set<String> keys = this.m_shortcutsMap.keySet();
        int count = 0;
        OwShortCutItem[] cutItemOwObjects = new OwShortCutItem[keys.size()];
        for (String id : keys) {
            cutItemOwObjects[count] = this.m_shortcutsMap.get(id);
            ++count;
        }
        Arrays.sort(cutItemOwObjects, comparator_p);
        return Arrays.asList(cutItemOwObjects);
    }

    public void setShortcuts(List shortcuts_p) {
        this.m_shortcutsMap = new HashMap<String, OwShortCutItem>();
        if (this.m_shortcutsMap != null) {
            for (int i = 0; i < shortcuts_p.size(); ++i) {
                OwShortCutItem owObject = (OwShortCutItem)shortcuts_p.get(i);
                try {
                    String keyId = owObject.getId();
                    this.m_shortcutsMap.put(keyId, owObject);
                    continue;
                }
                catch (Exception e) {
                    LOG.warn((Object)"OwShortCutDocumentHelper.setShortcuts(): Exception", (Throwable)e);
                }
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        List shortcuts = this.getShortcuts();
        stringBuffer.append("Shortcut Documents:");
        for (int i = 0; i < shortcuts.size(); ++i) {
            OwShortCutItem owObject = (OwShortCutItem)shortcuts.get(i);
            stringBuffer.append("\n" + i + " : " + owObject.getName());
        }
        return stringBuffer.toString();
    }

    public void refresh(OwRepository repository_p) throws Exception {
        HashMap<String, OwShortCutItem> temporaryShortcutsMap = new HashMap<String, OwShortCutItem>();
        Collection<OwShortCutItem> values = this.m_shortcutsMap.values();
        for (OwShortCutItem owShortCutItem : values) {
            owShortCutItem.refresh(repository_p);
            temporaryShortcutsMap.put(owShortCutItem.getId(), owShortCutItem);
        }
        this.m_shortcutsMap = temporaryShortcutsMap;
    }

    public String getPersistentId(String id_p) {
        String result = id_p;
        if (this.m_shortcutsMap.containsKey(id_p)) {
            try {
                result = this.m_shortcutsMap.get(id_p).getPersistentId();
            }
            catch (Exception e) {
                LOG.debug((Object)"Cannot find the persistent id, continue with current id.", (Throwable)e);
            }
        }
        return result;
    }

    private class ShortCutComparator
    implements Comparator {
        private ShortCutComparator() {
        }

        public int compare(Object o1_p, Object o2_p) {
            try {
                String name1 = ((OwShortCutItem)o1_p).getName();
                String name2 = ((OwShortCutItem)o2_p).getName();
                if (name1 == null && name2 == null) {
                    return 0;
                }
                if (name1 == null) {
                    return -1;
                }
                if (name2 == null) {
                    return 1;
                }
                name1 = name1.toUpperCase();
                name2 = name2.toUpperCase();
                return name1.compareTo(name2);
            }
            catch (Exception e) {
                LOG.error((Object)"Could not compare shrotcuts! Is this a deleted object reference ? ", (Throwable)e);
                return -1;
            }
        }
    }
}

