/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owshortcut;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.OwRepository;
import com.wewebu.ow.server.ecm.OwStandardObjectReference;
import com.wewebu.ow.server.ecm.OwVersion;
import com.wewebu.ow.server.ecm.OwVersionSeries;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.plug.owshortcut.OwShortCutDocument;
import com.wewebu.ow.server.plug.owshortcut.OwShortCutException;
import com.wewebu.ow.server.plug.owshortcut.OwShortCutItem;
import com.wewebu.ow.server.plug.owshortcut.OwShortCutItemContext;
import com.wewebu.ow.server.plug.std.log.OwLog;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class OwShortCutItemOwObject
extends OwShortCutItem {
    private static final Logger LOG = OwLog.getLogger(OwShortCutDocument.class);
    public static final String DEFAULT_PATH_DELIMITER = "/";
    protected static final String SUBPATH_DELIMITER = "!#!";
    private OwObjectReference m_objref;
    private OwObjectReference m_subpathObjectRef;
    private String m_subpath;
    private String m_displaysubpath;
    protected int m_iMaxChildSize = 50;

    protected OwShortCutItemOwObject(String persistString_p, OwShortCutItemContext context_p, int maxChildSize_p) throws Exception {
        this.m_iMaxChildSize = maxChildSize_p;
        String rest = persistString_p;
        int index = rest.indexOf(SUBPATH_DELIMITER);
        if (-1 != index) {
            this.m_subpath = rest.substring(0, index);
            if (this.m_subpath.length() == 0) {
                this.m_subpath = null;
            }
            rest = rest.substring(index + SUBPATH_DELIMITER.length());
        }
        if (-1 != (index = rest.indexOf(SUBPATH_DELIMITER))) {
            this.m_displaysubpath = rest.substring(0, index);
            if (this.m_displaysubpath.length() == 0) {
                this.m_displaysubpath = null;
            }
            rest = rest.substring(index + SUBPATH_DELIMITER.length());
        }
        OwNetwork network = ((OwMainAppContext)context_p.getContext()).getNetwork();
        this.m_objref = new OwStandardObjectReference(rest, (OwRepository)network);
        this.m_subpathObjectRef = null;
        if (this.m_subpath != null) {
            this.m_subpathObjectRef = this.m_displaysubpath != null && this.m_objref.getResourceID() != null ? new OwDependentObjectReference(this.m_objref, this.m_displaysubpath, (OwRepository)network) : this.findPathReference(this.m_objref, this.m_subpath, DEFAULT_PATH_DELIMITER);
        }
    }

    protected OwShortCutItemOwObject(OwObjectReference ref_p) {
        this.m_objref = ref_p;
    }

    @Deprecated
    public OwShortCutItemOwObject(OwObjectReference ref_p, String path_p, String subdisplaypath_p, int maxChildSize_p) {
        this.m_iMaxChildSize = maxChildSize_p;
        this.m_objref = ref_p;
        this.m_subpath = path_p;
        this.m_subpathObjectRef = null;
        this.m_displaysubpath = subdisplaypath_p;
        if (this.m_subpath != null) {
            try {
                this.m_subpathObjectRef = this.findPathReference(ref_p, path_p, DEFAULT_PATH_DELIMITER);
            }
            catch (Exception e) {
                try {
                    LOG.error((Object)("OwShortCutItemOwObject.OwShortCutItemOwObject(): could not find path reference for path " + this.m_subpath + " with root DMSID " + this.m_objref.getDMSID()), (Throwable)e);
                }
                catch (Exception e1) {
                    LOG.error((Object)"OwShortCutItemOwObject.OwShortCutItemOwObject(): could not get object reference DMSID.", (Throwable)e);
                }
            }
        }
    }

    public OwShortCutItemOwObject(OwObjectReference root, OwObjectReference target, String displayPath, String idPath) {
        this.m_objref = root;
        this.m_subpath = idPath;
        this.m_subpathObjectRef = target;
        this.m_displaysubpath = displayPath;
    }

    @Deprecated
    protected OwObjectReference findPathReference(OwObjectReference root_p, String path_p, String pathDelimiter_p) throws Exception {
        LOG.warn((Object)"!Performance! Retrieval of ShortCut item by path can slow down login.");
        StringTokenizer pathTokenizer = new StringTokenizer(path_p, pathDelimiter_p);
        OwObject pathObject = root_p.getInstance();
        while (pathTokenizer.hasMoreTokens()) {
            OwObject pathObjectChild = null;
            String pathToken = pathTokenizer.nextToken();
            OwObjectCollection children = pathObject.getChilds(new int[]{4097, 8193, 12289}, null, null, this.m_iMaxChildSize, 0, null);
            for (OwObject child : children) {
                if (!child.getID().equals(pathToken)) continue;
                pathObjectChild = child;
                break;
            }
            if (pathObjectChild != null) {
                pathObject = pathObjectChild;
                continue;
            }
            return null;
        }
        return pathObject;
    }

    @Override
    public String getName() {
        if (this.m_subpath != null) {
            return this.m_objref.getName() + this.m_displaysubpath;
        }
        return this.m_objref.getName();
    }

    @Override
    public String getId() throws Exception {
        if (this.m_subpath != null) {
            return Integer.toString(this.m_objref.getDMSID().hashCode()) + this.m_subpath.hashCode();
        }
        return Integer.toString(this.m_objref.getDMSID().hashCode());
    }

    public static synchronized Collection createShortCutItems(Collection objects_p) {
        LinkedList<OwShortCutItemOwObject> ret = new LinkedList<OwShortCutItemOwObject>();
        for (OwObjectReference obj : objects_p) {
            ret.add(new OwShortCutItemOwObject(obj));
        }
        return ret;
    }

    @Deprecated
    public static OwShortCutItem createShortCutItem(OwObjectReference object_p, String path_p, String subdisplaypath_p, int maxChildSize_p) {
        return new OwShortCutItemOwObject(object_p, path_p, subdisplaypath_p, maxChildSize_p);
    }

    @Override
    protected String getPersistString() throws Exception {
        StringBuilder ret = new StringBuilder();
        if (null != this.m_subpath) {
            ret.append(this.m_subpath);
        }
        ret.append(SUBPATH_DELIMITER);
        if (null != this.m_displaysubpath) {
            ret.append(this.m_displaysubpath);
        }
        ret.append(SUBPATH_DELIMITER);
        ret.append(OwStandardObjectReference.getCompleteReferenceString((OwObjectReference)this.m_objref, (int)1));
        return ret.toString();
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void insertIcon(OwShortCutItemContext context_p, Writer w_p) throws Exception {
        context_p.getMimeManager().insertIconLink(w_p, this.m_objref, this.m_subpath);
    }

    @Override
    public void insertLabel(OwShortCutItemContext context_p, Writer w_p) throws Exception {
        context_p.getMimeManager().insertTextLink(w_p, this.getName(), this.m_objref, this.m_subpath);
    }

    public OwObjectReference getObjRef() {
        if (this.m_subpath != null) {
            return this.m_subpathObjectRef;
        }
        return this.m_objref;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        try {
            buffer.append("OwShortCutItemOwObject[");
            if (null != this.m_objref) {
                buffer.append("\n- m_objref:DMSID=").append(this.m_objref.getDMSID());
                buffer.append("\n- m_objref:Name =").append(this.m_objref.getName());
                buffer.append("\n- PersistString =");
                try {
                    buffer.append(this.getPersistString());
                }
                catch (Exception ex) {
                    buffer.append(ex.getMessage());
                }
            } else {
                buffer.append("\n- m_objref: null");
                buffer.append("\n]");
            }
        }
        catch (Exception e) {
            LOG.error((Object)"OwShortCutItemOwObject.toString():could not create shortcut string!", (Throwable)e);
        }
        return buffer.toString();
    }

    @Override
    public void refresh(OwRepository repository_p) throws OwException {
        try {
            if (this.persistentId == null) {
                this.persistentId = this.getId();
            }
            if (this.m_subpath != null) {
                this.m_subpathObjectRef = this.updateObjectReference(repository_p, this.m_subpathObjectRef);
            } else if (this.m_objref != null) {
                OwObjectReference objectReference;
                this.m_objref = objectReference = this.updateObjectReference(repository_p, this.m_objref);
            }
        }
        catch (OwException owex) {
            throw owex;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Cannot refresh object, Invalid object reference", (Throwable)e);
            }
            throw new OwShortCutException("Invalid object reference", (Throwable)e);
        }
    }

    protected OwObjectReference updateObjectReference(OwRepository repository_p, OwObjectReference originalReference_p) throws Exception {
        OwObjectReference result = originalReference_p;
        if (result != null) {
            OwObject object = originalReference_p.getInstance();
            object = this.replaceWithLatestVersion(object);
            String refString = OwStandardObjectReference.getCompleteReferenceString((OwObjectReference)object, (int)1);
            result = new OwStandardObjectReference(refString, repository_p);
        }
        return result;
    }

    protected OwObject replaceWithLatestVersion(OwObject source_p) throws OwException {
        OwObject result = source_p;
        try {
            OwVersion latestVersion;
            OwVersionSeries versionSeries;
            if (result.hasVersionSeries() && (versionSeries = result.getVersionSeries()) != null && (latestVersion = versionSeries.getLatest()) != null) {
                result = versionSeries.getObject(latestVersion);
            }
        }
        catch (OwObjectNotFoundException nfe) {
            throw nfe;
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot get the last version", (Throwable)e);
        }
        return result;
    }

    protected static class OwDependentObjectReference
    implements OwObjectReference {
        private OwObjectReference parentRef;
        private String subPath;
        private OwRepository repo;
        private OwObject instance;

        public OwDependentObjectReference(OwObjectReference parentRef, String subPath, OwRepository repo) {
            this.parentRef = parentRef;
            this.subPath = subPath;
            this.repo = repo;
        }

        public String getResourceID() throws Exception {
            return this.parentRef.getResourceID();
        }

        public OwObject getInstance() throws Exception {
            if (this.instance == null) {
                String parentPath = this.parentRef.getInstance().getPath();
                this.instance = parentPath.endsWith(OwShortCutItemOwObject.DEFAULT_PATH_DELIMITER) ? this.repo.getObjectFromPath(parentPath + this.subPath.substring(1), false) : this.repo.getObjectFromPath(parentPath + this.subPath, false);
            }
            return this.instance;
        }

        public String getName() {
            try {
                return this.getInstance().getName();
            }
            catch (Exception e) {
                String msg = "Cannot get name from referenced object, returning path info instead. path = " + this.subPath;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)msg, (Throwable)e);
                } else {
                    LOG.warn((Object)msg);
                }
                return this.subPath;
            }
        }

        public String getID() {
            try {
                return this.getInstance().getID();
            }
            catch (Exception e) {
                LOG.warn((Object)"Cannot get Id from referenced Object", (Throwable)e);
                return "";
            }
        }

        public int getType() {
            try {
                return this.getInstance().getType();
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Could not get instance from repository, returning undefined type", (Throwable)e);
                } else {
                    LOG.info((Object)"Not able to get Type information from instance, returning undefined type");
                }
                return 0;
            }
        }

        public String getDMSID() throws Exception {
            return this.getInstance().getDMSID();
        }

        public int getPageCount() throws Exception {
            return 0;
        }

        public String getMIMEType() throws Exception {
            return this.getInstance().getMIMEType();
        }

        public String getMIMEParameter() throws Exception {
            return this.getInstance().getMIMEParameter();
        }

        public boolean hasContent(int iContext_p) throws Exception {
            return this.getInstance().hasContent(iContext_p);
        }
    }
}

