/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owshortcut;

import com.wewebu.ow.server.app.OwMasterView;
import com.wewebu.ow.server.app.OwSubLayout;
import com.wewebu.ow.server.app.OwSubNavigationView;
import com.wewebu.ow.server.plug.owshortcut.OwSavedSearchesView;
import com.wewebu.ow.server.plug.owshortcut.OwShortCutDocument;
import com.wewebu.ow.server.plug.owshortcut.OwShortCutFunctionsView;
import com.wewebu.ow.server.plug.owshortcut.OwShortCutItemView;
import com.wewebu.ow.server.plug.std.log.OwLog;
import com.wewebu.ow.server.ui.OwView;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.List;
import org.apache.log4j.Logger;

public class OwShortCutView
extends OwMasterView {
    private static final Logger LOG = OwLog.getLogger(OwShortCutView.class);
    private static final String VIEW_MASKS_NODE_NAME = "viewmasks";
    private static final String SUBVIEW_MASKS_NODE_NAME = "subview";
    private OwShortCutItemView m_itemview;
    private OwSavedSearchesView m_searchesView;
    private OwSubLayout m_Layout;
    private OwSubNavigationView m_subNavigation;
    public static final int VIEW_MASK_DISPLAY_ALL = 1;
    public static final int VIEW_MASK_DISPLAY_DOCUMENTS = 2;
    public static final int VIEW_MASK_DISPLAY_FOLDERS = 4;
    public static final int VIEW_MASK_DISPLAY_OTHER = 8;
    public static final int VIEW_MASK_DISPLAY_STORED_SEARCHES = 16;
    OwShortCutDocument owShorcutDocument;
    protected int m_iViewMask = 0;

    protected void init() throws Exception {
        super.init();
        this.createViewMask();
        this.m_itemview = this.createShortCutItemView();
        this.m_searchesView = this.createSavedSearchesView();
        this.m_Layout = new OwSubLayout();
        this.owShorcutDocument = (OwShortCutDocument)this.getDocument();
        this.addView((OwView)this.m_Layout, null);
        this.m_subNavigation = new OwSubNavigationView();
        this.m_Layout.addView((OwView)this.m_subNavigation, 0, null);
        this.m_Layout.addView((OwView)new OwShortCutFunctionsView(), 1, null);
        this.m_Layout.addViewReference(this.m_subNavigation.getViewReference(), 2);
        String designRoot = this.getContext().getDesignURL();
        if (this.hasViewMask(1)) {
            this.m_subNavigation.addView((OwView)this.m_itemview, this.getContext().localize("plug.owshorcut.filterall", "All"), null, null, (Object)0, this.getContext().localize("plug.owshorcut.filterall_tooltip", "Show all favorites"));
        }
        if (this.hasViewMask(2)) {
            this.m_subNavigation.addView((OwView)this.m_itemview, this.getContext().localize("plug.owshorcut.filterdocuments", "Documents"), null, designRoot + "/micon/doc.png", (Object)1, this.getContext().localize("plug.owshorcut.filterdocuments_tooltip", "Show document favorites"));
        }
        if (this.hasViewMask(4)) {
            this.m_subNavigation.addView((OwView)this.m_itemview, this.getContext().localize("plug.owshorcut.filterfolders", "eFiles / Folders"), null, designRoot + "/micon/folder.png", (Object)2, this.getContext().localize("plug.owshorcut.filterfolders_tooltip", "Show eFile or folder favorites"));
        }
        if (this.hasViewMask(8)) {
            this.m_subNavigation.addView((OwView)this.m_itemview, this.getContext().localize("plug.owshorcut.filterrest", "Other"), null, designRoot + "/micon/custom.png", (Object)3, this.getContext().localize("plug.owshorcut.filterrest_tooltip", "Shows other favorites"));
        }
        if (this.hasViewMask(16)) {
            if (this.hasViewMask(8) || this.hasViewMask(4) || this.hasViewMask(2) || this.hasViewMask(1)) {
                this.m_subNavigation.addDelimiter();
            }
            this.m_subNavigation.addView((OwView)this.m_searchesView, this.getContext().localize("plug.owshorcut.storedsearch", "Stored Searches"), null, designRoot + "/micon/stored_search.png", null, this.getContext().localize("plug.owshorcut.storedsearch_tooltip", "Stored Searches"));
        }
        this.m_searchesView.setDocument(this.getDocument());
        this.m_subNavigation.navigateFirst();
    }

    public OwShortCutItemView getItemView() {
        return this.m_itemview;
    }

    public OwShortCutItemView createShortCutItemView() {
        return new OwShortCutItemView();
    }

    public OwSavedSearchesView createSavedSearchesView() {
        return new OwSavedSearchesView();
    }

    protected void onActivate(int index_p, Object reason_p) throws Exception {
        if (this.m_iViewMask > 0) {
            super.onActivate(index_p, reason_p);
        }
    }

    protected int createViewMask() {
        try {
            OwXMLUtil node = this.getConfigNode().getSubUtil(SUBVIEW_MASKS_NODE_NAME);
            if (null == node) {
                return this.defaultViewMask();
            }
            OwXMLUtil subnode = node.getSubUtil(VIEW_MASKS_NODE_NAME);
            List maskValues = subnode.getSafeStringList();
            for (String sMask : maskValues) {
                this.m_iViewMask |= ((Object)((Object)this)).getClass().getField(sMask).getInt(null);
            }
        }
        catch (Exception e) {
            LOG.info((Object)"Subview masks are not configured. Using default settings.");
        }
        return this.m_iViewMask;
    }

    protected boolean hasViewMask(int iViewMask_p) {
        return (iViewMask_p & this.m_iViewMask) != 0;
    }

    protected int defaultViewMask() {
        this.m_iViewMask = 31;
        return this.m_iViewMask;
    }
}

