/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owbpm;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwMasterView;
import com.wewebu.ow.server.app.OwSubLayout;
import com.wewebu.ow.server.app.OwSubNavigationView;
import com.wewebu.ow.server.ecm.OwStatusContextException;
import com.wewebu.ow.server.plug.owbpm.OwBPMDocument;
import com.wewebu.ow.server.plug.owbpm.OwBPMFunctionView;
import com.wewebu.ow.server.plug.owbpm.OwBPMVirtualQueue;
import com.wewebu.ow.server.plug.owbpm.OwBPMWorkItemListView;
import com.wewebu.ow.server.plug.owbpm.log.OwLog;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.ui.OwNavigationView;
import com.wewebu.ow.server.ui.OwView;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class OwBPMView
extends OwMasterView
implements OwClientRefreshContext {
    private static final Logger LOG = OwLog.getLogger(OwBPMView.class);
    private OwBPMWorkItemListView m_workItemListView;
    private OwSubLayout m_Layout = new OwSubLayout();
    private OwSubNavigationView m_subNavigation;
    private boolean m_fInitialized;
    private OwBPMFunctionView functionView;

    protected void init() throws Exception {
        super.init();
        this.m_workItemListView = this.createWorkItemListView();
        this.addView((OwView)this.m_Layout, null);
        this.m_subNavigation = new OwSubNavigationView();
        this.m_Layout.addView((OwView)this.m_subNavigation, 0, null);
        this.functionView = new OwBPMFunctionView();
        this.m_Layout.addView((OwView)this.functionView, 1, null);
        this.m_Layout.addViewReference(this.m_subNavigation.getViewReference(), 2);
    }

    protected OwBPMWorkItemListView createWorkItemListView() {
        return new OwBPMWorkItemListView();
    }

    protected void onActivate(int iIndex_p, Object oReason_p) throws Exception {
        super.onActivate(iIndex_p, oReason_p);
        if (!this.m_fInitialized) {
            this.initOnActivate();
            this.m_fInitialized = true;
            this.updateQueueCount();
            this.getSubNavigation().navigateFirst();
        } else {
            this.m_workItemListView.update();
            this.updateQueueCount();
        }
    }

    private void initOnActivate() throws Exception {
        Collection queues = ((OwBPMDocument)this.getDocument()).getWorkQueues();
        if (queues.size() != 0) {
            for (OwBPMVirtualQueue queue : queues) {
                if (null == queue) {
                    this.getSubNavigation().addDelimiter();
                    continue;
                }
                this.getSubNavigation().addView((OwView)this.m_workItemListView, queue.getDisplayName(), null, queue.getIcon(), (Object)queue, queue.getDisplayName());
            }
            this.functionView.setRefreshContext(this);
            this.m_workItemListView.setRefreshContext(this);
        }
    }

    public void onUpdate(OwEventTarget caller_p, int iCode_p, Object param_p) throws Exception {
        switch (iCode_p) {
            case 3: {
                this.updateQueueCount();
            }
        }
    }

    private void updateQueueCount() throws Exception {
        List tablist = this.getSubNavigation().getTabList();
        for (int i = 0; i < tablist.size(); ++i) {
            OwNavigationView.OwTabInfo tab = (OwNavigationView.OwTabInfo)tablist.get(i);
            try {
                OwBPMVirtualQueue queue = (OwBPMVirtualQueue)tab.getReasonObject();
                try {
                    int iCount = queue.getItemCount(1);
                    StringBuffer buf = new StringBuffer();
                    buf.append(queue.getDisplayName());
                    buf.append("<span class='OwTaskView_boxcount'>");
                    buf.append("(");
                    buf.append(String.valueOf(iCount));
                    buf.append(")");
                    buf.append("</span>");
                    this.m_subNavigation.setTitle(buf.toString(), i);
                    if (queue.isHideIfEmpty()) {
                        this.m_subNavigation.setVisible(i, 0 != iCount);
                        continue;
                    }
                    this.m_subNavigation.setVisible(i, true);
                }
                catch (OwStatusContextException e) {
                    LOG.debug((Object)"Could not retrieve item count for queue.", (Throwable)e);
                }
                continue;
            }
            catch (NullPointerException e1) {
                continue;
            }
            catch (ClassCastException e2) {
                // empty catch block
            }
        }
    }

    public void onClientRefreshContextUpdate(int iReason_p, Object param_p) throws Exception {
        switch (iReason_p) {
            case 2: {
                break;
            }
            case 3: 
            case 11: {
                this.m_workItemListView.update();
            }
        }
    }

    public OwBPMWorkItemListView getWorkItemListView() {
        return this.m_workItemListView;
    }

    public String getRefreshURL() {
        return this.getSubNavigation().getNavigateEventURL(this.getSubNavigation().getNavigationIndex());
    }

    protected OwSubNavigationView getSubNavigation() {
        return this.m_subNavigation;
    }
}

