/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owbpm;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwFieldManagerControl;
import com.wewebu.ow.server.app.OwMasterDocument;
import com.wewebu.ow.server.app.OwMaxMinButtonControlView;
import com.wewebu.ow.server.app.OwMenuView;
import com.wewebu.ow.server.app.OwSearchCriteriaView;
import com.wewebu.ow.server.app.OwSmallSubMenuView;
import com.wewebu.ow.server.app.OwSubMenuView;
import com.wewebu.ow.server.collections.OwIterable;
import com.wewebu.ow.server.collections.OwLoadContext;
import com.wewebu.ow.server.collections.OwPageableObject;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListView;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListViewControl;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.bpm.OwWorkitemContainer;
import com.wewebu.ow.server.exceptions.OwAccessDeniedException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwFieldProvider;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.plug.owbpm.OwBPMAttachmentFieldControl;
import com.wewebu.ow.server.plug.owbpm.OwBPMDocument;
import com.wewebu.ow.server.plug.owbpm.OwBPMGroupBoxControl;
import com.wewebu.ow.server.plug.owbpm.OwBPMVirtualQueue;
import com.wewebu.ow.server.plug.owbpm.log.OwLog;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.ui.OwLayout;
import com.wewebu.ow.server.ui.OwView;
import java.io.Writer;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class OwBPMWorkItemListView
extends OwLayout
implements OwObjectListView.OwObjectListViewEventListner {
    private static final Logger LOG = OwLog.getLogger(OwBPMWorkItemListView.class);
    public static final int WORKITEM_LIST_REGION = 1;
    public static final int SEARCH_CRITERIA_REGION = 2;
    public static final int MIN_MAX_CONTROL_VIEW = 3;
    public static final int SEARCH_CRITERIA_BUTTON_REGION = 4;
    public static final int OPTION_MENU_REGION = 5;
    public static final int OBJECT_LIST_CONTROL_REGION = 6;
    protected OwSearchCriteriaView m_SearchCriteriaView = new OwSearchCriteriaView();
    protected OwMenuView m_FilterCriteriaBtnView;
    protected OwMenuView m_OptionMenuView;
    protected OwBPMVirtualQueue m_currentQueue = null;
    protected OwObjectListViewControl m_listcontrol = new OwObjectListViewControl();
    protected int m_iResubmitFilterToggleBtnIndex;
    private int m_searchButtonId;

    protected void init() throws Exception {
        super.init();
        this.addView((OwView)this.m_listcontrol, 6, null);
        this.addViewReference(this.m_listcontrol.getViewReference(), 1);
        this.m_listcontrol.setConfigNode(((OwMasterDocument)this.getDocument()).getConfigNode().getSubNode("ResultListViews"));
        this.m_listcontrol.activateListView();
        this.getListView().setEventListner((OwObjectListView.OwObjectListViewEventListner)this);
        this.getListView().getFieldManager().attachFieldControlByType("com.wewebu.ow.server.ecm.OwObjectReference", (OwFieldManagerControl)new OwBPMAttachmentFieldControl(((OwBPMDocument)this.getDocument()).getConfigNode().getSafeStringList("AttachmentDocumentFunctions")), null);
        this.getListView().getFieldManager().attachFieldControlByType("com.wewebu.ow.server.ecm.OwObject", (OwFieldManagerControl)new OwBPMAttachmentFieldControl(((OwBPMDocument)this.getDocument()).getConfigNode().getSafeStringList("AttachmentDocumentFunctions")), null);
        this.getListView().getFieldManager().attachFieldControlByClass("OW_GROUPBOX_NAME", (OwFieldManagerControl)new OwBPMGroupBoxControl(this), null);
        this.addView((OwView)new OwMaxMinButtonControlView((OwView)this), 3, null);
        this.addView((OwView)this.m_SearchCriteriaView, 2, null);
        this.m_FilterCriteriaBtnView = new OwSubMenuView();
        this.addView((OwView)this.m_FilterCriteriaBtnView, 4, null);
        this.m_searchButtonId = this.m_FilterCriteriaBtnView.addFormMenuItem((OwEventTarget)this, this.getContext().localize("owsearch.OwBPMWorkItemListView.search", "Search"), "DoSearch", null, this.m_SearchCriteriaView.getFormName());
        this.m_FilterCriteriaBtnView.addMenuItem((OwEventTarget)this, this.getContext().localize("owsearch.OwBPMWorkItemListView.reset", "Reset"), "DoReset", null);
        this.m_OptionMenuView = new OwSmallSubMenuView();
        this.addView((OwView)this.m_OptionMenuView, 5, null);
        String title = this.getContext().localize("owsearch.OwBPMWorkItemListView.resubmitview", "Resubmission View");
        this.m_iResubmitFilterToggleBtnIndex = this.m_OptionMenuView.addMenuItem((OwEventTarget)this, title, null, "ToggleResubmitFilter", null, title);
    }

    public boolean isRegion(int iRegion_p) {
        switch (iRegion_p) {
            case 2: {
                try {
                    return this.m_currentQueue.getSearchTemplate() != null && this.m_currentQueue.getSearchTemplate().getSearch(false).getCriteriaList(1).size() != 0;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return super.isRegion(iRegion_p);
    }

    public OwBPMVirtualQueue getCurrentQueue() {
        return this.m_currentQueue;
    }

    public OwObjectListView getListView() {
        return this.m_listcontrol.getObjectListView();
    }

    public void onDoReset(HttpServletRequest request_p, Object oReason_p) throws Exception {
        if (this.m_currentQueue.getSearchTemplate() != null) {
            this.m_SearchCriteriaView.setCriteriaList(this.m_currentQueue.getSearchTemplate().getSearch(true).getCriteriaList(1));
            this.m_SearchCriteriaView.setJspFormular(this.m_currentQueue.getSearchTemplate().getJspLayoutPage());
            this.m_SearchCriteriaView.setHTMLFormular(this.m_currentQueue.getSearchTemplate().getHtmlLayout());
        }
        this.update();
    }

    public void onDoSearch(HttpServletRequest request_p, Object oReason_p) throws Exception {
        if (!this.m_SearchCriteriaView.onSubmitSearch(request_p)) {
            return;
        }
        this.update();
    }

    public void onToggleResubmitFilter(HttpServletRequest request_p, Object oReason_p) throws Exception {
        this.m_currentQueue.toggleResubmitFilter();
        this.m_OptionMenuView.check(this.m_currentQueue.isResubmitFilter(), this.m_iResubmitFilterToggleBtnIndex);
        this.update();
    }

    protected void onActivate(int iIndex_p, Object oReason_p) throws Exception {
        this.m_currentQueue = (OwBPMVirtualQueue)oReason_p;
        this.getDocument().update((OwEventTarget)this, 4, (Object)this.m_currentQueue);
        if (null != this.m_currentQueue.getSearchTemplate()) {
            this.m_SearchCriteriaView.setCriteriaList(this.m_currentQueue.getSearchTemplate().getSearch(false).getCriteriaList(1));
            this.m_SearchCriteriaView.setHTMLFormular(this.m_currentQueue.getSearchTemplate().getHtmlLayout());
            this.m_SearchCriteriaView.setJspFormular(this.m_currentQueue.getSearchTemplate().getJspLayoutPage());
            this.m_SearchCriteriaView.setFieldProvider((OwFieldProvider)this.m_currentQueue.getSearchTemplate());
            OwSearchTemplate st = this.m_currentQueue.getSearchTemplate();
            Collection stcolumns = st.getColumnInfoList();
            if (null != stcolumns && !stcolumns.isEmpty()) {
                this.getListView().setColumnInfo(st.getColumnInfoList());
            } else {
                this.getListView().setColumnInfo((Collection)this.m_currentQueue.getColumnInfo());
            }
        } else {
            this.m_SearchCriteriaView.setCriteriaList(null);
            this.m_SearchCriteriaView.setHTMLFormular(null);
            this.m_SearchCriteriaView.setJspFormular(null);
            this.m_SearchCriteriaView.setFieldProvider(null);
            this.getListView().setColumnInfo((Collection)this.m_currentQueue.getColumnInfo());
        }
        this.getListView().setSort(this.m_currentQueue.getSort());
        this.getListView().setFilter(this.m_currentQueue.getObjectListFilter());
        try {
            this.update();
        }
        catch (Exception e) {
            throw new OwAccessDeniedException(this.getContext().localize("plug.owbpm.OwBPMWorkItemListView.noaccesstoview", "Possibly, you do not have the required rights to view these objects."), (Throwable)e);
        }
        this.m_OptionMenuView.enable(this.m_iResubmitFilterToggleBtnIndex, this.m_currentQueue.canResubmit());
        this.m_OptionMenuView.check(this.m_currentQueue.isResubmitFilter(), this.m_iResubmitFilterToggleBtnIndex);
    }

    public void update() throws Exception {
        OwObjectCollection objectList = this.getListView().getObjectList();
        if (objectList != null) {
            objectList.clear();
        }
        OwBPMDocument document = (OwBPMDocument)this.getDocument();
        OwWorkitemContainer queueFolder = this.m_currentQueue.getQueueFolder();
        if (document.isUsePaging() && queueFolder instanceof OwPageableObject) {
            OwLoadContext loadContext = document.createLoadContext(this.m_currentQueue);
            loadContext.setFilter(this.getListView().getFilterSearch());
            OwIterable iterable = ((OwPageableObject)queueFolder).getChildren(loadContext);
            this.getListView().setObjectIterable(iterable, (OwObject)queueFolder);
        } else {
            this.getListView().setObjectList(this.m_currentQueue.getWorkItems(this.getListView().getFilterSearch()), (OwObject)queueFolder);
        }
        this.getDocument().update((OwEventTarget)this, 3, null);
    }

    public void setRefreshContext(OwClientRefreshContext eventlister_p) {
        this.getListView().setRefreshContext(eventlister_p);
    }

    protected void onRender(Writer w_p) throws Exception {
        this.serverSideDesignInclude("owbpm/OwBPMWorkItemListView.jsp", w_p);
        String navigateURL = this.m_FilterCriteriaBtnView.getNavigateEventURL(this.m_searchButtonId);
        this.getContext().registerKeyFormEvent(13, 0, navigateURL, null, this.getContext().localize("owsearch.OwBPMWorkItemListView.search", "Suchen"));
    }

    public void onObjectListViewSort(OwSort newSort_p, String strSortProperty_p) throws Exception {
        OwBPMDocument document = (OwBPMDocument)this.getDocument();
        OwWorkitemContainer queueFolder = this.m_currentQueue.getQueueFolder();
        if (document.isUsePaging() && queueFolder instanceof OwPageableObject) {
            OwLoadContext loadContext = document.createLoadContext(this.m_currentQueue);
            loadContext.setSorting(newSort_p);
            OwIterable iterable = ((OwPageableObject)queueFolder).getChildren(loadContext);
            this.getListView().setObjectIterable(iterable, (OwObject)queueFolder);
        } else {
            OwObjectCollection list = this.getListView().getObjectList();
            if (null != list) {
                list.sort(newSort_p);
                this.getListView().setObjectList(list, (OwObject)queueFolder);
            }
        }
    }

    public void onObjectListViewSelect(OwObject object_p, OwObject parent_p) throws Exception {
    }

    public void onObjectListViewFilterChange(OwSearchNode filterNode_p, OwObject parent_p) throws Exception {
        OwBPMDocument document = (OwBPMDocument)this.getDocument();
        OwWorkitemContainer queueFolder = this.m_currentQueue.getQueueFolder();
        if (document.isUsePaging() && queueFolder instanceof OwPageableObject) {
            OwLoadContext loadContext = document.createLoadContext(this.m_currentQueue);
            loadContext.setFilter(filterNode_p);
            OwIterable iterable = ((OwPageableObject)queueFolder).getChildren(loadContext);
            this.getListView().setObjectIterable(iterable, (OwObject)queueFolder);
        } else {
            this.getListView().setObjectList(this.m_currentQueue.getWorkItems(filterNode_p), null);
        }
    }

    public boolean onObjectListViewItemClick(OwObject obj_p) throws Exception {
        return false;
    }

    public OwWorkitemContainer getCurrentWorkitemcontainer() throws OwObjectNotFoundException {
        if (null == this.m_currentQueue) {
            String msg = "OwBPMWorkItemListView.getCurrentWorkitemcontainer: The current queue is null.";
            LOG.debug((Object)msg);
            throw new OwObjectNotFoundException(msg);
        }
        return this.m_currentQueue.getQueueFolder();
    }

    public void updateGroupBoxSelectFilter() throws Exception {
        this.getListView().getFilter().setActive("OW_GROUPBOX_NAME", true);
        this.update();
    }

    public String onObjectListViewGetRowClassName(int iIndex_p, OwObject obj_p) {
        String sStyle = this.getCurrentQueue().applyRules(obj_p);
        if (sStyle == null) {
            return null;
        }
        return sStyle;
    }
}

