/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owbpm.plug;

import com.wewebu.ow.server.app.OwFieldManager;
import com.wewebu.ow.server.app.OwJspFormConfigurator;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMimeManager;
import com.wewebu.ow.server.app.OwStandardSequenceDialog;
import com.wewebu.ow.server.app.OwSubLayout;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.plug.owbpm.log.OwLog;
import com.wewebu.ow.server.plug.owbpm.plug.OwBPMDisplayWorkflowDialogBuilder;
import com.wewebu.ow.server.ui.OwAppContext;
import com.wewebu.ow.server.ui.OwDialog;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class OwBPMDisplayWorkflowDialog
extends OwStandardSequenceDialog {
    private static final Logger LOG = OwLog.getLogger(OwBPMDisplayWorkflowDialog.class);
    private static final String D_BPM_TASK_BPM_STATUS = "D:bpm:task.bpm:status";
    private static final String D_BPM_TASK_BPM_DUE_DATE = "D:bpm:task.bpm:dueDate";
    private static final String PROP_OW_ASSIGNEE = "OW_ASSIGNEE";
    private Set<OwObject> objects;
    private OwFieldManager m_fieldManager;
    private OwJspFormConfigurator jspFormConfigurator;
    protected List<OwObject> m_items = new LinkedList<OwObject>();
    protected int m_iIndex = 0;
    protected OwMimeManager m_MimeManager;
    private OwSubLayout m_Layout;
    protected OwObject m_ParentObject;
    protected int m_iMaxElementSize;

    private OwBPMDisplayWorkflowDialog createNewDialog(Set<OwObject> objects, OwObject oParent_p) {
        return new OwBPMDisplayWorkflowDialogBuilder().items(this.m_items).index(this.m_iIndex).parentObject(this.m_ParentObject).build();
    }

    public OwBPMDisplayWorkflowDialog(OwBPMDisplayWorkflowDialogBuilder builder) {
        this.m_items.addAll(builder.getItems());
        this.m_iIndex = builder.getIndex();
        this.m_ParentObject = builder.getParentObject();
        this.m_Layout = new OwSubLayout();
        this.m_Layout.setCustomRegionAttributes(builder.getLayoutRegionAttributes());
    }

    protected void init() throws Exception {
        super.init();
        this.m_fieldManager = ((OwMainAppContext)this.getContext()).createFieldManager();
        OwMainAppContext context = (OwMainAppContext)this.getContext();
        try {
            this.m_MimeManager = this.createMimeManager();
            this.m_MimeManager.attach((OwAppContext)context, null);
        }
        catch (Exception e) {
            LOG.debug((Object)"Could not create MimeManager  ", (Throwable)e);
        }
    }

    public void renderMainRegion(Writer w_p) throws Exception {
        this.serverSideDesignInclude("owbpm/OwBPMDisplayWorkflowDialog.jsp", w_p);
    }

    public void renderRegion(Writer w_p, int iRegion_p) throws Exception {
        switch (iRegion_p) {
            case 2: {
                this.renderMainRegion(w_p);
                break;
            }
            case 3: {
                this.renderTitleRegion(w_p);
                break;
            }
            case 1: {
                this.renderSequenceNumber(w_p);
                break;
            }
            case 4: {
                this.renderHelpButton(w_p);
                break;
            }
            default: {
                super.renderRegion(w_p, iRegion_p);
            }
        }
    }

    public void detach() {
        super.detach();
        if (null != this.m_fieldManager) {
            this.m_fieldManager.detach();
        }
        this.m_MimeManager.reset();
        this.m_MimeManager.detach();
    }

    public boolean onCancel(HttpServletRequest request_p) throws Exception {
        this.closeDialog();
        return true;
    }

    public Set<OwObject> getObjects() {
        return this.objects;
    }

    public List<String> tooltipLinesFor(OwObject object) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(String.format("<b>%s:</b> %s", this.getContext().localize("owlabel.bpm:taskId", "Task ID"), object.getID()));
        this.addPropToTooltip(object, lines, D_BPM_TASK_BPM_DUE_DATE);
        this.addPropToTooltip(object, lines, D_BPM_TASK_BPM_STATUS);
        this.addPropToTooltip(object, lines, PROP_OW_ASSIGNEE);
        return lines;
    }

    private void addPropToTooltip(OwObject object, List<String> lines, String propName) {
        try {
            OwProperty property = object.getProperty(propName);
            if (null != property) {
                StringWriter stringWriter = new StringWriter();
                this.m_fieldManager.insertReadOnlyField((Writer)stringWriter, (OwField)property);
                String propertyValString = stringWriter.toString();
                stringWriter = new StringWriter();
                this.m_fieldManager.insertLabel((Writer)stringWriter, true, true, (OwField)property, "", true);
                String propertyNameString = stringWriter.toString();
                lines.add(String.format("<b>%s: </b>%s", propertyNameString, propertyValString));
            }
        }
        catch (Exception e) {
            LOG.debug((Object)("Could not retrieve property " + propName), (Throwable)e);
        }
    }

    public OwObject getItem() {
        return this.m_items.get(this.m_iIndex);
    }

    public boolean hasNext() throws Exception {
        return this.m_iIndex < this.m_items.size() - 1;
    }

    public boolean hasPrev() throws Exception {
        return this.m_iIndex > 0;
    }

    public int getCount() {
        return this.m_items.size();
    }

    public void prev(boolean fRemoveCurrent_p) throws Exception {
        if (fRemoveCurrent_p) {
            throw new OwNotSupportedException("OwEditPropertiesDialog.prev(fRemoveCurrent_p==true) not supported.");
        }
        this.m_iIndex = this.hasPrev() ? --this.m_iIndex : this.m_items.size() - 1;
        this.createNewDialog();
    }

    public void next(boolean fRemoveCurrent_p) throws Exception {
        if (fRemoveCurrent_p) {
            if (this.getCount() == 1) {
                super.closeDialog();
                return;
            }
            this.m_items.remove(this.m_iIndex);
            if (this.m_iIndex >= this.m_items.size()) {
                this.m_iIndex = 0;
            }
        } else {
            this.m_iIndex = this.hasNext() ? ++this.m_iIndex : 0;
        }
        this.createNewDialog();
    }

    protected OwBPMDisplayWorkflowDialogBuilder createDialogBuilder() {
        return new OwBPMDisplayWorkflowDialogBuilder();
    }

    protected void createNewDialog() throws Exception {
        OwBPMDisplayWorkflowDialog dialog = new OwBPMDisplayWorkflowDialogBuilder().items(this.m_items).index(this.m_iIndex).parentObject(this.m_ParentObject).maxElementSize(this.m_iMaxElementSize).layoutRegionAttributes(this.m_Layout.getCustomRegionAttributes()).build();
        dialog.setJspConfigurator(this.getJspConfigurator());
        dialog.setHelp(this.m_strHelpPath);
        dialog.setTitle(this.getTitle());
        dialog.setInfoIcon(this.m_strInfoIconURL);
        super.closeDialog();
        this.getContext().openDialog((OwDialog)dialog, this.m_Listener);
    }

    public OwJspFormConfigurator getJspConfigurator() {
        return this.jspFormConfigurator;
    }

    public void setJspConfigurator(OwJspFormConfigurator jspFormConfigurator_p) {
        this.jspFormConfigurator = jspFormConfigurator_p;
    }

    private void renderTitleRegion(Writer w_p) throws Exception {
        this.m_MimeManager.reset();
        this.serverSideDesignInclude("owbpm/OwBPMDisplayWorkflowDialogTitle.jsp", w_p);
    }

    public OwMimeManager getMimeManager() {
        return this.m_MimeManager;
    }

    protected OwMimeManager createMimeManager() {
        return new OwMimeManager();
    }

    public boolean isRegion(int iRegion_p) {
        switch (iRegion_p) {
            case 3: {
                return true;
            }
            case 6: {
                return true;
            }
        }
        return super.isRegion(iRegion_p);
    }

    public void renderSequenceNumber(Writer w_p) throws Exception {
        w_p.write("<div class=\"floatleft\">");
        w_p.write("     <div class=\"floatleft\">");
        this.renderCloseButton(w_p);
        w_p.write("     </div>");
        w_p.write("     <div class=\"floatleft\">");
        w_p.write("         <div id=\"OwStandardDialog_SEQUENCEBUTTONS\">");
        this.renderNavigationButtons(w_p);
        w_p.write("         </div>");
        w_p.write("         <div  style=\"text-align:center;\" id=\"OwStandardDialog_PAGENR\">");
        w_p.write("<span class=\"OwEditProperties_Versiontext\"> ");
        int curentItem = this.m_iIndex + 1;
        if (this.getCount() > 1) {
            w_p.write(curentItem + " " + this.getContext().localize("owdocprops.OwEditPropertiesDialog.pageoffrom", "from") + " " + this.getCount());
        }
        w_p.write("</span>");
        w_p.write("&nbsp;");
        w_p.write("         </div>");
        w_p.write("     </div>");
        w_p.write("</div>");
    }
}

