/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owbpm.plug;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwUserSelectDialog;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecm.bpm.OwWorkitem;
import com.wewebu.ow.server.ecm.bpm.OwWorkitemContainer;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.plug.owbpm.log.OwLog;
import com.wewebu.ow.server.plug.owbpm.plug.OwBPMInsertNoteDialog;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.ui.OwEventTarget;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class OwBPMReassignDialog
extends OwBPMInsertNoteDialog
implements OwDialog.OwDialogListener {
    private static final Logger LOG = OwLog.getLogger(OwBPMReassignDialog.class);
    public static final String DESTINATION_WEB_KEY = "destination";
    public static final String PUBLIC_CONTAINER_NAME_WEB_KEY = "publiccontname";
    public static final String DEFAULT_USER_SELECTION_WEB_KEY = "defaultuser";
    public static final int DESTINATION_OWN_INBOX_VALUE = 1;
    public static final int DESTINATION_OTHER_INBOX_VALUE = 2;
    public static final int DESTINATION_OTHER_PUBLICBOX_VALUE = 3;
    public static final int OWN_INBOX_REGION = 14;
    public static final int OTHER_INBOX_REGION = 15;
    public static final int OTHER_PUBLICBOX_REGION = 16;
    private OwUserInfo m_receiverUser = null;
    private int m_selectedDestination = 1;
    private OwClientRefreshContext m_refreshCtx;
    private OwWorkitemContainer m_oParentContainer;
    private Map m_defaultUsersSelectMap = new HashMap();

    public OwBPMReassignDialog(List workitems_p, OwWorkitemContainer oParent_p, OwClientRefreshContext refreshCtx_p, String noteProperty_p) throws OwException {
        super(workitems_p, noteProperty_p, false);
        this.m_refreshCtx = refreshCtx_p;
        this.m_oParentContainer = oParent_p;
    }

    public OwBPMReassignDialog(OwWorkitem workitem_p, OwWorkitemContainer oParent_p, OwClientRefreshContext refreshCtx_p, String noteProperty_p) throws OwException {
        super(workitem_p, noteProperty_p, false);
        this.m_refreshCtx = refreshCtx_p;
        this.m_oParentContainer = oParent_p;
    }

    private void updateDefaultUser(HttpServletRequest request_p) throws Exception {
        String defaultUserSelection = request_p.getParameter(DEFAULT_USER_SELECTION_WEB_KEY);
        if (defaultUserSelection != null) {
            OwUserInfo defaultUserInfo;
            this.m_receiverUser = defaultUserInfo = (OwUserInfo)this.m_defaultUsersSelectMap.get(defaultUserSelection);
        }
    }

    @Override
    public void onOkDo(HttpServletRequest request_p, Object reason_p) throws Exception {
        this.updateDefaultUser(request_p);
        int selection = Integer.parseInt(request_p.getParameter(DESTINATION_WEB_KEY));
        this.setNote(request_p);
        switch (selection) {
            case 1: {
                OwUserInfo userInfo = ((OwMainAppContext)this.getContext()).getCredentials().getUserInfo();
                this.doReassignToUserBox(userInfo.getUserID());
                break;
            }
            case 2: {
                this.doReassignToUserBox(this.m_receiverUser.getUserID());
                break;
            }
            case 3: {
                String sPublicContainerName = request_p.getParameter(PUBLIC_CONTAINER_NAME_WEB_KEY);
                this.doReassignToPublicBox(sPublicContainerName);
                break;
            }
        }
        this.getDocument().update((OwEventTarget)this, 17, (Object)this.m_currentItem);
        this.closeDialog();
        if (null != this.m_refreshCtx) {
            this.m_refreshCtx.onClientRefreshContextUpdate(3, null);
        }
    }

    @Override
    public void renderRegion(Writer w_p, int iRegion_p) throws Exception {
        switch (iRegion_p) {
            case 2: {
                this.serverSideDesignInclude("owbpm/OwReassign.jsp", w_p);
                break;
            }
            default: {
                super.renderRegion(w_p, iRegion_p);
            }
        }
    }

    public boolean isRegion(int iRegion_p) {
        try {
            switch (iRegion_p) {
                case 14: 
                case 15: {
                    for (OwWorkitem item : this.m_workitems) {
                        if (item.canReassignToUserContainer(2)) continue;
                        return false;
                    }
                    return true;
                }
                case 16: {
                    for (OwWorkitem item : this.m_workitems) {
                        if (item.canReassignToPublicContainer(2)) continue;
                        return false;
                    }
                    return true;
                }
            }
            return super.isRegion(iRegion_p);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getPublicDestinationDisplayName(String sID_p) {
        return this.m_oParentContainer.getPublicReassignContainerDisplayName(sID_p);
    }

    public Collection getPublicDestinations() throws Exception {
        return this.m_oParentContainer.getPublicReassignContainerNames();
    }

    public void onOpenUserDialog(HttpServletRequest request_p) throws Exception {
        this.m_selectedDestination = Integer.parseInt(request_p.getParameter(DESTINATION_WEB_KEY));
        OwUserSelectDialog dlgUser = new OwUserSelectDialog(new int[]{1}, false);
        this.getContext().openDialog((OwDialog)dlgUser, (OwDialog.OwDialogListener)this);
    }

    public void onDialogClose(OwDialog dialogView_p) throws Exception {
        OwUserInfo user;
        List users = ((OwUserSelectDialog)dialogView_p).getSelectedUsers();
        if (users != null && (user = (OwUserInfo)users.get(0)) != null) {
            this.m_receiverUser = user;
        }
    }

    public String getCheckedString(int radioButtonValue_p) {
        if (this.m_selectedDestination == radioButtonValue_p) {
            return "checked";
        }
        return "";
    }

    public void doReassignToPublicBox(String destination_p) throws Exception {
        OwWorkitem item2 = null;
        for (OwWorkitem item2 : this.m_workitems) {
            try {
                item2.reassignToPublicContainer(destination_p, false);
            }
            catch (Exception e) {
                throw new OwInvalidOperationException(this.getContext().localize1("plug.owtaskp8.plugins.OwMoveDialog.destination.error", "Work item (%1) could not be forwarded.", item2.getName()), (Throwable)e);
            }
        }
    }

    public void doReassignToUserBox(String destination_p) throws Exception {
        OwWorkitem item2 = null;
        for (OwWorkitem item2 : this.m_workitems) {
            try {
                item2.reassignToUserContainer(destination_p, false);
            }
            catch (Exception e) {
                throw new OwInvalidOperationException(this.getContext().localize1("plug.owtaskp8.plugins.OwMoveDialog.destination.error", "Der Vorgang ( %1 ) konnte nicht weitergeleitet werden!", item2.getName()), (Throwable)e);
            }
        }
    }

    public String getReceiverUserName() {
        try {
            if (this.m_receiverUser != null) {
                return this.m_receiverUser.getUserLongName();
            }
            return "";
        }
        catch (Exception e) {
            LOG.error((Object)"OwBPMReassignDialog.getReceiverUserName: could not retrieve user name!", (Throwable)e);
            return "";
        }
    }

    public OwUserInfo getReceiverUser() {
        return this.m_receiverUser;
    }

    @Override
    public void unlockAll() throws Exception {
        for (OwWorkitem object : this.m_workitems) {
            object.setLock(false);
        }
    }

    public boolean isUserDefaultEnabled() {
        return this.m_oParentContainer.getDefaultUsers() != null;
    }

    public List getDefaultUsers() {
        this.m_defaultUsersSelectMap.clear();
        Collection defaultUsers = this.m_oParentContainer.getDefaultUsers();
        if (defaultUsers != null) {
            ArrayList<OwUserInfo> defaultUsersList = new ArrayList<OwUserInfo>(defaultUsers);
            int usersCount = defaultUsersList.size();
            for (int i = 0; i < usersCount; ++i) {
                OwUserInfo info = (OwUserInfo)defaultUsersList.get(i);
                this.m_defaultUsersSelectMap.put(info.getUserID(), info);
            }
            if (this.m_receiverUser != null && !this.m_defaultUsersSelectMap.containsKey(this.m_receiverUser.getUserID())) {
                defaultUsersList.add(this.m_receiverUser);
                this.m_defaultUsersSelectMap.put(this.m_receiverUser.getUserID(), this.m_receiverUser);
            }
            return defaultUsersList;
        }
        return null;
    }
}

