/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owbpm.plug;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwStandardSequenceDialog;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.bpm.OwWorkitem;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.plug.owbpm.plug.OwBPMJspProcessorDialog;
import com.wewebu.ow.server.plug.owbpm.plug.OwBPMJspProcessorView;
import com.wewebu.ow.server.plug.owbpm.plug.OwBPMProcessorDialog;
import com.wewebu.ow.server.plug.owbpm.plug.OwBPMStandardProcessorDialog;
import com.wewebu.ow.server.plug.owbpm.plug.OwBPMStandardProcessorView;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class OwBPMStepProcessorFunction
extends OwDocumentFunction
implements OwDialog.OwDialogListener {
    public String getIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", "/images/plug/owbpm/standardprocessor.png");
    }

    public String getBigIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", "/images/plug/owbpm/standardprocessor_24.png");
    }

    public void onClickEvent(OwObject oObject_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        if (!this.isEnabled(oObject_p, oParent_p, 2)) {
            throw new OwInvalidOperationException(this.getContext().localize("plug.owbpm.OwBPMStandardProcessorFunction.invalidobject", "Das Objekt kann nicht im Schrittprozessor bearbeitet werden."));
        }
        ((OwWorkitem)oObject_p).setLock(true);
        ArrayList<OwObject> objects = new ArrayList<OwObject>();
        objects.add(oObject_p);
        OwStandardSequenceDialog dlg = this.createDialog(objects, refreshCtx_p, this.getConfigNode());
        dlg.setTitle(this.getLabel(oObject_p, oParent_p));
        dlg.setInfoIcon(this.getBigIcon());
        this.getContext().openDialog((OwDialog)dlg, (OwDialog.OwDialogListener)this);
        this.addHistoryEvent(((OwBPMProcessorDialog)dlg).getWorkItems(), null, 2, 1);
    }

    protected OwBPMStandardProcessorDialog createProcessorDialog(Collection objects_p, OwClientRefreshContext refreshCtx_p, OwXMLUtil configNode_p) throws Exception {
        return new OwBPMStandardProcessorDialog(objects_p, refreshCtx_p, configNode_p);
    }

    public void onMultiselectClickEvent(Collection objects_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        Iterator it = objects_p.iterator();
        while (it.hasNext()) {
            OwObject obj = (OwObject)it.next();
            if (this.isEnabled(obj, oParent_p, 2)) {
                ((OwWorkitem)obj).setLock(true);
                continue;
            }
            it.remove();
        }
        if (objects_p.size() == 0) {
            return;
        }
        OwStandardSequenceDialog dlg = this.createDialog(objects_p, refreshCtx_p, this.getConfigNode());
        dlg.setTitle(this.getPluginTitle());
        dlg.setInfoIcon(this.getBigIcon());
        this.getContext().openDialog((OwDialog)dlg, (OwDialog.OwDialogListener)this);
        this.addHistoryEvent(((OwBPMProcessorDialog)dlg).getWorkItems(), null, 2, 1);
    }

    protected OwStandardSequenceDialog createDialog(Collection objects_p, OwClientRefreshContext refreshCtx_p, OwXMLUtil configNode_p) throws Exception {
        OwStandardSequenceDialog dialog = null;
        String jspForm = configNode_p.getSafeTextValue("JspForm", null);
        dialog = jspForm != null ? this.createJspProcessorDialog(objects_p, configNode_p, refreshCtx_p) : this.createProcessorDialog(objects_p, refreshCtx_p, configNode_p);
        return dialog;
    }

    public void onDialogClose(OwDialog dialogView_p) throws Exception {
        ((OwBPMProcessorDialog)dialogView_p).unlock();
    }

    public void onUpdate(OwEventTarget caller_p, int code_p, Object param_p) throws Exception {
        if (code_p == 15 || code_p == 16) {
            if (caller_p instanceof OwBPMStandardProcessorView) {
                OwBPMStandardProcessorView realCaller = (OwBPMStandardProcessorView)caller_p;
                OwObject objectRef = realCaller.getObjectRef();
                this.historize(objectRef, code_p);
            } else if (caller_p instanceof OwBPMJspProcessorView) {
                OwBPMJspProcessorView realCaller = (OwBPMJspProcessorView)caller_p;
                OwObject objectRef = realCaller.getObjectRef();
                this.historize(objectRef, code_p);
            }
        }
    }

    private void historize(OwObject objectRef_p, int code_p) throws Exception {
        if (objectRef_p != null) {
            OwObject parent;
            OwObjectCollection parents = objectRef_p.getParents();
            OwObject owObject = parent = parents != null && parents.size() > 0 ? (OwObject)parents.get(0) : null;
            if (code_p == 15) {
                this.addHistoryEvent(objectRef_p, parent, 3, 1);
            } else if (code_p == 16) {
                this.addHistoryEvent(objectRef_p, parent, 11, 1);
            }
        }
    }

    protected OwBPMJspProcessorDialog createJspProcessorDialog(Collection objects_p, OwXMLUtil configNode_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        return new OwBPMJspProcessorDialog(objects_p, configNode_p, refreshCtx_p);
    }
}

