/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wd.plug.owbpm;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwSequenceView;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecm.bpm.OwWorkitem;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.plug.owbpm.plug.OwBPMStandardProcessorView;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.util.OwXMLUtil;
import javax.servlet.http.HttpServletRequest;

public class OwAlfrescoBPMStandardProcessorView
extends OwBPMStandardProcessorView {
    private int m_iClaimButton;
    private int m_iReleaseToPoolButton;

    public OwAlfrescoBPMStandardProcessorView(OwSequenceView seqview_p, OwXMLUtil configNode_p) {
        super(seqview_p, configNode_p);
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.m_iClaimButton = this.getMenu().addFormMenuItem((OwEventTarget)this, this.getContext().localize("owbpm.OwAlfrescoBPMStandardProcessorView.claimbtn", "Claim"), "Claim", null, this.getFormName(), false);
        this.m_iReleaseToPoolButton = this.getMenu().addFormMenuItem((OwEventTarget)this, this.getContext().localize("owbpm.OwAlfrescoBPMStandardProcessorView.releasetopoolbtn", "Release To Pool"), "ReleaseToPool", null, this.getFormName(), false);
    }

    @Override
    public void setObjectRef(OwObject objectRef_p, boolean showSystemProperties_p) throws Exception {
        super.setObjectRef(objectRef_p, showSystemProperties_p);
        this.updateButtonState();
    }

    private void updateButtonState() throws Exception {
        boolean isClaimable = this.isCurrentWoritemClaimable();
        boolean isReleasable = this.isCurrentWorkItemReleasable();
        this.getMenu().enable(this.m_iClaimButton, isClaimable);
        this.getMenu().enable(this.m_iReleaseToPoolButton, isReleasable);
    }

    private Boolean isCurrentWorkItemReleasable() throws Exception {
        OwWorkitem workItem = this.getWorkItem();
        boolean fLocked = workItem.getLock(2);
        OwProperty isReleasableProp = null;
        Boolean isReleasableValue = Boolean.FALSE;
        try {
            isReleasableProp = workItem.getProperty("isReleasable");
            if (null != isReleasableProp.getValue()) {
                isReleasableValue = (Boolean)isReleasableProp.getValue();
            }
        }
        catch (OwObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        return fLocked && isReleasableValue != false;
    }

    private Boolean isCurrentWoritemClaimable() throws Exception {
        OwWorkitem workItem = this.getWorkItem();
        boolean fLocked = workItem.getLock(2);
        OwProperty isClaimableProp = null;
        Boolean isClaimableValue = Boolean.FALSE;
        try {
            isClaimableProp = workItem.getProperty("isClaimable");
            if (null != isClaimableProp.getValue()) {
                isClaimableValue = (Boolean)isClaimableProp.getValue();
            }
        }
        catch (OwObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        return fLocked && isClaimableValue != false;
    }

    public void onClaim(HttpServletRequest request_p, Object oReason_p) throws Exception {
        OwWorkitem wi = this.getWorkItem();
        OwUserInfo userInfo = ((OwMainAppContext)this.getContext()).getCredentials().getUserInfo();
        wi.reassignToUserContainer(userInfo.getUserID(), false);
        this.updateButtonState();
    }

    public void onReleaseToPool(HttpServletRequest request_p, Object oReason_p) throws Exception {
        OwWorkitem wi = this.getWorkItem();
        wi.returnToSource();
        this.m_seqview.next(true);
    }
}

