/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.docimport;

import com.wewebu.ow.server.app.OwDocumentImporter;
import com.wewebu.ow.server.app.OwDocumentImporterCallback;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.docimport.OwLocalFileDocumentImporterView;
import com.wewebu.ow.server.docimport.log.OwLog;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.ui.OwView;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.io.File;
import org.apache.log4j.Logger;

public class OwLocalFileDocumentImporter
implements OwDocumentImporter {
    private static final Logger LOG = OwLog.getLogger(OwLocalFileDocumentImporter.class);
    protected OwMainAppContext m_context;
    protected OwXMLUtil m_config;
    protected boolean m_singleFileImports = true;
    private String m_tempDir;
    private int m_nextTempFileID = 0;

    public void init(OwMainAppContext context_p, OwXMLUtil config_p) throws OwConfigurationException {
        if (context_p == null) {
            throw new IllegalArgumentException("OwLocalFileDocumentImporter.init() must not be called without context_p");
        }
        if (config_p == null) {
            throw new IllegalArgumentException("OwLocalFileDocumentImporter.init() must not be called without config_p");
        }
        this.m_context = context_p;
        this.m_config = config_p;
    }

    protected String getTempDir() throws OwConfigurationException {
        if (this.m_tempDir == null) {
            this.m_tempDir = this.getContext().createTempDir("Upload");
        }
        return this.m_tempDir;
    }

    protected int getTempFileID() {
        return this.m_nextTempFileID++;
    }

    protected OwMainAppContext getContext() {
        if (this.m_context == null) {
            throw new IllegalStateException("OwLocalFileDocumentImporter.getContext() must not be called before this view is initialized");
        }
        return this.m_context;
    }

    public String getDisplayName() {
        return this.getContext().localize("plug.docimport.OwLocalFileDocumentImporter.DisplayName", "Local file");
    }

    public String getIconURL() {
        try {
            return this.getContext().getDesignURL() + this.m_config.getSafeTextValue("icon", "/images/docimport/local_file.png");
        }
        catch (Exception e) {
            LOG.error((Object)"Can not get design URL", (Throwable)e);
            return null;
        }
    }

    public void setSingleFileImports(boolean singleFileImports_p) {
        this.m_singleFileImports = singleFileImports_p;
    }

    public OwView getView(int context_p, OwDocumentImporterCallback callback_p) {
        return new OwLocalFileDocumentImporterView(this, this.m_singleFileImports, callback_p);
    }

    public void releaseAll() {
        String tempDirToRelease = this.m_tempDir;
        this.m_tempDir = null;
        if (tempDirToRelease != null) {
            this.deleteDir(tempDirToRelease);
        }
    }

    private void deleteDir(String strDir_p) {
        boolean dirExists;
        File delDir = new File(strDir_p);
        String[] list = delDir.list();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                File file = new File(delDir, list[i]);
                if (file.isFile()) {
                    boolean fileExists = file.exists();
                    if (!fileExists || file.delete()) continue;
                    LOG.warn((Object)("OwLocalFileDocumentImporter.deleteDir: Error deleting all files of directory, name = " + strDir_p));
                    continue;
                }
                this.deleteDir(file.getAbsolutePath());
            }
        }
        if ((dirExists = delDir.exists()) && !delDir.delete()) {
            LOG.warn((Object)("OwLocalFileDocumentImporter.deleteDir: Error deleting the directory, name = " + strDir_p));
        }
    }

    public OwView getPostProcessView(int importContext_p, OwObject savedObj_p) {
        return null;
    }

    public boolean hasPostProcessView(int importContext_p) {
        return false;
    }

    protected void finalize() throws Throwable {
        this.releaseAll();
        super.finalize();
    }
}

