/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.docimport;

import com.wewebu.ow.server.app.OwDocumentImportItem;
import com.wewebu.ow.server.app.OwDocumentImporter;
import com.wewebu.ow.server.app.OwDocumentImporterCallback;
import com.wewebu.ow.server.app.OwStandardDocumentImportItem;
import com.wewebu.ow.server.app.OwSubMenuView;
import com.wewebu.ow.server.dmsdialogs.views.OwAbstractDocumentImporterView;
import com.wewebu.ow.server.docimport.OwLocalFileDocumentImporter;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.util.upload.OwMultiPart;
import com.wewebu.ow.server.util.upload.OwUpStreamParser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;

public class OwLocalFileDocumentImporterView
extends OwAbstractDocumentImporterView {
    public static final int MENU_REGION = 1;
    protected boolean m_singleFileImports;
    protected OwSubMenuView m_MenuView;

    public OwLocalFileDocumentImporterView(OwLocalFileDocumentImporter importer_p, boolean singleFileImports_p, OwDocumentImporterCallback callback_p) {
        super((OwDocumentImporter)importer_p, callback_p);
        if (importer_p == null) {
            throw new IllegalArgumentException("OwLocalFileDocumentImporterView must not be instantiated without importer_p");
        }
        this.m_singleFileImports = singleFileImports_p;
    }

    protected void init() throws Exception {
        super.init();
    }

    protected String usesFormWithAttributes() {
        return "ENCTYPE='multipart/form-data'";
    }

    protected void onRender(Writer w_p) throws Exception {
        this.serverSideDesignInclude("docimport/OwLocalFileDocumentImporterView.jsp", w_p);
    }

    public boolean onUpload(HttpServletRequest request_p, Object reason_p) throws Exception {
        OwMultiPart filePart;
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        OwStandardDocumentImportItem importedDocument = null;
        OwUpStreamParser mp = new OwUpStreamParser(request_p);
        String fileName = null;
        OwLocalFileDocumentImporter importer = (OwLocalFileDocumentImporter)this.getDocumentImporter();
        while ((filePart = mp.readNextPart()) != null) {
            String name = filePart.getName();
            if (filePart.isFile()) {
                fileName = filePart.getFileName();
                if (fileName == null) continue;
                if (importedDocument != null) {
                    throw new OwServerException("The POST data stream must contain at most one file.");
                }
                int importID = importer.getTempFileID();
                fileName = new String(fileName.getBytes("ISO-8859-1"), "UTF-8");
                long importSize = filePart.writeTo(new File(importer.getTempDir()), Integer.toString(importID));
                if (importSize == 0L) {
                    throw new OwServerException(this.getContext().localize("plug.docimport.OwNoContentDocumentImporterView.ErrorEmptyFile", "The specified file contains no content. You cannot create empty files."));
                }
                importedDocument = new OwStandardDocumentImportItem(importer.getTempDir(), importID, fileName);
                continue;
            }
            String paramValue = this.handleReqestParameterPart(filePart);
            requestParameters.put(name, paramValue);
        }
        mp.tidyUp();
        if (importedDocument == null) {
            throw new OwServerException(this.getContext().localize("plug.docimport.OwNoContentDocumentImporterView.ErrorNoFile", "Please enter a file."));
        }
        this.fireOnDocumentImportEvent((OwDocumentImportItem)importedDocument);
        return true;
    }

    public boolean onUpload(HttpServletRequest request_p) throws Exception {
        return this.onUpload(request_p, null);
    }

    private String handleReqestParameterPart(OwMultiPart filePart_p) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        filePart_p.writeTo((OutputStream)outputStream);
        String paramValue = outputStream.toString();
        outputStream.close();
        return paramValue;
    }
}

