/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.alfresco.bpm;

import com.wewebu.ow.server.collections.OwLoadContext;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMException;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMRepository;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMUserQueueContainer;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.collections.ContainerChildrenPageFetcher;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.log.OwLog;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.AlfrescoRESTFulFactory;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.OperationContext;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.TaskInstancesResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.Status;
import org.apache.log4j.Logger;

final class OwAlfrescoBPMGroupQueueContainer
extends OwAlfrescoBPMUserQueueContainer {
    private static final Logger LOG = OwLog.getLogger(OwAlfrescoBPMGroupQueueContainer.class);
    private OwUserInfo groupInfo;

    OwAlfrescoBPMGroupQueueContainer(OwNetwork network, OwAlfrescoBPMRepository bpmRepository, OwUserInfo groupInfo) throws Exception {
        super(network, bpmRepository, groupInfo.getUserName());
        this.groupInfo = groupInfo;
    }

    @Override
    protected ContainerChildrenPageFetcher.ResourceProvider getTasksInstancesResourceProvider(final OwLoadContext loadContext, String user) {
        String groupName;
        final AlfrescoRESTFulFactory restFulFactory = this.bpmRepository.getRestFulFactory();
        try {
            groupName = this.groupInfo.getUserName();
        }
        catch (Exception e) {
            throw new OwAlfrescoBPMException("could not get group name!", (Throwable)e);
        }
        ContainerChildrenPageFetcher.ResourceProvider<TaskInstancesResource> resourceProvider = new ContainerChildrenPageFetcher.ResourceProvider<TaskInstancesResource>(){

            @Override
            public TaskInstancesResource createResource(long maxNumItems, long skipCount) {
                TaskInstancesResource res = restFulFactory.taskInstancesResource(null, null, groupName, Status.ACTIVE, loadContext.getFilter(), new OperationContext(skipCount, maxNumItems));
                return res;
            }
        };
        return resourceProvider;
    }

    public int getType() {
        return 8225;
    }

    public String getMIMEType() throws Exception {
        return "ow_workitemcontainer/public";
    }

    @Override
    public String getName() {
        String id = this.getID();
        try {
            String displayName = this.groupInfo.getUserDisplayName();
            if (null != displayName) {
                return displayName;
            }
            LOG.error((Object)"It seems that my group's display name was not fetched from the backend.");
            return id;
        }
        catch (Exception e) {
            LOG.error((Object)"Could not get my group's display name.", (Throwable)e);
            return id;
        }
    }
}

