/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.alfresco.bpm;

import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwStandardProperty;
import com.wewebu.ow.server.ecm.bpm.OwWorkflowDescription;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMLaunchableWorkItemObjectClass;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMLaunchableWorkitemContainer;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMProperties;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMRepository;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMWorkItem;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMWorkflowDescription;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.log.OwLog;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.AlfrescoRESTFulFactory;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.CMISPropertyAdapter;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.OwRestException;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.ProcessesResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.RestCallTemplate;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.Process;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.ProcessEntry;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.StartProcessBody;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.TaskInstance;
import com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISObject;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;

public class OwAlfrescoBPMLaunchableWorkItem
extends OwAlfrescoBPMWorkItem {
    private static final Logger LOG = OwLog.getLogger(OwAlfrescoBPMLaunchableWorkItem.class);
    private OwWorkflowDescription workflowDescription;

    protected OwAlfrescoBPMLaunchableWorkItem(OwAlfrescoBPMLaunchableWorkitemContainer container, Collection attachmentobjects, OwAlfrescoBPMWorkflowDescription workflowDescription, OwAlfrescoBPMRepository bpmRepository) throws OwException {
        this.taskInstance = new TaskInstance();
        this.taskInstance.setProcessDefinitionId(workflowDescription.getId());
        this.container = container;
        this.bpmRepository = bpmRepository;
        this.properties = new OwAlfrescoBPMProperties();
        this.workflowDescription = workflowDescription;
        this.attachmentobjects = new LinkedList();
        if (null != attachmentobjects) {
            this.attachmentobjects.addAll(attachmentobjects);
        }
        this.taskInstanceVariables = Collections.emptyMap();
        this.objectClass = OwAlfrescoBPMLaunchableWorkItemObjectClass.forWorkflowDescription(container, workflowDescription);
    }

    @Override
    public void dispatch() throws Exception {
        String wfId = this.workflowDescription.getId();
        Map<String, Object> parameters = this.prepareParameters();
        try {
            this.getProperty("bpm:assignee");
            String shrinkedBpmAssignee = CMISPropertyAdapter.variableNameForProperty("bpm:assignee");
            if (!parameters.containsKey(shrinkedBpmAssignee)) {
                String currentUserName = this.bpmRepository.getNetwork().getCredentials().getAuthInfo("USER");
                parameters.put(shrinkedBpmAssignee, currentUserName);
            }
        }
        catch (OwObjectNotFoundException e) {
            // empty catch block
        }
        HashMap<String, Object> filteredParameters = new HashMap<String, Object>();
        for (Map.Entry<String, Object> varEntry : parameters.entrySet()) {
            Object val = varEntry.getValue();
            if (null == val) continue;
            filteredParameters.put(varEntry.getKey(), val);
        }
        final StartProcessBody body = new StartProcessBody();
        body.setProcessDefinitionId(wfId);
        body.setVariables(filteredParameters);
        if (null != this.attachmentobjects) {
            for (Object element : this.attachmentobjects) {
                OwCMISObject item = (OwCMISObject)element;
                body.addItem(item.getNativeID());
            }
        }
        AlfrescoRESTFulFactory restfulFactory = this.bpmRepository.getRestFulFactory();
        ProcessesResource resource = restfulFactory.processesResource();
        new RestCallTemplate<ProcessesResource, Void>(){

            @Override
            protected Void execWith(ProcessesResource resource) throws OwRestException {
                ProcessEntry result = resource.start(body);
                OwAlfrescoBPMLaunchableWorkItem.this.taskInstance.setProcessId(((Process)result.getEntry()).getId());
                return null;
            }
        }.doCall(resource);
    }

    @Override
    public boolean canDispatch(int iContext_p) throws Exception {
        return true;
    }

    @Override
    public boolean getLock(int iContext_p) throws Exception {
        return true;
    }

    @Override
    protected void save() {
    }

    @Override
    public void setProperties(OwPropertyCollection properties_p) throws Exception {
        super.setProperties(properties_p);
    }

    @Override
    protected void loadAttachments() {
    }

    @Override
    public boolean canReassignToUserContainer(int iContext_p) throws Exception {
        return false;
    }

    @Override
    protected Object loadPropertyValue(OwPropertyClass propertyClass) throws Exception {
        Object nativeValue = super.loadPropertyValue(propertyClass);
        if (null == nativeValue) {
            nativeValue = propertyClass.getDefaultValue();
        }
        return nativeValue;
    }

    @Override
    public OwProperty getProperty(String strPropertyName_p) throws Exception {
        OwPropertyClass propertyClass = this.getObjectClass().getPropertyClass(strPropertyName_p);
        if (strPropertyName_p.endsWith("isClaimable")) {
            return new OwStandardProperty((Object)false, propertyClass);
        }
        if (strPropertyName_p.endsWith("isReleasable")) {
            return new OwStandardProperty((Object)false, propertyClass);
        }
        if (strPropertyName_p.endsWith("isPooled")) {
            return new OwStandardProperty((Object)false, propertyClass);
        }
        return super.getProperty(strPropertyName_p);
    }
}

