/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.alfresco.bpm;

import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMProxyProperty;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.log.OwLog;
import com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISPropertyClass;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OwAlfrescoBPMProperties {
    private static final Logger LOG = OwLog.getLogger(OwAlfrescoBPMProperties.class);
    protected Map<String, OwProperty> properties = new HashMap<String, OwProperty>();

    public boolean contains(OwPropertyClass propertyClass) {
        String propertyClassShortName = this.getShortPropertyClassName(propertyClass);
        return this.properties.containsKey(propertyClassShortName);
    }

    private String getShortPropertyClassName(OwPropertyClass propertyClass) {
        String propertyClassName = null;
        propertyClassName = propertyClass instanceof OwCMISPropertyClass ? ((OwCMISPropertyClass)propertyClass).getNonQualifiedName() : propertyClass.getClassName();
        return propertyClassName;
    }

    public OwProperty get(OwPropertyClass propertyClass) {
        String propertyClassShortName = this.getShortPropertyClassName(propertyClass);
        String propertyClassSName = propertyClass.getClassName();
        OwProperty property = this.properties.get(propertyClassShortName);
        if (!propertyClassSName.equals(propertyClassShortName)) {
            return new OwAlfrescoBPMProxyProperty(property, propertyClass);
        }
        return property;
    }

    public void put(OwProperty property) throws OwException {
        try {
            String propertyClassName = this.getShortPropertyClassName(property.getPropertyClass());
            this.properties.put(propertyClassName, property);
        }
        catch (Exception e) {
            String message = "Could not get property class for: " + property;
            LOG.error((Object)message, (Throwable)e);
            throw new OwServerException(message, (Throwable)e);
        }
    }

    public Set<String> names() {
        return this.properties.keySet();
    }
}

