/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.alfresco.bpm;

import com.wewebu.ow.server.collections.OwCollectionIterable;
import com.wewebu.ow.server.collections.impl.OwAbstractPageFetcher;
import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.OwStandardProperty;
import com.wewebu.ow.server.ecm.OwStandardPropertyClass;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecm.OwVersion;
import com.wewebu.ow.server.ecm.OwVersionSeries;
import com.wewebu.ow.server.ecm.bpm.OwWorkitem;
import com.wewebu.ow.server.ecm.bpm.OwWorkitemProcessorInfo;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMContentCollection;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMContentElement;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMDMSID;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMException;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMProcessorInfo;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMProperties;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMProperty;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMRepository;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMWorkItemObjectClass;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMWorkitemContainerInterface;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.collections.ItemsPageFetcher;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.collections.VariablesPageFetcher;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.log.OwLog;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.AlfrescoRESTFulFactory;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.CMISPropertyAdapter;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.OwRestException;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.ProcessImageResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.ProcessInstanceItemResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.ProcessInstanceItemsResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.ProcessInstanceResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.RestCallTemplate;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.TaskInstanceResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.TaskInstanceStateResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.TaskInstanceVariableResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.Item;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.State;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.TaskInstance;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.TaskInstanceEntry;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.Variable;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.old.AlfrescoRESTFulFactoryOld;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.old.TaskInstanceDataOld;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.old.TaskInstanceResourceOld;
import com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISObject;
import com.wewebu.ow.server.exceptions.OwAccessDeniedException;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString1;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OwAlfrescoBPMWorkItem
implements OwWorkitem {
    private static final Logger LOG = OwLog.getLogger(OwAlfrescoBPMWorkItem.class);
    protected TaskInstance taskInstance;
    @Deprecated
    private TaskInstanceDataOld oldTaskInstance;
    protected Map<String, Variable> taskInstanceVariables;
    protected OwAlfrescoBPMWorkitemContainerInterface container;
    protected OwObjectClass objectClass;
    protected OwAlfrescoBPMRepository bpmRepository;
    protected OwAlfrescoBPMProperties properties;
    protected Collection attachmentobjects;
    private transient boolean lock;

    protected OwAlfrescoBPMWorkItem() {
    }

    public OwAlfrescoBPMWorkItem(TaskInstance taskInstance, OwAlfrescoBPMWorkitemContainerInterface container, OwAlfrescoBPMRepository bpmRepository) throws OwException {
        this.taskInstance = taskInstance;
        this.container = container;
        this.bpmRepository = bpmRepository;
        this.properties = new OwAlfrescoBPMProperties();
        this.objectClass = OwAlfrescoBPMWorkItemObjectClass.forTask(bpmRepository, taskInstance);
        Variable[] taskVariables = taskInstance.getVariables();
        if (null != taskVariables) {
            List<Variable> it = Arrays.asList(taskVariables);
            this.bootstrapInstanceVariable(it);
        }
    }

    private void bootstrapInstanceVariable(Iterable<Variable> it) {
        this.taskInstanceVariables = new HashMap<String, Variable>();
        for (Variable variable : it) {
            if (!this.taskInstanceVariables.containsKey(variable.getName())) {
                this.taskInstanceVariables.put(variable.getName(), variable);
                continue;
            }
            if (!variable.getScope().equals("local")) continue;
            this.taskInstanceVariables.put(variable.getName(), variable);
        }
        this.mapTaskPropertyToVariables(this.taskInstanceVariables, this.taskInstance);
    }

    public String getClassName() {
        return this.getObjectClass().getClassName();
    }

    public OwObjectClass getObjectClass() {
        return this.objectClass;
    }

    public OwObjectCollection getParents() throws Exception {
        return null;
    }

    public OwObjectCollection getChilds(int[] iObjectTypes_p, Collection propertyNames_p, OwSort sort_p, int iMaxSize_p, int iVersionSelection_p, OwSearchNode filterCriteria_p) throws Exception {
        return null;
    }

    public boolean hasChilds(int[] iObjectTypes_p, int iContext_p) throws Exception {
        return false;
    }

    public int getChildCount(int[] iObjectTypes_p, int iContext_p) throws Exception {
        return 0;
    }

    public void changeClass(String strNewClassName_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p) throws Exception {
    }

    public boolean canChangeClass() throws Exception {
        return false;
    }

    public boolean canFilterChilds() throws Exception {
        return false;
    }

    public Collection getFilterProperties(Collection propertynames_p) throws Exception {
        return null;
    }

    public OwVersionSeries getVersionSeries() throws Exception {
        return null;
    }

    public boolean hasVersionSeries() throws Exception {
        return false;
    }

    public OwVersion getVersion() throws Exception {
        return null;
    }

    public OwProperty getProperty(String strPropertyName_p) throws Exception {
        OwProperty property;
        OwPropertyClass propertyClass = this.getObjectClass().getPropertyClass(strPropertyName_p);
        if ("OW_ATTACHMENTS".equals(strPropertyName_p)) {
            Object[] array = null;
            if (null == this.attachmentobjects) {
                this.loadAttachments();
            }
            array = this.attachmentobjects.toArray();
            return new OwStandardProperty((Object)array, propertyClass);
        }
        if ("OW_TASK_TITLE".endsWith(strPropertyName_p)) {
            String value = this.getObjectClass().getDisplayName(Locale.ROOT);
            return new OwStandardProperty((Object)value, propertyClass);
        }
        if (strPropertyName_p.endsWith("bpm:taskId")) {
            String taskId = this.taskInstance.getId();
            return new OwStandardProperty((Object)taskId, propertyClass);
        }
        if (strPropertyName_p.endsWith("state")) {
            String state = this.taskInstance.getState();
            return new OwStandardProperty((Object)state, propertyClass);
        }
        if (strPropertyName_p.endsWith("isClaimable")) {
            boolean isClaimable = this.getOldTaskInstance().getData().isClaimable();
            return new OwStandardProperty((Object)isClaimable, propertyClass);
        }
        if (strPropertyName_p.endsWith("isReleasable")) {
            boolean isReleasable = this.getOldTaskInstance().getData().isReleasable();
            return new OwStandardProperty((Object)isReleasable, propertyClass);
        }
        if ("OW_ASSIGNEE".endsWith(strPropertyName_p)) {
            String assignee = this.taskInstance.getAssignee();
            return new OwStandardProperty((Object)assignee, propertyClass);
        }
        if (strPropertyName_p.endsWith("isPooled")) {
            boolean isPooled = this.getOldTaskInstance().getData().isPooled();
            return new OwStandardProperty((Object)isPooled, propertyClass);
        }
        String propertyClassName = propertyClass.getClassName();
        if (!this.properties.contains(propertyClass)) {
            this.loadProperty(propertyClassName);
        }
        if (null == (property = this.properties.get(propertyClass))) {
            throw new OwObjectNotFoundException("Property not found " + strPropertyName_p);
        }
        return property;
    }

    protected void loadAttachments() throws Exception {
        OwCollectionIterable items = new OwCollectionIterable((OwAbstractPageFetcher)new ItemsPageFetcher(this.bpmRepository, this.taskInstance));
        OwNetwork network = this.bpmRepository.getNetwork();
        String resourceId = network.getResource(null).getID();
        LinkedList<OwObject> loadedAtachments = new LinkedList<OwObject>();
        for (Item item : items) {
            String objectId = item.getId();
            String dmsId = "cmis," + resourceId + "," + "workspace://SpacesStore/" + objectId;
            try {
                OwObject itemObject = network.getObjectFromDMSID(dmsId, true);
                loadedAtachments.add(itemObject);
            }
            catch (OwAccessDeniedException owException) {
                OwString1 message = new OwString1("adpalfrescobpm.err.accessDeniedForAttachment", "Could not load attachment with id %1. Access was denied.", objectId);
                throw new OwAlfrescoBPMException((OwString)message, (Throwable)owException);
            }
            catch (Exception owException) {
                OwString1 message = new OwString1("adpalfrescobpm.err.couldNotLoadAttachment", "Could not load attachment with id %1.", objectId);
                throw new OwAlfrescoBPMException((OwString)message, (Throwable)owException);
            }
        }
        this.attachmentobjects = loadedAtachments;
    }

    private void loadProperty(String propertyClassName) throws OwException {
        try {
            OwPropertyClass propertyClass = this.getObjectClass().getPropertyClass(propertyClassName);
            Object nativeValue = this.loadPropertyValue(propertyClass);
            OwAlfrescoBPMProperty property = new OwAlfrescoBPMProperty(nativeValue, propertyClass, this.bpmRepository.getValueConverterFactory());
            this.properties.put(property);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            LOG.error((Object)("Could not get property: " + propertyClassName), (Throwable)e);
            throw new OwServerException("Could not load property " + propertyClassName, (Throwable)e);
        }
    }

    protected Object loadPropertyValue(OwPropertyClass propertyClass) throws Exception {
        String strPropertyName_p = propertyClass.getClassName();
        String translatedPropertyName = strPropertyName_p.replace(':', '_');
        Object nativeValue = null;
        Map<String, Variable> taskProperties = this.getTaskInstanceVariables();
        if (taskProperties.containsKey(translatedPropertyName)) {
            nativeValue = taskProperties.get(translatedPropertyName).getValue();
        } else {
            String translatedDotSplitName;
            String[] dotSplitPropertyName = strPropertyName_p.split("\\.");
            if (dotSplitPropertyName.length == 2 && taskProperties.containsKey(translatedDotSplitName = dotSplitPropertyName[1].replace(':', '_'))) {
                nativeValue = taskProperties.get(translatedDotSplitName).getValue();
            }
        }
        return nativeValue;
    }

    protected Map<String, Variable> getTaskInstanceVariables() throws OwException {
        if (null == this.taskInstanceVariables) {
            OwCollectionIterable variables = new OwCollectionIterable((OwAbstractPageFetcher)new VariablesPageFetcher(this.bpmRepository, this.taskInstance));
            this.bootstrapInstanceVariable((Iterable<Variable>)variables);
        }
        return this.taskInstanceVariables;
    }

    private void mapTaskPropertyToVariables(Map<String, Variable> taskVariables, TaskInstance task) {
        Variable varStart;
        Variable varDesc;
        Variable varId = taskVariables.get("bpm_taskId");
        if (varId == null) {
            varId = new Variable();
            varId.setType("d:text");
            varId.setName("bpm_taskId");
            varId.setScope("local");
            taskVariables.put(varId.getName(), varId);
        }
        if (varId.getValue() == null) {
            varId.setValue(task.getId());
        }
        if ((varDesc = taskVariables.get("bpm_description")) == null) {
            varDesc = new Variable();
            varDesc.setType("d:text");
            varDesc.setName("bpm_description");
            varDesc.setScope("global");
            taskVariables.put(varDesc.getName(), varDesc);
        }
        if (varDesc.getValue() == null) {
            varDesc.setValue(task.getDescription());
        }
        if ((varStart = taskVariables.get("bpm_startDate")) == null) {
            varStart = new Variable();
            varStart.setType("d:date");
            varStart.setName("bpm_startDate");
            varStart.setScope("local");
            taskVariables.put(varStart.getName(), varStart);
        }
        if (varStart.getValue() == null) {
            varStart.setValue(task.getStartedAt());
        }
    }

    public OwPropertyCollection getProperties(Collection propertyNames_p) throws Exception {
        if (propertyNames_p == null) {
            OwObjectClass clazz = this.getObjectClass();
            propertyNames_p = clazz.getPropertyClassNames();
        }
        OwStandardPropertyCollection result = new OwStandardPropertyCollection();
        for (String propertyName : propertyNames_p) {
            OwProperty property = this.getProperty(propertyName);
            result.put((Object)propertyName, (Object)property);
        }
        return result;
    }

    public OwPropertyCollection getClonedProperties(Collection propertyNames_p) throws Exception {
        return OwStandardPropertyClass.getClonedProperties((OwObject)this, (Collection)propertyNames_p);
    }

    public void setProperties(OwPropertyCollection properties_p) throws Exception {
        Collection values = properties_p.values();
        for (OwProperty owProperty : values) {
            this.storeProperty(owProperty);
        }
        this.save();
    }

    private void storeProperty(OwProperty owProperty) throws Exception {
        OwPropertyClass propertyClass = owProperty.getPropertyClass();
        String propertyClassName = propertyClass.getClassName();
        if ("OW_ATTACHMENTS".equals(propertyClassName)) {
            Object[] array = (Object[])owProperty.getValue();
            if (null == array) {
                this.attachmentobjects = null;
            } else {
                this.attachmentobjects.clear();
                this.attachmentobjects.addAll(Arrays.asList(array));
            }
            return;
        }
        if ("OW_TASK_TITLE".equals(propertyClassName) || "OW_ASSIGNEE".equals(propertyClassName) || "state".equals(propertyClassName) || "isReleasable".equals(propertyClassName) || "isClaimable".equals(propertyClassName) || "isPooled".equals(propertyClassName)) {
            return;
        }
        this.properties.put(owProperty);
    }

    protected void save() throws Exception {
        AlfrescoRESTFulFactory restfulFactory = this.bpmRepository.getRestFulFactory();
        TaskInstanceVariableResource resource = null;
        Map<String, Variable> nativeProperties = this.getTaskInstanceVariables();
        Map<String, Object> parameters = this.prepareParameters();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            final Variable variable = new Variable();
            variable.setName(entry.getKey());
            variable.setValue(entry.getValue());
            String scope = "local";
            if (nativeProperties.containsKey(entry.getKey())) {
                Variable existingVariable = nativeProperties.get(entry.getKey());
                scope = existingVariable.getScope();
            }
            variable.setScope(scope);
            resource = restfulFactory.taskInstanceVariableResource(this.getID(), entry.getKey());
            new RestCallTemplate<TaskInstanceVariableResource, Void>(){

                @Override
                protected Void execWith(TaskInstanceVariableResource resource) throws OwException {
                    resource.save(variable);
                    return null;
                }
            }.doCall(resource);
        }
        this.saveAttachments();
    }

    protected void saveAttachments() throws Exception {
        if (null != this.attachmentobjects) {
            OwCollectionIterable existingItems = new OwCollectionIterable((OwAbstractPageFetcher)new ItemsPageFetcher(this.bpmRepository, this.taskInstance));
            HashSet<String> existingItemsIds = new HashSet<String>();
            for (Item item : existingItems) {
                String objectId = "workspace://SpacesStore/" + item.getId();
                existingItemsIds.add(objectId);
            }
            AlfrescoRESTFulFactory restfulFactory = this.bpmRepository.getRestFulFactory();
            String processId = this.taskInstance.getProcessId();
            for (Object element : this.attachmentobjects) {
                OwCMISObject owObject = (OwCMISObject)element;
                final String nativeId = owObject.getNativeID();
                if (existingItemsIds.contains(nativeId)) {
                    existingItemsIds.remove(nativeId);
                    continue;
                }
                ProcessInstanceItemsResource resource = restfulFactory.processInstanceItems(processId);
                new RestCallTemplate<ProcessInstanceItemsResource, Void>(){

                    @Override
                    protected Void execWith(ProcessInstanceItemsResource resource) throws OwRestException {
                        Item newItem = new Item();
                        newItem.setId(nativeId);
                        resource.addItem(newItem);
                        return null;
                    }
                }.doCall(resource);
            }
            for (String idToDelete : existingItemsIds) {
                ProcessInstanceItemResource itemResource = restfulFactory.processInstanceItem(processId, idToDelete);
                new RestCallTemplate<ProcessInstanceItemResource, Void>(){

                    @Override
                    protected Void execWith(ProcessInstanceItemResource resource) throws OwRestException {
                        resource.delete();
                        return null;
                    }
                }.doCall(itemResource);
            }
        }
    }

    public void setProperties(OwPropertyCollection properties_p, Object mode_p) throws Exception {
        this.setProperties(properties_p);
    }

    public boolean canSetProperties(int iContext_p) throws Exception {
        return true;
    }

    public boolean canGetProperties(int iContext_p) throws Exception {
        return false;
    }

    public boolean canLock() throws Exception {
        return false;
    }

    public boolean setLock(boolean fLock_p) throws Exception {
        this.lock = fLock_p;
        return this.lock;
    }

    public boolean getLock(int iContext_p) throws Exception {
        return this.lock;
    }

    public boolean getMyLock(int iContext_p) throws Exception {
        return false;
    }

    public String getLockUserID(int iContext_p) throws Exception {
        return null;
    }

    public void delete() throws Exception {
        String workflowInstanceId = this.taskInstance.getProcessId();
        AlfrescoRESTFulFactory restFulFactory = this.bpmRepository.getRestFulFactory();
        ProcessInstanceResource resource = restFulFactory.processInstance(workflowInstanceId);
        new RestCallTemplate<ProcessInstanceResource, Void>(){

            @Override
            protected Void execWith(ProcessInstanceResource resource) throws OwRestException {
                resource.delete();
                return null;
            }
        }.doCall(resource);
    }

    public boolean canDelete(int iContext_p) throws Exception {
        return true;
    }

    public void removeReference(OwObject oObject_p) throws Exception {
    }

    public boolean canRemoveReference(OwObject oObject_p, int iContext_p) throws Exception {
        return false;
    }

    public void add(OwObject oObject_p) throws Exception {
    }

    public boolean canAdd(OwObject oObject_p, int iContext_p) throws Exception {
        return false;
    }

    public void move(OwObject oObject_p, OwObject oldParent_p) throws Exception {
    }

    public boolean canMove(OwObject oObject_p, OwObject oldParent_p, int iContext_p) throws Exception {
        return false;
    }

    public OwSearchTemplate getSearchTemplate() throws Exception {
        return null;
    }

    public Collection getColumnInfoList() throws Exception {
        return null;
    }

    public OwResource getResource() throws Exception {
        return null;
    }

    public OwPermissionCollection getPermissions() throws Exception {
        return null;
    }

    public OwPermissionCollection getClonedPermissions() throws Exception {
        return null;
    }

    public boolean canGetPermissions() throws Exception {
        return false;
    }

    public boolean canSetPermissions() throws Exception {
        return false;
    }

    public void setPermissions(OwPermissionCollection permissions_p) throws Exception {
    }

    public OwContentCollection getContentCollection() throws Exception {
        AlfrescoRESTFulFactory restfulFactory = this.bpmRepository.getRestFulFactory();
        String processId = this.taskInstance.getProcessId();
        ProcessImageResource resources = restfulFactory.processImageResource(processId);
        OwAlfrescoBPMContentCollection contentCollection = new OwAlfrescoBPMContentCollection();
        OwAlfrescoBPMContentElement contentElement = new OwAlfrescoBPMContentElement(resources);
        contentCollection.addContentElement(contentElement);
        return contentCollection;
    }

    public void setContentCollection(OwContentCollection content_p) throws Exception {
    }

    public boolean canSetContent(int iContentType_p, int iContext_p) throws Exception {
        return false;
    }

    public boolean canGetContent(int iContentType_p, int iContext_p) throws Exception {
        return true;
    }

    public void refreshProperties() throws Exception {
    }

    public void refreshProperties(Collection props_p) throws Exception {
    }

    public Object getNativeObject() throws Exception {
        return null;
    }

    public String getPath() throws Exception {
        return null;
    }

    public String getResourceID() throws Exception {
        return null;
    }

    public OwObject getInstance() throws Exception {
        return this;
    }

    public String getName() {
        try {
            String title = (String)this.getProperty("OW_TASK_TITLE").getValue();
            String description = (String)this.getProperty("bpm:description").getValue();
            String name = String.format("%s (%s)", title, description);
            return name;
        }
        catch (Exception e) {
            return "[undef]";
        }
    }

    public String getID() {
        return this.taskInstance.getId();
    }

    public int getType() {
        return 16385;
    }

    public String getDMSID() throws Exception {
        return OwAlfrescoBPMDMSID.fromNativeID(this.taskInstance.getId()).getDMSIDString();
    }

    public int getPageCount() throws Exception {
        return 0;
    }

    public String getMIMEType() throws Exception {
        return this.container.createContaineeMIMEType(this);
    }

    public String getMIMEParameter() throws Exception {
        return this.container.createContaineeMIMEParameter(this);
    }

    public boolean hasContent(int iContext_p) throws Exception {
        return iContext_p == 2;
    }

    public OwField getField(String strFieldClassName_p) throws Exception, OwObjectNotFoundException {
        return null;
    }

    public void setField(String sName_p, Object value_p) throws Exception, OwObjectNotFoundException {
    }

    public Object getSafeFieldValue(String sName_p, Object defaultvalue_p) {
        return null;
    }

    public Collection getFields() throws Exception {
        return null;
    }

    public int getFieldProviderType() {
        return 0;
    }

    public Object getFieldProviderSource() {
        return null;
    }

    public String getFieldProviderName() {
        return null;
    }

    public OwWorkitemProcessorInfo getStepProcessorInfo() throws OwObjectNotFoundException {
        String strJspPage = "";
        try {
            strJspPage = this.getProperty("owdbpm:jspStepProcessor").getValue().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (strJspPage.length() == 0) {
            return new OwAlfrescoBPMProcessorInfo(this);
        }
        return new OwAlfrescoBPMProcessorInfo(this, strJspPage);
    }

    public void setResponse(String strResponse_p) throws Exception {
    }

    public boolean canResponse() {
        return false;
    }

    public String getResponse() throws Exception {
        return null;
    }

    public Collection getResponses() throws Exception {
        return null;
    }

    public void forcedelete() throws Exception {
    }

    public boolean canForcedelete(int iContext_p) throws Exception {
        return false;
    }

    public void dispatch() throws Exception {
        AlfrescoRESTFulFactory restfulFactory = this.bpmRepository.getRestFulFactory();
        TaskInstanceStateResource resource = restfulFactory.taskInstanceStateResource(this.getID());
        new RestCallTemplate<TaskInstanceStateResource, Void>(){

            @Override
            protected Void execWith(TaskInstanceStateResource resource) throws OwException {
                State newState = new State("completed");
                resource.changeTo(newState);
                return null;
            }
        }.doCall(resource);
    }

    public boolean canDispatch(int iContext_p) throws Exception {
        return true;
    }

    public void returnToSource() throws Exception {
        AlfrescoRESTFulFactory restfulFactory = this.bpmRepository.getRestFulFactory();
        String taskId = this.taskInstance.getId();
        if (this.getOldTaskInstance().getData().isReleasable()) {
            TaskInstanceResource resource = null;
            resource = restfulFactory.taskInstanceResource(taskId, "state");
            this.taskInstance = (TaskInstance)new RestCallTemplate<TaskInstanceResource, TaskInstance>(){

                @Override
                protected TaskInstance execWith(TaskInstanceResource resource) throws OwException {
                    TaskInstance updatedTaskInstance = new TaskInstance();
                    updatedTaskInstance.setState("unclaimed");
                    TaskInstanceEntry result = resource.update(updatedTaskInstance);
                    return (TaskInstance)result.getEntry();
                }
            }.doCall(resource);
            this.oldTaskInstance = null;
            return;
        }
    }

    public boolean canReturnToSource(int iContext_p) throws Exception {
        return false;
    }

    public void reassignToPublicContainer(String containername_p, boolean delegateFlag_p) throws Exception {
    }

    public void reassignToUserContainer(String participant_p, boolean delegateFlag_p) throws Exception {
        String currentUserId = this.bpmRepository.getNetwork().getCredentials().getUserInfo().getUserID();
        AlfrescoRESTFulFactory restfulFactory = this.bpmRepository.getRestFulFactory();
        String taskId = this.taskInstance.getId();
        TaskInstanceResource resource = null;
        if (participant_p.equals(currentUserId)) {
            resource = restfulFactory.taskInstanceResource(taskId, "state");
            this.taskInstance = (TaskInstance)new RestCallTemplate<TaskInstanceResource, TaskInstance>(){

                @Override
                protected TaskInstance execWith(TaskInstanceResource resource) throws OwException {
                    TaskInstance updatedTaskInstance = new TaskInstance();
                    updatedTaskInstance.setState("claimed");
                    TaskInstanceEntry result = resource.update(updatedTaskInstance);
                    return (TaskInstance)result.getEntry();
                }
            }.doCall(resource);
            this.oldTaskInstance = null;
            return;
        }
        if (delegateFlag_p) {
            throw new OwInvalidOperationException("Task delegation is not implemented yet.");
        }
        final OwUserInfo toUser = this.bpmRepository.getNetwork().getUserFromID(participant_p);
        resource = restfulFactory.taskInstanceResource(taskId, "assignee");
        this.taskInstance = (TaskInstance)new RestCallTemplate<TaskInstanceResource, TaskInstance>(){

            @Override
            protected TaskInstance execWith(TaskInstanceResource resource) throws OwException {
                TaskInstance updatedTaskInstance = new TaskInstance();
                updatedTaskInstance.setAssignee(toUser.getUserID());
                TaskInstanceEntry result = resource.update(updatedTaskInstance);
                return (TaskInstance)result.getEntry();
            }
        }.doCall(resource);
    }

    public boolean canReassignToPublicContainer(int iContext_p) throws Exception {
        return false;
    }

    public boolean canReassignToUserContainer(int iContext_p) throws Exception {
        return this.getOldTaskInstance().getData().isReassignable();
    }

    public void resubmit(Date date_p) throws Exception {
        if (!this.canResubmit(2)) {
            throw new OwConfigurationException("This item does not support resubmission.");
        }
        try {
            OwStandardPropertyCollection properties = new OwStandardPropertyCollection();
            OwProperty resubmitProperty = this.getProperty("owdbpm:resubmissionDate");
            resubmitProperty.setValue((Object)date_p);
            properties.put((Object)resubmitProperty.getPropertyClass().getClassName(), (Object)resubmitProperty);
            this.setProperties((OwPropertyCollection)properties);
        }
        catch (OwObjectNotFoundException e) {
            LOG.error((Object)("No exposed resubmit property defined: owdbpm:resubmissionDate in workitem: " + this.getName()), (Throwable)e);
            throw new OwConfigurationException((OwString)new OwString1("ecmimpl.fncm.bpm.resubmissioninvalid", "The work item allows no resubmission. Probably the queue is not configured with this property (%1).", "owdbpm:resubmissionDate"), (Throwable)e);
        }
    }

    public boolean canResubmit(int iContext_p) throws Exception {
        try {
            OwProperty resubmitProp = this.getProperty("owdbpm:resubmissionDate");
            return !resubmitProp.isReadOnly(2);
        }
        catch (OwObjectNotFoundException e) {
            return false;
        }
    }

    public Date getResubmitDate(int iContext_p) throws Exception {
        try {
            OwProperty resubmitProperty = this.getProperty("owdbpm:resubmissionDate");
            Date resdate = (Date)resubmitProperty.getValue();
            if (resdate == null || resdate.getTime() <= new Date().getTime()) {
                return null;
            }
            return resdate;
        }
        catch (OwObjectNotFoundException e) {
            return null;
        }
    }

    public String toString() {
        return this.taskInstance.toString();
    }

    protected Map<String, Object> prepareParameters() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Set<String> propNames = this.properties.names();
        for (String propName : propNames) {
            OwPropertyClass propertyClass = this.getObjectClass().getPropertyClass(propName);
            OwProperty property = this.properties.get(propertyClass);
            boolean isUpdatable = !property.isReadOnly(2) && !property.getPropertyClass().isReadOnly(2) && !property.getPropertyClass().isSystemProperty();
            boolean isCmOwner = propName.equals("cm:owner");
            if (!isCmOwner && !isUpdatable) continue;
            String translatedPropName = CMISPropertyAdapter.variableNameForProperty((OwFieldDefinition)propertyClass);
            Object value = property.getNativeObject();
            parameters.put(translatedPropName, value);
        }
        return parameters;
    }

    public String getWorkflowInstanceId() {
        return this.taskInstance.getProcessId();
    }

    @Deprecated
    private void loadOldTaskInstance() throws OwException {
        AlfrescoRESTFulFactoryOld oldAPI = this.bpmRepository.getRestFulFactory().getOldAPIFactory();
        final TaskInstanceResourceOld oldTaskInstanceResource = oldAPI.taskInstanceResource(this.getID());
        new RestCallTemplate<TaskInstanceResourceOld, Void>(){

            @Override
            protected Void execWith(TaskInstanceResourceOld resource) throws OwException {
                OwAlfrescoBPMWorkItem.this.oldTaskInstance = oldTaskInstanceResource.get();
                return null;
            }
        }.doCall(oldTaskInstanceResource);
    }

    @Deprecated
    private TaskInstanceDataOld getOldTaskInstance() throws OwException {
        if (null == this.oldTaskInstance) {
            this.loadOldTaskInstance();
        }
        return this.oldTaskInstance;
    }
}

