/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.alfresco.bpm;

import com.wewebu.ow.server.collections.OwCollectionIterable;
import com.wewebu.ow.server.collections.OwIterable;
import com.wewebu.ow.server.collections.OwLoadContext;
import com.wewebu.ow.server.collections.impl.OwAbstractPageFetcher;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.ecm.OwStatusContextException;
import com.wewebu.ow.server.ecm.bpm.OwWorkitem;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMBaseContainer;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMException;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMRepository;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMWorkItem;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.collections.ContainerChildrenPageFetcher;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.log.OwLog;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.util.ClientSideFilter;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.util.NoClientSideFilter;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.util.ResubmissionClientSideFilter;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.util.StandardBPMClientSideFilter;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.field.OwFieldColumnInfo;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class OwAlfrescoBPMWorkitemContainer
extends OwAlfrescoBPMBaseContainer {
    private static final Logger LOG = OwLog.getLogger(OwAlfrescoBPMWorkitemContainer.class);
    protected String id;

    public OwAlfrescoBPMWorkitemContainer(OwNetwork network, OwAlfrescoBPMRepository bpmRepository, String sID_p) {
        super(network, bpmRepository);
        this.bpmRepository = bpmRepository;
        this.id = sID_p;
    }

    @Override
    public String createContaineeMIMEType(OwAlfrescoBPMWorkItem item) throws Exception {
        OwProperty property = item.getProperty("isPooled");
        if (property != null && ((Boolean)property.getValue()).booleanValue()) {
            return "ow_workitem/poolitem";
        }
        return "ow_workitem/item";
    }

    @Override
    public String createContaineeMIMEParameter(OwAlfrescoBPMWorkItem item) {
        return "";
    }

    protected OwNetworkContext getBPMRepositoryContext() {
        return this.bpmRepository.getContext();
    }

    public String getName() {
        return this.getBpmRepository().getContext().localizeLabel(this.id);
    }

    public String getID() {
        return this.id;
    }

    @Override
    public OwWorkitem pull(OwSort sort_p, Set exclude_p) throws Exception, OwObjectNotFoundException, OwServerException {
        OwLoadContext ctx = new OwLoadContext();
        OwIterable<OwObject> page = this.getChildren(ctx);
        OwObjectCollection children = this.processClientSideFiltering(page, this.getClientSideFilter(this.getFilterType()), 1);
        if (children.isEmpty()) {
            String message = this.getNetwork().getContext().localize("plug.owbpm.OwBPMPullFunction.pullfailed", "There is no work item to edit.");
            LOG.error((Object)message);
            throw new OwObjectNotFoundException(message);
        }
        return (OwWorkitem)children.get(0);
    }

    @Override
    public boolean canPull(int iContext_p) throws Exception, OwStatusContextException {
        return true;
    }

    @Override
    public Collection getFilterProperties(Collection columnsInfo_p) throws Exception {
        ArrayList<OwFieldDefinition> filterProperties = new ArrayList<OwFieldDefinition>();
        for (Object objColumnInfo : columnsInfo_p) {
            OwFieldColumnInfo columnInfo = (OwFieldColumnInfo)objColumnInfo;
            String propertyName = columnInfo.getPropertyName();
            if (!propertyName.endsWith("bpm:dueDate")) continue;
            OwFieldDefinition fieldDefinition = this.network.getFieldDefinition(propertyName, null);
            filterProperties.add(fieldDefinition);
        }
        return filterProperties;
    }

    public boolean canResubmit() throws Exception {
        return true;
    }

    public OwObjectCollection getChilds(int[] iObjectTypes_p, Collection propertyNames_p, OwSort sort_p, int iMaxSize_p, int iVersionSelection_p, OwSearchNode filterCriteria_p) throws Exception {
        OwStandardObjectCollection result = new OwStandardObjectCollection();
        for (int type : iObjectTypes_p) {
            if (type != 16384 && type != 16385) continue;
            OwIterable<OwObject> children = this.getChildrenInternal(filterCriteria_p, iMaxSize_p);
            result = this.processClientSideFiltering(children, this.getClientSideFilter(this.getFilterType()), iMaxSize_p);
        }
        if (null != sort_p) {
            result.sort(sort_p);
        }
        return result;
    }

    protected OwObjectCollection processClientSideFiltering(OwIterable<OwObject> paging, ClientSideFilter filter, int maxSize) throws Exception {
        OwStandardObjectCollection result = new OwStandardObjectCollection();
        for (OwObject object : paging) {
            if (result.size() <= maxSize && filter.match(object)) {
                result.add((Object)object);
            }
            if (result.size() != maxSize) continue;
            break;
        }
        return result;
    }

    public OwIterable<OwObject> getChildren(OwLoadContext loadContext) throws OwException {
        return this.getChildrenInternal(loadContext);
    }

    public int getChildCount(int[] iObjectTypes_p, int iContext_p) throws Exception {
        return (int)this.getChildrenCountInternal();
    }

    private long getChildrenCountInternal() throws Exception {
        OwLoadContext loadContext = new OwLoadContext();
        loadContext.setPageSize(5);
        return this.getChildrenInternal(loadContext).getTotalNumItems();
    }

    protected OwIterable<OwObject> getChildrenInternal(OwLoadContext loadContext) throws OwException {
        String user;
        try {
            user = this.network.getCredentials().getAuthInfo("USER");
        }
        catch (Exception e) {
            throw new OwAlfrescoBPMException("Could not get current user from network.", (Throwable)e);
        }
        ContainerChildrenPageFetcher.ResourceProvider resourceProvider = this.getTasksInstancesResourceProvider(loadContext, user);
        return new OwCollectionIterable((OwAbstractPageFetcher)new ContainerChildrenPageFetcher(this, loadContext.getPageSize(), resourceProvider));
    }

    protected OwIterable<OwObject> getChildrenInternal(OwSearchNode filterCriteria, int iMaxSize) throws Exception {
        OwLoadContext loadContext = new OwLoadContext();
        loadContext.setFilter(filterCriteria);
        OwIterable<OwObject> children = this.getChildrenInternal(loadContext);
        OwIterable result = children.skipTo(0L).getPage(iMaxSize);
        return result;
    }

    protected ClientSideFilter getClientSideFilter(int fType) {
        switch (fType) {
            case 3: {
                return new StandardBPMClientSideFilter(new Date());
            }
            case 1: {
                return new ResubmissionClientSideFilter(new Date());
            }
        }
        return NoClientSideFilter.INSTANCE;
    }

    protected abstract ContainerChildrenPageFetcher.ResourceProvider getTasksInstancesResourceProvider(OwLoadContext var1, String var2);
}

