/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.alfresco.bpm.collections;

import com.wewebu.ow.server.collections.impl.OwAbstractPageFetcher;
import com.wewebu.ow.server.collections.impl.OwPage;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMException;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMRepository;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMWorkflowDescription;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.log.OwLog;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.AlfrescoRESTFulFactory;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.OperationContext;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.ProcessDefinitionsResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.RestCallTemplate;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.Entry;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.Pagination;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.ProcessDefinition;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.ProcessDefinitions;
import com.wewebu.ow.server.exceptions.OwException;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class ProcessDefinitionsPageFetcher
extends OwAbstractPageFetcher<OwAlfrescoBPMWorkflowDescription> {
    private static final Logger LOG = OwLog.getLogger(ProcessDefinitionsPageFetcher.class);
    private OwAlfrescoBPMRepository repository;

    public ProcessDefinitionsPageFetcher(OwAlfrescoBPMRepository repository) {
        this(repository, 100L);
    }

    private ProcessDefinitionsPageFetcher(OwAlfrescoBPMRepository repository, long maxNumItems) {
        super(maxNumItems);
        this.repository = repository;
    }

    protected OwPage<OwAlfrescoBPMWorkflowDescription> fetchPage(long skipCount) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Fetching a new page for process definitions from %d to %d.", skipCount, skipCount + this.maxNumItems));
        }
        AlfrescoRESTFulFactory restFulFactory = this.repository.getRestFulFactory();
        ProcessDefinitionsResource res = restFulFactory.processDefinitionsResource(new OperationContext(skipCount, this.maxNumItems));
        try {
            return (OwPage)new ProcessDefinitionsRestCall(this.repository).doCall(res);
        }
        catch (OwException e) {
            throw new OwAlfrescoBPMException("Could not fetch page.", (Throwable)e);
        }
    }

    public OwAbstractPageFetcher<OwAlfrescoBPMWorkflowDescription> newCopy(int maxNumItems) {
        return new ProcessDefinitionsPageFetcher(this.repository, maxNumItems);
    }

    protected static class ProcessDefinitionsRestCall
    extends RestCallTemplate<ProcessDefinitionsResource, OwPage<OwAlfrescoBPMWorkflowDescription>> {
        private OwAlfrescoBPMRepository repository;

        public ProcessDefinitionsRestCall(OwAlfrescoBPMRepository repository) {
            this.repository = repository;
        }

        @Override
        protected OwPage<OwAlfrescoBPMWorkflowDescription> execWith(ProcessDefinitionsResource resource) {
            ProcessDefinitions processDefinitions = (ProcessDefinitions)resource.list();
            LinkedList<OwAlfrescoBPMWorkflowDescription> items = new LinkedList<OwAlfrescoBPMWorkflowDescription>();
            for (Entry definition : processDefinitions.list.getEntries()) {
                items.add(new OwAlfrescoBPMWorkflowDescription((ProcessDefinition)definition.getEntry(), this.getRepository()));
            }
            Pagination pagination = processDefinitions.list.getPagination();
            return new OwPage(items, pagination.getTotalItems(), pagination.isHasMoreItems());
        }

        public OwAlfrescoBPMRepository getRepository() {
            return this.repository;
        }
    }
}

