/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest;

import com.wewebu.ow.server.ecmimpl.alfresco.bpm.log.OwLog;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.OperationContext;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.OwRestException;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.ProcessDefinitionStartFormModelResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.ProcessDefinitionsResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.ProcessImageResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.ProcessInstanceItemResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.ProcessInstanceItemsResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.ProcessInstanceResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.ProcessesResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.TaskFormModelResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.TaskInstanceResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.TaskInstanceStateResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.TaskInstanceVariableResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.TaskInstanceVariablesResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.TaskInstancesResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.WhereClause;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.Status;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.converters.NativeValueConverterFactory;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.old.AlfrescoRESTFulFactoryOld;
import com.wewebu.ow.server.field.OwSearchNode;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.alfresco.wd.ext.restlet.auth.OwRestletAuthenticationHandler;
import org.apache.log4j.Logger;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Uniform;
import org.restlet.data.Form;
import org.restlet.data.Language;
import org.restlet.data.Metadata;
import org.restlet.data.Parameter;
import org.restlet.data.Preference;
import org.restlet.data.Protocol;
import org.restlet.resource.ClientResource;

public class AlfrescoRESTFulFactory {
    private static final Logger LOG = OwLog.getLogger(AlfrescoRESTFulFactory.class);
    protected static final String WORKFLOW_PUBLIC_REST_API_PATH = "/api/-default-/public/workflow/versions/1";
    private String baseURL;
    private NativeValueConverterFactory valueConverterFactory;
    private ArrayList<Preference<Language>> acceptedLanguages;
    private Client clientConnector;
    private Map<String, String> callUrls;
    private OwRestletAuthenticationHandler authHandler;
    @Deprecated
    private AlfrescoRESTFulFactoryOld oldAPIFactory;

    public AlfrescoRESTFulFactory(String baseURL, OwRestletAuthenticationHandler authHandler, Locale currentLocale, NativeValueConverterFactory converterFactory) {
        this.baseURL = baseURL;
        this.authHandler = authHandler;
        this.callUrls = new HashMap<String, String>();
        this.valueConverterFactory = converterFactory;
        Language language = Language.valueOf((String)currentLocale.getLanguage());
        Preference currentLanguage = new Preference((Metadata)language);
        this.acceptedLanguages = new ArrayList();
        this.acceptedLanguages.add((Preference<Language>)currentLanguage);
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(Protocol.HTTPS);
        protocols.add(Protocol.HTTP);
        this.clientConnector = new Client(protocols){

            public void handle(Request request, Response response) {
                LOG.debug((Object)("REST : Calling resource " + request));
                super.handle(request, response);
            }
        };
        this.oldAPIFactory = new AlfrescoRESTFulFactoryOld(baseURL, authHandler, currentLocale, converterFactory);
    }

    public ProcessDefinitionsResource processDefinitionsResource(OperationContext context) throws OwRestException {
        String resourceURI;
        Form form = new Form();
        this.addPaginationParameters(form, context);
        try {
            resourceURI = String.format(this.getCallUrl("/process-definitions?%s"), form.encode());
        }
        catch (IOException e) {
            throw new OwRestException("Could not encode query parameters.", e);
        }
        return this.createResourceFor(resourceURI, ProcessDefinitionsResource.class);
    }

    public ProcessDefinitionStartFormModelResource processDefinitionStartFormModelResource(String processDefinitionId) throws OwRestException {
        return this.createResourceFor(String.format(this.getCallUrl("/process-definitions/%s/start-form-model"), processDefinitionId), ProcessDefinitionStartFormModelResource.class);
    }

    public TaskFormModelResource taskFormModelResource(String taskId) throws OwRestException {
        return this.createResourceFor(String.format(this.getCallUrl("/tasks/%s/task-form-model"), taskId), TaskFormModelResource.class);
    }

    public ProcessesResource processesResource() throws OwRestException {
        return this.createResourceFor(this.getCallUrl("/processes"), ProcessesResource.class);
    }

    public TaskInstanceResource taskInstanceResource(String taskId, String selectStatement) throws OwRestException {
        String taskInstanceIdEncoded = null;
        try {
            taskInstanceIdEncoded = URLEncoder.encode(taskId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OwRestException("Could not encode the workflow definition ID!", e);
        }
        String resourceUri = String.format(this.getCallUrl("/tasks/%s"), taskInstanceIdEncoded);
        if (null != selectStatement) {
            resourceUri = resourceUri + "?select=" + selectStatement;
        }
        return this.createResourceFor(resourceUri, TaskInstanceResource.class);
    }

    public TaskInstancesResource taskInstancesResource(String assignee, String candidateUser, String candidateGroup, Status status, OwSearchNode filterCriteria_p, OperationContext context) throws OwRestException {
        String resourceURI;
        Form form = new Form();
        this.addPaginationParameters(form, context);
        WhereClause whereClauseObj = WhereClause.emptyClause();
        if (null != filterCriteria_p) {
            whereClauseObj = WhereClause.fromOwSearchNode(filterCriteria_p, this.valueConverterFactory);
        }
        if (null != assignee) {
            whereClauseObj.addCriterion(new WhereClause.Criterion("assignee", null, "=", assignee));
        }
        if (null != candidateUser) {
            whereClauseObj.addCriterion(new WhereClause.Criterion("candidateUser", null, "=", candidateUser));
        } else if (null != candidateGroup) {
            whereClauseObj.addCriterion(new WhereClause.Criterion("candidateGroup", null, "=", candidateGroup));
        }
        whereClauseObj.addCriterion(new WhereClause.Criterion("status", null, "=", status.toString()));
        whereClauseObj.addCriterion(new WhereClause.Criterion("includeTaskVariables", null, "=", "true"));
        whereClauseObj.addCriterion(new WhereClause.Criterion("includeProcessVariables", null, "=", "true"));
        form.add((Object)new Parameter("where", String.format("(%s)", whereClauseObj.toString())));
        try {
            resourceURI = String.format(this.getCallUrl("/tasks?%s"), form.encode());
        }
        catch (IOException e) {
            throw new OwRestException("Could not encode query parameters.", e);
        }
        TaskInstancesResource result = this.createResourceFor(resourceURI, TaskInstancesResource.class);
        return result;
    }

    private void addPaginationParameters(Form form, OperationContext context) {
        long skipCount = context.getSkipCount();
        long maxItems = context.getMaxItems();
        if (skipCount >= 0L) {
            form.add((Object)new Parameter("skipCount", Long.toString(skipCount)));
        }
        if (maxItems >= 0L) {
            form.add((Object)new Parameter("maxItems", Long.toString(maxItems)));
        } else {
            form.add((Object)new Parameter("maxItems", Long.toString(Long.MAX_VALUE)));
        }
    }

    public TaskInstancesResource taskInstancesForProcessResource(String processId) throws OwRestException {
        String processIdEncoded = null;
        try {
            processIdEncoded = URLEncoder.encode(processId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OwRestException("Could not encode the workflow definition ID!", e);
        }
        String resourceURI = this.getCallUrl("/processes/%s/tasks");
        return this.createResourceFor(String.format(resourceURI, processIdEncoded), TaskInstancesResource.class);
    }

    public ProcessInstanceItemsResource processInstanceItems(String processId) throws OwRestException {
        String processIdEncoded = null;
        try {
            processIdEncoded = URLEncoder.encode(processId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OwRestException("Could not encode the process ID!", e);
        }
        String resourceURI = String.format(this.getCallUrl("/processes/%s/items"), processIdEncoded);
        return this.createResourceFor(resourceURI, ProcessInstanceItemsResource.class);
    }

    public ProcessInstanceItemResource processInstanceItem(String processId, String itemGuidId) throws OwRestException {
        String processIdEncoded = null;
        try {
            processIdEncoded = URLEncoder.encode(processId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OwRestException("Could not encode the item ID!", e);
        }
        String resourceURI = String.format(this.getCallUrl("/processes/%s/items/%s"), processIdEncoded, itemGuidId);
        return this.createResourceFor(resourceURI, ProcessInstanceItemResource.class);
    }

    public ProcessInstanceResource processInstance(String processId) throws OwRestException {
        String processInstanceIdEncoded = null;
        if (processId != null) {
            try {
                processInstanceIdEncoded = URLEncoder.encode(processId, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new OwRestException("Could not encode the workflow definition ID!", e);
            }
        }
        String resourceURI = String.format(this.getCallUrl("/processes/%s"), processInstanceIdEncoded);
        return this.createResourceFor(resourceURI, ProcessInstanceResource.class);
    }

    public ProcessImageResource processImageResource(String processId) throws OwRestException {
        String resourceURI = String.format(this.getCallUrl("/processes/%s/image"), processId);
        return this.createResourceFor(resourceURI, ProcessImageResource.class);
    }

    public TaskInstanceVariableResource taskInstanceVariableResource(String taskId, String variableName) throws OwRestException {
        String taskInstanceIdEncoded = null;
        String variableNameEncoded = null;
        try {
            taskInstanceIdEncoded = URLEncoder.encode(taskId, "UTF-8");
            variableNameEncoded = URLEncoder.encode(variableName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OwRestException("Could not encode the workflow definition ID!", e);
        }
        String resourceUri = String.format(this.getCallUrl("/tasks/%s/variables/%s"), taskInstanceIdEncoded, variableNameEncoded);
        return this.createResourceFor(resourceUri, TaskInstanceVariableResource.class);
    }

    public TaskInstanceVariablesResource taskInstanceVariablesResource(String taskId) throws OwRestException {
        String taskInstanceIdEncoded = null;
        try {
            taskInstanceIdEncoded = URLEncoder.encode(taskId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OwRestException("Could not encode the workflow definition ID!", e);
        }
        String resourceUri = String.format(this.getCallUrl("/tasks/%s/variables"), taskInstanceIdEncoded);
        return this.createResourceFor(resourceUri, TaskInstanceVariablesResource.class);
    }

    public TaskInstanceStateResource taskInstanceStateResource(String taskInstanceId) throws OwRestException {
        String taskInstanceIdEncoded = null;
        try {
            taskInstanceIdEncoded = URLEncoder.encode(taskInstanceId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OwRestException("Could not encode the workflow definition ID!", e);
        }
        String resourceUri = String.format(this.getCallUrl("/tasks/%s?select=state"), taskInstanceIdEncoded);
        return this.createResourceFor(resourceUri, TaskInstanceStateResource.class);
    }

    protected String getCallUrl(String actionUri) {
        String callUrl = this.callUrls.get(actionUri);
        if (callUrl == null) {
            callUrl = this.baseURL + WORKFLOW_PUBLIC_REST_API_PATH + actionUri;
            this.callUrls.put(actionUri, callUrl);
        }
        return callUrl;
    }

    private <T> T createResourceFor(String resourceURI, Class<T> wrappedClass) throws OwRestException {
        if (null == this.clientConnector) {
            throw new OwRestException("RESTFull Factory was already released.");
        }
        ClientResource cr = new ClientResource(resourceURI);
        this.authHandler.prepareCall(cr);
        cr.getConverterService().setEnabled(true);
        cr.setNext((Uniform)this.clientConnector);
        Object resource = cr.wrap(wrappedClass);
        final Uniform originalNext = cr.getNext();
        cr.setNext(new Uniform(){

            public void handle(Request request, Response response) {
                request.getClientInfo().setAcceptedLanguages((List)AlfrescoRESTFulFactory.this.acceptedLanguages);
                if (null != originalNext) {
                    originalNext.handle(request, response);
                }
            }
        });
        cr.getClientInfo().setAcceptedLanguages(this.acceptedLanguages);
        return (T)resource;
    }

    public void release() {
        try {
            this.clientConnector.stop();
            this.clientConnector = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.oldAPIFactory.release();
    }

    public AlfrescoRESTFulFactoryOld getOldAPIFactory() {
        return this.oldAPIFactory;
    }
}

