/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.converters;

import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.converters.NativeValueConverter;
import com.wewebu.ow.server.ecmimpl.opencmis.util.OwCMISDateTime;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.util.OwDateTimeUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateNativeValueConverter
implements NativeValueConverter {
    private TimeZone timeZone;

    public DateNativeValueConverter(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public Object fromNative(Object nativeValue) throws OwException {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            String strNative = (String)nativeValue;
            Date firstDateAttempt = format.parse(strNative);
            TimeZone tzServer = Calendar.getInstance().getTimeZone();
            Date secondDateAttempt = OwDateTimeUtil.convert((Date)firstDateAttempt, (TimeZone)tzServer, (TimeZone)this.timeZone);
            return secondDateAttempt;
        }
        catch (ParseException e) {
            throw new OwServerException("Could not get java value from native value " + nativeValue, (Throwable)e);
        }
    }

    @Override
    public Object fromJava(Object javaValue) throws OwException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        Date dateValue = (Date)javaValue;
        OwCMISDateTime cmisDateTime = new OwCMISDateTime(dateValue, this.timeZone);
        Date preparedDate = cmisDateTime.getDate(false);
        String iso8601Representation = format.format(preparedDate);
        return iso8601Representation;
    }
}

