/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.converters;

import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.converters.ArrayAgregateConverter;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.converters.DateNativeValueConverter;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.converters.DefaultNativeValueConverter;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.converters.NativeValueConverter;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.converters.NativeValueConverterFactory;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.converters.OwUserInfoNativeValueConverter;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.field.OwFieldDefinition;
import java.util.Date;
import java.util.TimeZone;

public class NativeValueConverterFactoryRest
implements NativeValueConverterFactory {
    private TimeZone timeZone;

    public NativeValueConverterFactoryRest(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public NativeValueConverter converterFor(OwFieldDefinition propertyClass) throws OwException {
        Class<?> propertyJavaClass;
        String propertyClassName = propertyClass.getJavaClassName();
        try {
            propertyJavaClass = Class.forName(propertyClassName);
        }
        catch (ClassNotFoundException e) {
            throw new OwServerException("Could not find java class for property class.", (Throwable)e);
        }
        NativeValueConverter converter = Date.class.isAssignableFrom(propertyJavaClass) ? new DateNativeValueConverter(this.timeZone) : (OwUserInfo.class.isAssignableFrom(propertyJavaClass) ? new OwUserInfoNativeValueConverter() : new DefaultNativeValueConverter(propertyClass));
        try {
            if (propertyClass.isArray()) {
                converter = new ArrayAgregateConverter(converter);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new OwServerException("Could not get native converter.", (Throwable)e);
        }
        return converter;
    }
}

