/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owbpm;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMasterDocument;
import com.wewebu.ow.server.collections.OwLoadContext;
import com.wewebu.ow.server.ecm.bpm.OwWorkitemRepository;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwFieldDefinitionProvider;
import com.wewebu.ow.server.field.OwPriorityRuleFactory;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.field.OwStandardFieldColumnInfoString;
import com.wewebu.ow.server.plug.owbpm.OwBPMQueue;
import com.wewebu.ow.server.plug.owbpm.OwBPMVirtualQueue;
import com.wewebu.ow.server.plug.owbpm.log.OwLog;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class OwBPMDocument
extends OwMasterDocument {
    private static final Logger LOG = OwLog.getLogger(OwBPMDocument.class);
    protected static final String CONFIG_NODE_PAGEABLE = "pageable";
    public static final String QUEUE_DELIMITER = "delimiter";
    private static final String EL_QUEUES = "Queues";
    private static final String EL_QUEUE = "Queue";
    private static final String ATT_HIDE_IF_EMPTY = "hideIfEmpty";
    public static final String SETTINGS_PARAM_COLUMN_INFO = "columninfo";
    public static final String SETTINGS_PARAM_SORT = "ColumnSortCriteria";
    protected OwWorkitemRepository m_bpmrepository;
    protected List m_columnInfoList;
    protected Map m_rulemap;
    private boolean usePaging;

    public Map getRuleMap() throws Exception {
        if (null == this.m_rulemap) {
            OwPriorityRuleFactory prFactory = OwPriorityRuleFactory.getInstance();
            OwXMLUtil configNode = this.getConfigNode();
            OwWorkitemRepository fieldefinitionprovider = this.getBpmRepository();
            this.m_rulemap = prFactory.createRulesContainerMap(configNode, (OwFieldDefinitionProvider)fieldefinitionprovider);
        }
        return this.m_rulemap;
    }

    protected List getDefaultColumnInfo() throws Exception {
        if (this.m_columnInfoList == null) {
            this.m_columnInfoList = new ArrayList();
            List popertyNameList = (List)this.getSafeSetting(SETTINGS_PARAM_COLUMN_INFO, null);
            for (String strPropertyName : popertyNameList) {
                if (null == strPropertyName) continue;
                this.m_columnInfoList.add(new OwStandardFieldColumnInfoString(strPropertyName, 0));
            }
        }
        return this.m_columnInfoList;
    }

    protected List getColumnSortCriteria() throws Exception {
        List properties = (List)this.getSafeSetting(SETTINGS_PARAM_SORT, null);
        ArrayList<OwSort.OwSortCriteria> sortCriterias = new ArrayList<OwSort.OwSortCriteria>();
        HashSet<OwSort.OwSortCriteria> duplicateDedectionSet = new HashSet<OwSort.OwSortCriteria>();
        if (properties != null) {
            for (OwSort.OwSortCriteria sortCriteria : properties) {
                if (sortCriteria == null) {
                    StringBuffer buf = new StringBuffer();
                    buf.append("owplugins.xml - master plugin with id=");
                    buf.append(this.getPluginID());
                    buf.append(": tag <ColumnSortCriteria> is configured wrongly:");
                    buf.append(" one <property> tag contains no value.");
                    buf.append(" This tag was ignored");
                    LOG.warn((Object)buf.toString());
                    continue;
                }
                if (duplicateDedectionSet.contains(sortCriteria)) {
                    StringBuffer buf = new StringBuffer();
                    buf.append("owplugins.xml - master plugin with id=");
                    buf.append(this.getPluginID());
                    buf.append(": tag <ColumnSortCriteria> is configured wrongly:");
                    buf.append(" one <property> tag contains a value=");
                    buf.append(sortCriteria.getPropertyName());
                    buf.append(" that was defined before.");
                    buf.append(" This tag was ignored");
                    LOG.warn((Object)buf.toString());
                    continue;
                }
                duplicateDedectionSet.add(sortCriteria);
                boolean sortAscending = sortCriteria.getAscFlag();
                sortCriterias.add(new OwSort.OwSortCriteria(sortCriteria.getPropertyName(), sortAscending));
            }
        }
        return sortCriterias;
    }

    public Collection getWorkQueues() throws Exception {
        ArrayList<OwBPMQueue> queueWrapperList = new ArrayList<OwBPMQueue>();
        OwXMLUtil queues = this.getConfigNode().getSubUtil(EL_QUEUES);
        if (null == queues) {
            return Collections.emptyList();
        }
        List configqueuelist = queues.getSafeUtilList(EL_QUEUE);
        boolean fCanAddDelimiter = false;
        for (OwXMLUtil aQueue : configqueuelist) {
            String sQueueInfo = aQueue.getSafeTextValue(null);
            boolean bHideIfEmpty = aQueue.getSafeBooleanAttributeValue(ATT_HIDE_IF_EMPTY, false);
            if (null == sQueueInfo) continue;
            try {
                StringTokenizer queueinfo = new StringTokenizer(sQueueInfo, "/");
                String sPrefix = queueinfo.nextToken();
                int iQueuetype = OwWorkitemRepository.m_containerprefixmap.getContainerType(sPrefix);
                String sQueuename = queueinfo.nextToken();
                if (sQueuename.endsWith("*")) {
                    Collection queuenames = this.getBpmRepository().getWorkitemContainerIDs(false, iQueuetype);
                    for (String name : queuenames) {
                        String sThisContainerPath = "/" + sPrefix + "/" + name;
                        List rulelist = null;
                        try {
                            rulelist = (Vector)this.getRuleMap().get(sThisContainerPath);
                            if (null == rulelist) {
                                rulelist = (List)this.getRuleMap().get(sQueueInfo);
                            }
                        }
                        catch (Exception e) {
                            LOG.error((Object)"GetWorkQueus could not create priorityrules.", (Throwable)e);
                        }
                        if (rulelist == null) {
                            rulelist = new Vector();
                        }
                        queueWrapperList.add(new OwBPMQueue(this, this.getBpmRepository().getWorkitemContainer(name, iQueuetype), rulelist, bHideIfEmpty));
                        fCanAddDelimiter = true;
                    }
                    continue;
                }
                String sWildCardContainerPath = "/" + sPrefix + "/" + "*";
                List rulelist = (List)this.getRuleMap().get(sQueueInfo);
                if (null == rulelist) {
                    rulelist = (List)this.getRuleMap().get(sWildCardContainerPath);
                }
                queueWrapperList.add(new OwBPMQueue(this, this.getBpmRepository().getWorkitemContainer(sQueuename, iQueuetype), rulelist, bHideIfEmpty));
                fCanAddDelimiter = true;
            }
            catch (OwObjectNotFoundException e) {
                if (sQueueInfo.equals(QUEUE_DELIMITER)) {
                    if (!fCanAddDelimiter) continue;
                    queueWrapperList.add(null);
                    fCanAddDelimiter = false;
                    continue;
                }
                throw new OwConfigurationException("Unknown queue info in plugin descriptor: " + sQueueInfo, (Throwable)e);
            }
        }
        if (queueWrapperList.size() > 0 && queueWrapperList.get(queueWrapperList.size() - 1) == null) {
            queueWrapperList.remove(queueWrapperList.size() - 1);
        }
        return queueWrapperList;
    }

    public OwWorkitemRepository getBpmRepository() throws Exception {
        if (null == this.m_bpmrepository) {
            if (!((OwMainAppContext)this.getContext()).getNetwork().hasInterface("com.wewebu.ow.server.ecm.bpm.OwWorkitemRepository")) {
                String msg = "OwBPMDocument.getBpmRepository: The ECM adapter does not offer an interface for BPM Repository (OwWorkitemRepository).";
                LOG.info((Object)msg);
                throw new OwConfigurationException(this.getContext().localize("owbpm.OwBPMDocument.noInterfaceSupport", "The ECM adapter does not offer an interface for BPM Repository (OwWorkitemRepository)."));
            }
            this.m_bpmrepository = (OwWorkitemRepository)((OwMainAppContext)this.getContext()).getNetwork().getInterface("com.wewebu.ow.server.ecm.bpm.OwWorkitemRepository", null);
        }
        return this.m_bpmrepository;
    }

    public int getMaxChildCount() {
        return this.getConfigNode().getSafeIntegerValue("MaxChildCount", 100);
    }

    protected void init() throws Exception {
        super.init();
        this.usePaging = this.getConfigNode().getSafeBooleanValue(CONFIG_NODE_PAGEABLE, false);
    }

    public boolean isUsePaging() {
        return this.usePaging;
    }

    protected OwLoadContext createLoadContext(OwBPMVirtualQueue queue) throws Exception {
        OwLoadContext loadContext = new OwLoadContext();
        loadContext.setObjectTypes(new int[]{16384});
        OwSort sort = queue.getSort();
        loadContext.setSorting(sort);
        int versionSelectDefault = 1;
        loadContext.setVersionSelection(versionSelectDefault);
        return loadContext;
    }
}

