/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owbpm;

import com.wewebu.ow.server.app.OwFieldManagerControl;
import com.wewebu.ow.server.app.OwUserSelectDialog;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.plug.owbpm.log.OwLog;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.util.OwHTMLHelper;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class OwBPMParticipantPropertyControl
extends OwFieldManagerControl
implements OwDialog.OwDialogListener {
    private static final Logger LOG = OwLog.getLogger(OwBPMParticipantPropertyControl.class);
    protected static final String ARRAY_ITEM_INDEX_KEY = "a_item";
    protected static final String FIELD_ID_KEY = "field_id";

    protected String getUserDisplayName(Object value_p) {
        if (null != value_p) {
            return value_p.toString();
        }
        return "";
    }

    public void insertReadOnlyField(Writer w_p, OwFieldDefinition fieldDef_p, Object value_p) throws Exception {
        if (fieldDef_p.isArray()) {
            Object[] values = (Object[])value_p;
            if (values != null) {
                w_p.write("<table border='0' cellpadding='0' cellspacing='0'>");
                for (int i = 0; i < values.length; ++i) {
                    w_p.write("<tr><td valign='center'>");
                    OwHTMLHelper.writeSecureHTML((Writer)w_p, (String)this.getUserDisplayName(values[i]));
                    w_p.write("</td></tr>");
                }
                w_p.write("</table>");
            }
        } else {
            String msg = "OwBPMParticipantPropertyControl.insertReadOnlyField: Participant (Workgroup) should always be an array.";
            LOG.fatal((Object)msg);
            throw new OwConfigurationException(msg);
        }
    }

    public void insertEditField(Writer w_p, OwFieldDefinition fieldDef_p, OwField field_p, String strID_p) throws Exception {
        if (fieldDef_p.isArray()) {
            Object[] values = (Object[])field_p.getValue();
            if (values != null) {
                w_p.write("<table border='0' cellpadding='0' cellspacing='0'>");
                for (int i = 0; i < values.length; ++i) {
                    w_p.write("<tr><td valign='center'>");
                    w_p.write("<input class='OwInputControl' name='");
                    OwHTMLHelper.writeSecureHTML((Writer)w_p, (String)strID_p);
                    w_p.write("' type='text' value='");
                    OwHTMLHelper.writeSecureHTML((Writer)w_p, (String)this.getUserDisplayName(values[i]));
                    w_p.write("' readonly>");
                    w_p.write("</td><td><a title='");
                    w_p.write(this.getContext().localize("app.OwStandardFieldManager.delarrayitem", "Delete Element"));
                    w_p.write("' href=\"");
                    w_p.write(this.getFormEventURL("DeleteArrayItem", "a_item=" + String.valueOf(i) + "&" + FIELD_ID_KEY + "=" + strID_p));
                    w_p.write("\"><img src='");
                    w_p.write(this.getContext().getDesignURL());
                    w_p.write("/images/deletebtn.png'");
                    String imageTitle = this.getContext().localize1("fncm.bpm.OwBPMParticipantPropertyControl.deleteParticipant", "Delete participant number %1.", "" + (i + 1));
                    w_p.write(" alt='" + imageTitle + "' title='" + imageTitle + "'");
                    w_p.write("/>");
                    w_p.write("</a></td></tr>");
                }
                w_p.write("</table>");
            }
        } else {
            String msg = "OwBPMParticipantPropertyControl.insertEditField: Participant (Workgroup) should always be an array.";
            LOG.fatal((Object)msg);
            throw new OwConfigurationException(msg);
        }
        StringBuffer addEventURL = new StringBuffer("javascript:document.");
        addEventURL.append(this.getFieldManager().getFormName());
        addEventURL.append(".action = '");
        addEventURL.append(this.getEventURL("OpenUserDialog", "field_id=" + strID_p));
        addEventURL.append("';document.");
        addEventURL.append(this.getFieldManager().getFormName());
        addEventURL.append(".submit()");
        w_p.write("<a title='");
        String addParticipantTitle = this.getContext().localize("fncm.bpm.OwBPMParticipantPropertyControl.addparticipant", "Add another participant.");
        w_p.write(addParticipantTitle);
        w_p.write("' href=\"");
        w_p.write(addEventURL.toString());
        w_p.write("\"><img style='vertical-align:middle;border:0px none;margin:5px 0px;' src='");
        w_p.write(this.getContext().getDesignURL());
        w_p.write("/images/addbtn.png' ");
        w_p.write("alt='" + addParticipantTitle + "' title='" + addParticipantTitle + "' ");
        w_p.write("/></a>");
    }

    public void onDeleteArrayItem(HttpServletRequest request_p) throws Exception {
        int iIndex = Integer.parseInt(request_p.getParameter(ARRAY_ITEM_INDEX_KEY));
        OwField field = this.getFieldManager().getField(request_p.getParameter(FIELD_ID_KEY));
        Object[] values = (Object[])field.getValue();
        if (values.length < 2) {
            field.setValue(null);
            return;
        }
        Object[] newValues = new Object[values.length - 1];
        int iNew = 0;
        int iOrigin = 0;
        do {
            if (iIndex == iOrigin) {
                // empty if block
            }
            int n = iNew++;
            int n2 = ++iOrigin;
            ++iOrigin;
            newValues[n] = values[n2];
        } while (iNew < newValues.length);
        field.setValue((Object)newValues);
    }

    public Object updateField(HttpServletRequest request_p, OwFieldDefinition fieldDef_p, Object value_p, String strID_p) throws Exception {
        return value_p;
    }

    public void onOpenUserDialog(HttpServletRequest request_p) throws Exception {
        OwField field = this.getFieldManager().getField(request_p.getParameter(FIELD_ID_KEY));
        OwParticipantUserSelectDialog userSelectDlg = new OwParticipantUserSelectDialog(new int[]{1, 2}, true, field);
        this.getContext().openDialog((OwDialog)userSelectDlg, (OwDialog.OwDialogListener)this);
    }

    public void onDialogClose(OwDialog dialogView_p) throws Exception {
        OwParticipantUserSelectDialog dialog = (OwParticipantUserSelectDialog)dialogView_p;
        String newParticipant = null;
        List users = dialog.getSelectedUsers();
        if (null != users) {
            for (OwUserInfo userinfo : users) {
                newParticipant = userinfo.getUserLongName();
            }
        } else {
            List roles = dialog.getSelectedRoles();
            if (null != roles) {
                for (OwUserInfo userinfo : roles) {
                    newParticipant = userinfo.getUserLongName();
                }
            }
        }
        if (newParticipant != null) {
            OwField participantsField = dialog.m_participants;
            Object[] participants = (Object[])participantsField.getValue();
            Object[] newValues = null;
            if (null == participants) {
                newValues = new Object[1];
            } else {
                newValues = new Object[participants.length + 1];
                for (int i = 0; i < participants.length; ++i) {
                    newValues[i] = participants[i];
                }
            }
            newValues[newValues.length - 1] = newParticipant;
            LOG.info((Object)("OwBPMParticipantPropertyControl.onDialogClose(): seting new value = " + newParticipant));
            participantsField.setValue((Object)newValues);
        }
    }

    public void onUpdate(OwEventTarget caller_p, int code_p, Object param_p) throws Exception {
    }

    public void insertLabel(Writer w_p, String suffix_p, OwField field, String strID_p, boolean writeLabel_p) throws Exception {
        OwFieldDefinition fieldDef_p = field.getFieldDefinition();
        w_p.write("<span>");
        w_p.write(fieldDef_p.getDisplayName(this.getContext().getLocale()));
        if (suffix_p != null) {
            w_p.write(suffix_p);
        }
        w_p.write("</span>");
    }

    public class OwParticipantUserSelectDialog
    extends OwUserSelectDialog {
        private OwField m_participants;

        public OwParticipantUserSelectDialog(int[] filterType_p, boolean fMultiselect_p, OwField participants_p) {
            super(filterType_p, fMultiselect_p);
            this.m_participants = participants_p;
        }
    }
}

