/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owbpm.plug;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.plug.owbpm.plug.OwBPMDisplayWorkflowDialog;
import com.wewebu.ow.server.plug.owbpm.plug.OwBPMDisplayWorkflowDialogBuilder;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.ui.OwEventTarget;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class OwBPMDisplayGraphicalWorkflow
extends OwDocumentFunction {
    protected OwDialog.OwDialogListener m_Listener;

    public String getIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", "/images/plug/owbpm/workflow.png");
    }

    public String getBigIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", "/images/plug/owbpm/workflow_24.png");
    }

    public void onClickEvent(OwObject oObject_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        if (!this.isEnabled(oObject_p, oParent_p, 2)) {
            throw new OwInvalidOperationException(this.getContext().localize("plug.owbpm.OwBPMDisplayGraphicalWorkflow.invalidobject", "Cannot create object for graphical workflow representation."));
        }
        LinkedList<OwObject> objects = new LinkedList<OwObject>();
        objects.add(oObject_p);
        this.onMultiselectClickEvent(objects, oParent_p, refreshCtx_p);
    }

    public void onMultiselectClickEvent(Collection objects_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        Iterator it = objects_p.iterator();
        HashSet<OwObject> objectsToDisplayTheDiagramFor = new HashSet<OwObject>();
        while (it.hasNext()) {
            OwObject obj = (OwObject)it.next();
            if (!this.isEnabled(obj, oParent_p, 2)) continue;
            objectsToDisplayTheDiagramFor.add(obj);
        }
        if (objects_p.size() == 0) {
            return;
        }
        this.displayMessageBox(objectsToDisplayTheDiagramFor, oParent_p);
    }

    public void onUpdate(OwEventTarget caller_p, int code_p, Object param_p) throws Exception {
    }

    private void displayMessageBox(Set<OwObject> objects, OwObject oParent_p) throws Exception {
        OwBPMDisplayWorkflowDialog dlg = this.buildOwBPMDisplayWorkflowDialog(objects, oParent_p);
        dlg.setHelp(this.getHelpPath());
        dlg.setTitle(this.getContext().localize("owbpm.OwBPMDisplayWorkflowDialog.helptitle", "Display Workflow"));
        dlg.setInfoIcon(this.getBigIcon());
        this.getContext().openDialog((OwDialog)dlg, this.m_Listener);
    }

    private OwBPMDisplayWorkflowDialog buildOwBPMDisplayWorkflowDialog(Set<OwObject> objects, OwObject oParent_p) throws Exception {
        OwBPMDisplayWorkflowDialogBuilder builder = this.createDialogBuilder();
        builder.items(objects).index(0).parentObject(oParent_p);
        return builder.build();
    }

    protected OwBPMDisplayWorkflowDialogBuilder createDialogBuilder() {
        return new OwBPMDisplayWorkflowDialogBuilder();
    }
}

