/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owbpm.plug;

import com.wewebu.ow.server.app.OwAbstractToolExtension;
import com.wewebu.ow.server.app.OwStandardSequenceDialog;
import com.wewebu.ow.server.ecm.bpm.OwWorkflowDescription;
import com.wewebu.ow.server.ecm.bpm.OwWorkitem;
import com.wewebu.ow.server.ecm.bpm.OwWorkitemRepository;
import com.wewebu.ow.server.exceptions.OwAccessDeniedException;
import com.wewebu.ow.server.plug.owbpm.log.OwLog;
import com.wewebu.ow.server.plug.owbpm.plug.OwBPMJspLaunchProcessorDialog;
import com.wewebu.ow.server.plug.owbpm.plug.OwBPMLaunchableWorkflowSelectionDialog;
import com.wewebu.ow.server.plug.owbpm.plug.OwBPMStandardLaunchProcessorDialog;
import com.wewebu.ow.server.role.OwRoleManager;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString1;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class OwBPMNewWorkflowExtension
extends OwAbstractToolExtension {
    private static final Logger LOG = OwLog.getLogger(OwBPMNewWorkflowExtension.class);
    private static final String BPM_WORKITEM_REPOSITORY_INTERFACE = "com.wewebu.ow.server.ecm.bpm.OwWorkitemRepository";
    protected static final String BIGICON_DESIGN_PATH = "/images/plug/owbpm/gear_new_24.png";
    protected static final String ICON_DESIGN_PATH = "/images/plug/owbpm/gear_new.png";

    protected String getDefaultBigIcon() {
        return BIGICON_DESIGN_PATH;
    }

    protected String getDefaultIcon() {
        return ICON_DESIGN_PATH;
    }

    public void onClickEvent() throws Exception {
        final OwWorkitemRepository bpmRepository = (OwWorkitemRepository)this.m_context.getNetwork().getInterface(BPM_WORKITEM_REPOSITORY_INTERFACE, null);
        if (!bpmRepository.canLaunch()) {
            String msg = "OwBPMNewWorkflowExtension.onClickEvent: The configured work item repository does not support the launching workflows.This extension will be disabled!";
            LOG.warn((Object)msg);
            return;
        }
        Collection workflowDescriptions = bpmRepository.getLaunchableWorkflowDescriptions(null);
        LinkedList<OwWorkflowDescription> allowedWorkflowDescriptions = new LinkedList<OwWorkflowDescription>();
        for (Object object : workflowDescriptions) {
            OwWorkflowDescription description = (OwWorkflowDescription)object;
            if (!this.m_context.isAllowed(13, description.getId())) continue;
            allowedWorkflowDescriptions.add(description);
        }
        final OwBPMLaunchableWorkflowSelectionDialog workflowSelectionDialog = new OwBPMLaunchableWorkflowSelectionDialog(allowedWorkflowDescriptions);
        this.m_context.openDialog((OwDialog)workflowSelectionDialog, new OwDialog.OwDialogListener(){

            public void onUpdate(OwEventTarget caller_p, int code_p, Object param_p) throws Exception {
            }

            public void onDialogClose(OwDialog dialogView_p) throws Exception {
                OwWorkflowDescription selection = workflowSelectionDialog.getSelection();
                if (selection != null) {
                    OwRoleManager roleManager = OwBPMNewWorkflowExtension.this.m_context.getNetwork().getRoleManager();
                    if (!roleManager.isAllowed(13, selection.getId())) {
                        OwString1 message = new OwString1("plug.owbpm.err.startWorkflow.accessDenied", "The current user does not have permission to start workflow '%1'.", selection.getName());
                        throw new OwAccessDeniedException((OwString)message);
                    }
                    OwWorkitem workItem = bpmRepository.createLaunchableItem(selection, null);
                    OwStandardSequenceDialog standardProcessorDialog = OwBPMNewWorkflowExtension.this.createProcessorDialog(workItem);
                    standardProcessorDialog.setTitle(OwBPMNewWorkflowExtension.this.m_context.localize("owbpm.OwBPMLaunchProcessorFunction.launchdialogtitle", "Launch:") + selection.getName());
                    OwBPMNewWorkflowExtension.this.m_context.openDialog((OwDialog)standardProcessorDialog, null);
                }
            }
        });
    }

    protected OwStandardSequenceDialog createProcessorDialog(OwWorkitem workItem_p) throws Exception {
        OwStandardSequenceDialog result = null;
        result = this.m_jspForm == null ? new OwBPMStandardLaunchProcessorDialog(workItem_p, null, this.m_confignode) : new OwBPMJspLaunchProcessorDialog(Arrays.asList(workItem_p), this.m_confignode, null);
        return result;
    }
}

