/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owbpm.plug;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.bpm.OwWorkitem;
import com.wewebu.ow.server.ecm.bpm.OwWorkitemContainer;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.plug.owbpm.log.OwLog;
import org.apache.log4j.Logger;

public class OwBPMPullFunction
extends OwDocumentFunction {
    private static final Logger LOG = OwLog.getLogger(OwBPMPullFunction.class);
    private OwDocumentFunction m_dispatchfunction;

    protected OwDocumentFunction getDispatchFunction() throws Exception {
        if (null == this.m_dispatchfunction) {
            String sDispatchDocumentFunctionPluginID = this.getConfigNode().getSafeTextValue("DispatchFunction", null);
            if (sDispatchDocumentFunctionPluginID == null) {
                String msg = "OwBPMPullFunction.getDispatchFunction: Define a DispatchFunction.";
                LOG.fatal((Object)msg);
                throw new OwConfigurationException(msg);
            }
            this.m_dispatchfunction = this.getContext().getConfiguration().getDocumentFunction(sDispatchDocumentFunctionPluginID);
        }
        return this.m_dispatchfunction;
    }

    public String getIcon() throws Exception {
        return this.getDispatchFunction().getIcon();
    }

    public String getBigIcon() throws Exception {
        return this.getDispatchFunction().getBigIcon();
    }

    public boolean isEnabled(OwObject oObject_p, OwObject oParent_p, int iContext_p) throws Exception {
        if (super.isEnabled(oObject_p, oParent_p, iContext_p)) {
            return ((OwWorkitemContainer)oObject_p).canPull(iContext_p);
        }
        return false;
    }

    public void onClickEvent(OwObject oObject_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        try {
            OwWorkitem pulleditem = ((OwWorkitemContainer)oObject_p).pull(null, null);
            this.getDispatchFunction().onClickEvent((OwObject)pulleditem, oObject_p, refreshCtx_p);
            this.addHistoryEvent(oObject_p, oParent_p, 1, 1);
        }
        catch (OwObjectNotFoundException e) {
            this.addHistoryEvent(oObject_p, oParent_p, 1, 2);
            throw new OwObjectNotFoundException(this.getContext().localize("plug.owbpm.OwBPMPullFunction.pullfailed", "There is no work item to edit."), (Throwable)e);
        }
        catch (OwServerException e2) {
            this.addHistoryEvent(oObject_p, oParent_p, 1, 2);
            throw new OwObjectNotFoundException(this.getContext().localize("plug.owbpm.OwBPMPullFunction.pulltimeout", "No work item opened for editing. Please try it again."), (Throwable)e2);
        }
    }
}

