/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owbpm.plug;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMimeManager;
import com.wewebu.ow.server.app.OwSequenceView;
import com.wewebu.ow.server.app.OwStandardSequenceDialog;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.bpm.OwWorkitem;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.plug.owbpm.log.OwLog;
import com.wewebu.ow.server.plug.owbpm.plug.OwBPMProcessorDialog;
import com.wewebu.ow.server.plug.owbpm.plug.OwBPMStandardProcessorView;
import com.wewebu.ow.server.ui.OwDocument;
import com.wewebu.ow.server.ui.OwView;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class OwBPMStandardProcessorDialog
extends OwStandardSequenceDialog
implements OwBPMProcessorDialog {
    private static final Logger LOG = OwLog.getLogger(OwBPMStandardProcessorDialog.class);
    protected OwBPMStandardProcessorView m_view;
    protected OwMimeManager m_MimeManager = new OwMimeManager();
    protected OwXMLUtil m_configNode;
    protected boolean m_fAutoOpen = false;
    protected List m_worktitems;
    protected int m_iIndex = 0;
    protected OwClientRefreshContext m_refreshCtx;

    public OwBPMStandardProcessorDialog(Collection objects_p, OwClientRefreshContext refreshCtx_p, OwXMLUtil configNode_p) throws Exception {
        this.m_refreshCtx = refreshCtx_p;
        this.m_configNode = configNode_p;
        this.m_fAutoOpen = this.m_configNode.getSafeBooleanValue("AutoOpen", false);
        this.m_worktitems = objects_p instanceof List ? (List)objects_p : new ArrayList(objects_p);
        this.m_view = this.createProcessorView(this.m_configNode);
    }

    protected void init() throws Exception {
        super.init();
        this.m_MimeManager.attach(this.getContext(), null);
        this.m_MimeManager.setItemStyle("OwEditPropertiesMimeItem");
        this.m_MimeManager.setIconStyle("OwEditPropertiesMimeIcon");
        this.addView((OwView)this.m_view, 2, null);
        this.m_view.setObjectRef((OwObject)this.getWorkItem(), false);
        this.m_view.setDocument(new OwDocument());
        if (this.m_fAutoOpen) {
            this.previewAttachment();
        }
    }

    @Override
    public void unlock() throws Exception {
        for (int i = 0; i < this.m_worktitems.size(); ++i) {
            ((OwWorkitem)this.m_worktitems.get(i)).setLock(false);
        }
    }

    private OwWorkitem getWorkItem() {
        return (OwWorkitem)this.m_worktitems.get(this.m_iIndex);
    }

    public boolean hasNext() throws Exception {
        return this.m_iIndex < this.m_worktitems.size() - 1;
    }

    public boolean hasPrev() throws Exception {
        return this.m_iIndex > 0;
    }

    public int getCount() {
        return this.m_worktitems.size();
    }

    public void prev(boolean fRemoveCurrent_p) throws Exception {
        if (fRemoveCurrent_p) {
            throw new OwNotSupportedException("OwBPMStandardProcessorDialog.prev(fRemoveCurrent_p==true) not supported.");
        }
        this.m_iIndex = this.hasPrev() ? --this.m_iIndex : this.m_worktitems.size() - 1;
        this.m_view.setObjectRef((OwObject)this.getWorkItem(), false);
        if (this.m_fAutoOpen) {
            this.previewAttachment();
        }
    }

    public void next(boolean fRemoveCurrent_p) throws Exception {
        if (fRemoveCurrent_p) {
            if (this.getCount() == 1) {
                this.closeDialog();
                return;
            }
            ((OwWorkitem)this.m_worktitems.get(this.m_iIndex)).setLock(false);
            this.m_worktitems.remove(this.m_iIndex);
            if (this.m_iIndex >= this.m_worktitems.size()) {
                this.m_iIndex = 0;
            }
        } else {
            this.m_iIndex = this.hasNext() ? ++this.m_iIndex : 0;
        }
        this.m_view.setObjectRef((OwObject)this.getWorkItem(), false);
        if (this.m_fAutoOpen) {
            this.previewAttachment();
        }
    }

    @Override
    public List getWorkItems() {
        return this.m_worktitems;
    }

    public void closeDialog() throws Exception {
        super.closeDialog();
        if (this.m_fAutoOpen && ((OwMainAppContext)this.getContext()).getWindowPositions().getPositionMainWindow()) {
            ((OwMainAppContext)this.getContext()).addFinalScript("\n" + OwMimeManager.createAutoViewerRestoreMainWindowScript((OwMainAppContext)((OwMainAppContext)this.getContext()), (int)1));
        }
        if (null != this.m_refreshCtx) {
            this.m_refreshCtx.onClientRefreshContextUpdate(3, null);
        }
    }

    public void detach() {
        super.detach();
        this.m_MimeManager.detach();
    }

    protected OwBPMStandardProcessorView createProcessorView(OwXMLUtil configNode_p) throws Exception {
        return new OwBPMStandardProcessorView((OwSequenceView)this, configNode_p);
    }

    protected void previewAttachment() {
        try {
            OwXMLUtil m_fPreviewAttachmentName = this.m_configNode.getSubUtil("PreviewAttachmentName");
            if (m_fPreviewAttachmentName == null) {
                if (LOG.isDebugEnabled()) {
                    String msg = "OwBPMStandardProcessorDialog.previewAttachment: No preview attachment name is declared. Can't auto open preview attachment.";
                    LOG.debug((Object)msg);
                }
                return;
            }
            OwProperty owp = this.getWorkItem().getProperty(m_fPreviewAttachmentName.getSafeTextValue("<PreviewAttachmentName>"));
            OwObjectReference owr = null;
            if (owp.getValue() instanceof Object[]) {
                int arrayindex = m_fPreviewAttachmentName.getSafeIntegerAttributeValue("arrayindex", -2);
                Object[] array = (Object[])owp.getValue();
                if (array.length == 0) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"OwBPMStandardProcessorDialog.previewAttachment: Attachment array contains no elements.");
                    }
                    return;
                }
                if (arrayindex < -1 || array.length < arrayindex + 1) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"OwBPMStandardProcessorDialog.previewAttachment: Specified 'arrayindex' is out of bound. Please check configuration file.");
                    }
                    return;
                }
                owr = arrayindex == -1 ? (OwObjectReference)array[array.length - 1] : (OwObjectReference)array[arrayindex];
            } else {
                owr = (OwObjectReference)owp.getValue();
            }
            if (null != owr && OwMimeManager.isObjectDownloadable((OwMainAppContext)((OwMainAppContext)this.getContext()), (OwObjectReference)owr)) {
                OwMimeManager.openObjectPreview((OwMainAppContext)((OwMainAppContext)this.getContext()), (OwObjectReference)owr, null, (int)2, (OwClientRefreshContext)this.m_refreshCtx);
            }
        }
        catch (Exception e) {
            LOG.debug((Object)"Exception occurred on preview attachment.", (Throwable)e);
        }
    }
}

