/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owbpm.plug;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwStandardSequenceDialog;
import com.wewebu.ow.server.ecm.bpm.OwWorkflowDescription;
import com.wewebu.ow.server.ecm.bpm.OwWorkitem;
import com.wewebu.ow.server.ecm.bpm.OwWorkitemRepository;
import com.wewebu.ow.server.exceptions.OwAccessDeniedException;
import com.wewebu.ow.server.plug.owbpm.plug.OwBPMLaunchableWorkflowSelectionDialog;
import com.wewebu.ow.server.role.OwRoleManager;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString1;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.Collection;
import java.util.LinkedList;

public abstract class OwBPMWorkflowLauncher {
    private Collection m_targetObjects;
    private OwMainAppContext m_context;
    private OwWorkitemRepository m_repository;
    private OwXMLUtil m_configNode;

    public OwBPMWorkflowLauncher(OwWorkitemRepository repository_p, Collection targetObjects_p, OwMainAppContext context_p, OwXMLUtil configNode_p) {
        this.m_targetObjects = targetObjects_p;
        this.m_context = context_p;
        this.m_repository = repository_p;
        this.m_configNode = configNode_p;
    }

    public void launch(final OwClientRefreshContext refreshCtx_p) throws Exception {
        Collection workflowDescriptions = this.m_repository.getLaunchableWorkflowDescriptions(this.m_targetObjects);
        LinkedList<OwWorkflowDescription> allowedWorkflowDescriptions = new LinkedList<OwWorkflowDescription>();
        for (Object object : workflowDescriptions) {
            OwWorkflowDescription description = (OwWorkflowDescription)object;
            if (!this.m_context.isAllowed(13, description.getId())) continue;
            allowedWorkflowDescriptions.add(description);
        }
        final OwBPMLaunchableWorkflowSelectionDialog workflowSelectionDialog = new OwBPMLaunchableWorkflowSelectionDialog(allowedWorkflowDescriptions);
        this.m_context.openDialog((OwDialog)workflowSelectionDialog, new OwDialog.OwDialogListener(){

            public void onUpdate(OwEventTarget caller_p, int code_p, Object param_p) throws Exception {
            }

            public void onDialogClose(OwDialog dialogView_p) throws Exception {
                OwWorkflowDescription selection = workflowSelectionDialog.getSelection();
                if (selection != null) {
                    OwBPMWorkflowLauncher.this.dispatchLaunchStepProcessor(selection, refreshCtx_p);
                }
            }
        });
    }

    protected abstract OwStandardSequenceDialog createLaunchProcessorDialog(OwWorkitem var1, OwClientRefreshContext var2) throws Exception;

    protected void dispatchLaunchStepProcessor(OwWorkflowDescription selectedDescription_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        OwRoleManager roleManager = this.m_context.getNetwork().getRoleManager();
        if (!roleManager.isAllowed(13, selectedDescription_p.getId())) {
            OwString1 message = new OwString1("plug.owbpm.err.startWorkflow.accessDenied", "The current user does not have permission to start workflow '%1'.", selectedDescription_p.getName());
            throw new OwAccessDeniedException((OwString)message);
        }
        OwWorkitem launchWorkItem = this.m_repository.createLaunchableItem(selectedDescription_p, this.m_targetObjects);
        OwStandardSequenceDialog processorDialog = this.createLaunchProcessorDialog(launchWorkItem, refreshCtx_p);
        processorDialog.setTitle(this.m_context.localize("owbpm.OwBPMWorkflowLauncher.launchdialogtitle", "Launch:") + selectedDescription_p.getName());
        this.m_context.openDialog((OwDialog)processorDialog, null);
    }

    protected OwXMLUtil getConfigNode() {
        return this.m_configNode;
    }
}

