/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.client.authentication;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.chemistry.opencmis.client.bindings.spi.AbstractAuthenticationProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.cookies.CmisCookieManager;
import org.apache.chemistry.opencmis.commons.impl.Base64;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthCMISAuthenticationProvider
extends AbstractAuthenticationProvider {
    public static final String ALFRESCO_ACCESS_TOKEN_URL = "https://api.alfresco.com/auth/oauth/versions/2/token";
    public static final String ALFRESCO_REFRESH_TOKEN_URL = "https://api.alfresco.com/auth/oauth/versions/2/token";
    public static final String PARAM_ACCESS_TOKEN = "org.apache.chemistry.opencmis.binding.auth.oauth.accessToken";
    private static final long serialVersionUID = 1L;
    private static final String WSSE_NAMESPACE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private static final String WSU_NAMESPACE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    private boolean sendUsernameToken = false;
    private CmisCookieManager cookieManager;
    private Map<String, List<String>> fixedHeaders = new HashMap<String, List<String>>();
    private String clientId;
    private String clientSecret;
    private String redirectUrl;
    private String authCode;
    private String accessTokenUrl;
    private String refreshTokenUrl;
    private HttpClient client;
    private String accessToken;
    private AccessToken accessTokenData;

    public static OAuthCMISAuthenticationProvider alfrescoOAuthProvider(String accessToken) {
        return new OAuthCMISAuthenticationProvider(accessToken);
    }

    public static OAuthCMISAuthenticationProvider alfrescoOAuthProvider(String clientId, String clientSecret, String redirectUrl, String authCode) {
        return new OAuthCMISAuthenticationProvider(clientId, clientSecret, redirectUrl, "https://api.alfresco.com/auth/oauth/versions/2/token", "https://api.alfresco.com/auth/oauth/versions/2/token", authCode);
    }

    public OAuthCMISAuthenticationProvider() {
    }

    public OAuthCMISAuthenticationProvider(String accessToken) {
        this.accessToken = accessToken;
    }

    public OAuthCMISAuthenticationProvider(String clientId, String clientSecret, String redirectUrl, String accessTokenUrl, String refreshTokenUrl, String authCode) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.redirectUrl = redirectUrl;
        this.accessTokenUrl = accessTokenUrl;
        this.refreshTokenUrl = refreshTokenUrl;
        this.authCode = authCode;
        MultiThreadedHttpConnectionManager manager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        params.setMaxTotalConnections(2);
        params.setMaxConnectionsPerHost(HostConfiguration.ANY_HOST_CONFIGURATION, 2);
        this.client = new HttpClient((HttpConnectionManager)manager);
        this.generateAccessToken();
    }

    public AccessToken getAccessTokenData() {
        return this.accessTokenData;
    }

    private void generateAccessToken() {
        block6: {
            PostMethod method = new PostMethod(this.accessTokenUrl);
            NameValuePair[] data = new NameValuePair[]{new NameValuePair("redirect_uri", this.redirectUrl), new NameValuePair("client_id", this.clientId), new NameValuePair("client_secret", this.clientSecret), new NameValuePair("code", this.authCode), new NameValuePair("grant_type", "authorization_code")};
            method.setRequestBody(data);
            try {
                int result = this.client.executeMethod(null, (HttpMethod)method, null);
                if (result == 200) {
                    JSONParser parser = new JSONParser();
                    try {
                        JSONObject json = (JSONObject)parser.parse(method.getResponseBodyAsString());
                        this.accessTokenData = new AccessToken(json);
                        break block6;
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                }
                throw new RuntimeException(method.getStatusText());
            }
            catch (HttpException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void refreshToken() {
        block6: {
            PostMethod method = new PostMethod(this.refreshTokenUrl);
            NameValuePair[] data = new NameValuePair[]{new NameValuePair("refresh_token", this.clientId), new NameValuePair("client_id", this.clientId), new NameValuePair("client_secret", this.clientSecret), new NameValuePair("grant_type", "refresh_token")};
            method.setRequestBody(data);
            try {
                int result = this.client.executeMethod(null, (HttpMethod)method, null);
                if (result == 200) {
                    JSONParser parser = new JSONParser();
                    try {
                        JSONObject json = (JSONObject)parser.parse(method.getResponseBodyAsString());
                        this.accessTokenData = new AccessToken(json);
                        break block6;
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                }
                throw new RuntimeException(method.getStatusText());
            }
            catch (HttpException e) {
                throw new RuntimeException(method.getStatusText());
            }
            catch (IOException e) {
                throw new RuntimeException(method.getStatusText());
            }
        }
    }

    public void setSession(BindingSession session) {
        super.setSession(session);
        if (this.isTrue("org.apache.chemistry.opencmis.binding.cookies")) {
            this.cookieManager = new CmisCookieManager();
        }
    }

    private String getAccessToken() {
        Object accessTokenObject = this.getSession().get(PARAM_ACCESS_TOKEN);
        if (accessTokenObject instanceof String) {
            return (String)accessTokenObject;
        }
        return null;
    }

    public Map<String, List<String>> getHTTPHeaders(String url) {
        Map cookies;
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(this.fixedHeaders);
        if (this.accessToken == null) {
            this.accessToken = this.getAccessToken();
        }
        if (this.accessToken == null) {
            long time = System.currentTimeMillis();
            if (time > this.accessTokenData.getExpiresAt()) {
                this.refreshToken();
            }
            StringBuilder sb = new StringBuilder("Bearer ");
            sb.append(this.accessTokenData.getAccessToken());
            result.put("Authorization", Collections.singletonList(sb.toString()));
        } else {
            StringBuilder sb = new StringBuilder("Bearer ");
            sb.append(this.accessToken);
            result.put("Authorization", Collections.singletonList(sb.toString()));
        }
        if (this.cookieManager != null && !(cookies = this.cookieManager.get(url, result)).isEmpty()) {
            result.putAll(cookies);
        }
        return result.isEmpty() ? null : result;
    }

    public void putResponseHeaders(String url, int statusCode, Map<String, List<String>> headers) {
        if (this.cookieManager != null) {
            this.cookieManager.put(url, headers);
        }
    }

    public Element getSOAPHeaders(Object portObject) {
        if (!this.sendUsernameToken) {
            return null;
        }
        String user = this.getUser();
        String password = this.getPassword();
        if (user == null) {
            return null;
        }
        if (password == null) {
            password = "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        long created = System.currentTimeMillis();
        long expires = created + 86400000L;
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element wsseSecurityElement = document.createElementNS(WSSE_NAMESPACE, "Security");
            Element wsuTimestampElement = document.createElementNS(WSU_NAMESPACE, "Timestamp");
            wsseSecurityElement.appendChild(wsuTimestampElement);
            Element tsCreatedElement = document.createElementNS(WSU_NAMESPACE, "Created");
            tsCreatedElement.appendChild(document.createTextNode(sdf.format(created)));
            wsuTimestampElement.appendChild(tsCreatedElement);
            Element tsExpiresElement = document.createElementNS(WSU_NAMESPACE, "Expires");
            tsExpiresElement.appendChild(document.createTextNode(sdf.format(expires)));
            wsuTimestampElement.appendChild(tsExpiresElement);
            Element usernameTokenElement = document.createElementNS(WSSE_NAMESPACE, "UsernameToken");
            wsseSecurityElement.appendChild(usernameTokenElement);
            Element usernameElement = document.createElementNS(WSSE_NAMESPACE, "Username");
            usernameElement.appendChild(document.createTextNode(user));
            usernameTokenElement.appendChild(usernameElement);
            Element passwordElement = document.createElementNS(WSSE_NAMESPACE, "Password");
            passwordElement.appendChild(document.createTextNode(password));
            passwordElement.setAttribute("Type", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
            usernameTokenElement.appendChild(passwordElement);
            Element createdElement = document.createElementNS(WSU_NAMESPACE, "Created");
            createdElement.appendChild(document.createTextNode(sdf.format(created)));
            usernameTokenElement.appendChild(createdElement);
            return wsseSecurityElement;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Map<String, List<String>> getFixedHeaders() {
        return this.fixedHeaders;
    }

    protected List<String> createBasicAuthHeaderValue(String username, String password) {
        if (password == null) {
            password = "";
        }
        try {
            return Collections.singletonList("Basic " + Base64.encodeBytes((byte[])(username + ":" + password).getBytes("ISO-8859-1")));
        }
        catch (UnsupportedEncodingException e) {
            return Collections.emptyList();
        }
    }

    protected boolean isTrue(String parameterName) {
        Object value = this.getSession().get(parameterName);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return false;
    }

    public static class AccessToken {
        private String accessToken;
        private String tokenType;
        private Long expiresAt;
        private String refreshToken;
        private String scope;

        public AccessToken(JSONObject json) {
            this.accessToken = (String)json.get((Object)"access_token");
            this.tokenType = (String)json.get((Object)"token_type");
            Long expiresIn = (Long)json.get((Object)"expires_in");
            this.expiresAt = System.currentTimeMillis() + expiresIn * 60L * 60L * 1000L;
            this.refreshToken = (String)json.get((Object)"refresh_token");
            this.scope = (String)json.get((Object)"scope");
        }

        public AccessToken(String accessToken, String tokenType, Long expiresIn, String refreshToken, String scope) {
            this.accessToken = accessToken;
            this.tokenType = tokenType;
            Long expires = expiresIn;
            this.expiresAt = System.currentTimeMillis() + expires * 60L * 60L * 1000L;
            this.refreshToken = refreshToken;
            this.scope = scope;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public String getTokenType() {
            return this.tokenType;
        }

        public Long getExpiresAt() {
            return this.expiresAt;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public String getScope() {
            return this.scope;
        }

        public String toString() {
            return "AccessToken [" + (this.accessToken != null ? "accessToken=" + this.accessToken + ", " : "") + (this.tokenType != null ? "tokenType=" + this.tokenType + ", " : "") + (this.expiresAt != null ? "expiresAt=" + this.expiresAt + ", " : "") + (this.refreshToken != null ? "refreshToken=" + this.refreshToken + ", " : "") + (this.scope != null ? "scope=" + this.scope : "") + "]";
        }
    }
}

