/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.client.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.datatype.DatatypeFactory;
import org.alfresco.cmis.client.impl.AlfrescoDocumentImpl;
import org.alfresco.cmis.client.impl.AlfrescoFolderImpl;
import org.alfresco.cmis.client.impl.AlfrescoUtils;
import org.alfresco.cmis.client.type.AlfrescoDocumentType;
import org.alfresco.cmis.client.type.AlfrescoFolderType;
import org.alfresco.cmis.client.type.AlfrescoPolicyType;
import org.alfresco.cmis.client.type.AlfrescoRelationshipType;
import org.alfresco.cmis.client.type.AlfrescoType;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.PolicyImpl;
import org.apache.chemistry.opencmis.client.runtime.RelationshipImpl;
import org.apache.chemistry.opencmis.client.runtime.SessionImpl;
import org.apache.chemistry.opencmis.client.runtime.repository.ObjectFactoryImpl;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.FolderTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PolicyTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.RelationshipTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlfrescoObjectFactoryImpl
extends ObjectFactoryImpl {
    private static final long serialVersionUID = 1L;
    private Session session = null;

    public ObjectType convertTypeDefinition(TypeDefinition typeDefinition) {
        AlfrescoType ret = null;
        if (typeDefinition instanceof DocumentTypeDefinition) {
            ret = new AlfrescoDocumentType(this.session, (DocumentTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof FolderTypeDefinition) {
            ret = new AlfrescoFolderType(this.session, (FolderTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof RelationshipTypeDefinition) {
            ret = new AlfrescoRelationshipType(this.session, (RelationshipTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof PolicyTypeDefinition) {
            ret = new AlfrescoPolicyType(this.session, (PolicyTypeDefinition)typeDefinition);
        } else {
            throw new CmisRuntimeException("Unknown base type!");
        }
        return ret;
    }

    public void initialize(Session session, Map<String, String> parameters) {
        super.initialize(session, parameters);
        this.session = session;
    }

    public Properties convertProperties(Map<String, ?> properties, ObjectType type, Set<Updatability> updatabilityFilter) {
        if (properties == null) {
            return null;
        }
        Object typeId = properties.get("cmis:objectTypeId");
        String typeIdStr = null;
        if (typeId instanceof String) {
            typeIdStr = typeId.toString();
        } else if (typeId instanceof Property) {
            Object propValue = ((Property)typeId).getFirstValue();
            String string = typeIdStr = propValue == null ? null : propValue.toString();
        }
        if (typeIdStr == null) {
            throw new IllegalArgumentException("Type property must be set!");
        }
        ObjectType objectType = null;
        ArrayList<ObjectType> aspectTypes = new ArrayList<ObjectType>();
        if (typeIdStr.indexOf(44) == -1) {
            objectType = this.session.getTypeDefinition(typeIdStr);
        } else {
            String[] typeIds = typeIdStr.split(",");
            objectType = this.session.getTypeDefinition(typeIds[0].trim());
            for (int i = 1; i < typeIds.length; ++i) {
                aspectTypes.add(this.session.getTypeDefinition(typeIds[i].trim()));
            }
        }
        HashMap<String, String> typeProperties = new HashMap<String, String>();
        HashMap aspectProperties = new HashMap();
        HashMap<String, PropertyDefinition> aspectPropertyDefinition = new HashMap<String, PropertyDefinition>();
        for (Map.Entry<String, ?> property : properties.entrySet()) {
            if (property == null || property.getKey() == null) continue;
            String id = property.getKey();
            Object value = property.getValue();
            if ("cmis:objectTypeId".equals(id)) {
                if (type != null) continue;
                typeProperties.put(id, objectType.getId());
                continue;
            }
            if (objectType.getPropertyDefinitions().containsKey(id)) {
                typeProperties.put(id, (String)value);
                continue;
            }
            aspectProperties.put(id, value);
            for (ObjectType aspectType : aspectTypes) {
                PropertyDefinition propDef;
                if (aspectType.getPropertyDefinitions() == null || (propDef = (PropertyDefinition)aspectType.getPropertyDefinitions().get(id)) == null) continue;
                aspectPropertyDefinition.put(id, propDef);
                break;
            }
            if (aspectPropertyDefinition.containsKey(id)) continue;
            throw new IllegalArgumentException("Property '" + id + "' is neither an object type property nor an aspect property!");
        }
        Properties result = super.convertProperties(typeProperties, type, updatabilityFilter);
        ArrayList<CmisExtensionElement> alfrescoExtensionList = new ArrayList<CmisExtensionElement>();
        for (ObjectType aspectType : aspectTypes) {
            alfrescoExtensionList.add(AlfrescoUtils.createAspectsToAddExtension(aspectType));
        }
        if (!aspectProperties.isEmpty()) {
            ArrayList<CmisExtensionElement> propertrtyExtensionList = new ArrayList<CmisExtensionElement>();
            for (Map.Entry property : aspectProperties.entrySet()) {
                PropertyDefinition propDef = (PropertyDefinition)aspectPropertyDefinition.get(property.getKey());
                if (propDef == null) {
                    throw new IllegalArgumentException("Unknown aspect property: " + (String)property.getKey());
                }
                CmisExtensionElement element = AlfrescoUtils.createAspectPropertyExtension(propDef, property.getValue());
                if (element == null) continue;
                propertrtyExtensionList.add(element);
            }
            alfrescoExtensionList.add(AlfrescoUtils.createAspectPropertiesExtension(propertrtyExtensionList));
        }
        if (!alfrescoExtensionList.isEmpty()) {
            result.setExtensions(Collections.singletonList(AlfrescoUtils.createSetAspectsExtension(alfrescoExtensionList)));
        }
        return result;
    }

    public Map<String, Property<?>> convertProperties(ObjectType objectType, Properties properties) {
        Map result = super.convertProperties(objectType, properties);
        List<CmisExtensionElement> alfrescoExtensions = AlfrescoUtils.findAlfrescoExtensions(properties.getExtensions());
        if (alfrescoExtensions == null) {
            return result;
        }
        Collection<ObjectType> aspectTypes = AlfrescoUtils.getAspectTypes(this.session, alfrescoExtensions);
        for (CmisExtensionElement extension : alfrescoExtensions) {
            if (!extension.getName().equals("properties")) continue;
            for (CmisExtensionElement property : extension.getChildren()) {
                String id = (String)property.getAttributes().get("propertyDefinitionId");
                ObjectType aspectType = AlfrescoUtils.findAspect(aspectTypes, id);
                if (aspectType == null) {
                    throw new IllegalArgumentException("Unknown aspect property: " + id);
                }
                PropertyDefinition propDef = (PropertyDefinition)aspectType.getPropertyDefinitions().get(id);
                ArrayList<Object> values = new ArrayList<Object>();
                DatatypeFactory df = null;
                try {
                    block10: for (CmisExtensionElement propertyValues : property.getChildren()) {
                        switch (propDef.getPropertyType()) {
                            case BOOLEAN: {
                                values.add(Boolean.parseBoolean(propertyValues.getValue()));
                                continue block10;
                            }
                            case DATETIME: {
                                if (df == null) {
                                    df = DatatypeFactory.newInstance();
                                }
                                values.add(df.newXMLGregorianCalendar(propertyValues.getValue()).toGregorianCalendar());
                                continue block10;
                            }
                            case DECIMAL: {
                                values.add(new BigDecimal(propertyValues.getValue()));
                                continue block10;
                            }
                            case INTEGER: {
                                values.add(new BigInteger(propertyValues.getValue()));
                                continue block10;
                            }
                        }
                        values.add(propertyValues.getValue());
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Aspect conversation exception: " + e.getMessage(), e);
                }
                result.put(id, this.createProperty(propDef, values));
            }
        }
        return result;
    }

    public CmisObject convertObject(ObjectData objectData, OperationContext context) {
        if (objectData == null) {
            throw new IllegalArgumentException("Object data is null!");
        }
        ObjectType type = this.getTypeFromObjectData(objectData);
        switch (objectData.getBaseTypeId()) {
            case CMIS_DOCUMENT: {
                return new AlfrescoDocumentImpl((SessionImpl)this.session, type, objectData, context);
            }
            case CMIS_FOLDER: {
                return new AlfrescoFolderImpl((SessionImpl)this.session, type, objectData, context);
            }
            case CMIS_POLICY: {
                return new PolicyImpl((SessionImpl)this.session, type, objectData, context);
            }
            case CMIS_RELATIONSHIP: {
                return new RelationshipImpl((SessionImpl)this.session, type, objectData, context);
            }
        }
        throw new CmisRuntimeException("unsupported type: " + objectData.getBaseTypeId());
    }
}

