/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprErrorTable;
import com.wewebu.expression.language.OwExprEvaluationException;
import com.wewebu.expression.language.OwExprExpression;
import com.wewebu.expression.language.OwExprExpressionType;
import com.wewebu.expression.language.OwExprFunctionSymbol;
import com.wewebu.expression.language.OwExprPrimaryPrefix;
import com.wewebu.expression.language.OwExprPropertySymbol;
import com.wewebu.expression.language.OwExprScope;
import com.wewebu.expression.language.OwExprSymbolScope;
import com.wewebu.expression.language.OwExprSymbolTable;
import com.wewebu.expression.language.OwExprTypeMissmatchException;
import com.wewebu.expression.language.OwExprValue;
import java.util.List;

public class OwExprArgumentsSuffix
extends OwExprExpression
implements OwExprPrimaryPrefix {
    private OwExprFunctionSymbol m_functionSymbol;
    private OwExprPrimaryPrefix m_prefix;
    private List m_argumentsExpressions;

    public OwExprArgumentsSuffix(OwExprSymbolTable symbolTable_p, OwExprErrorTable errorTable_p, OwExprPrimaryPrefix prefix_p, List argumentsExpressions_p) {
        super(symbolTable_p, errorTable_p);
        this.m_argumentsExpressions = argumentsExpressions_p;
        this.m_prefix = prefix_p;
    }

    @Override
    public OwExprValue evaluate(OwExprScope scope_p) throws OwExprEvaluationException {
        OwExprValue[] argumentValues = new OwExprValue[this.m_argumentsExpressions.size()];
        int i = 0;
        for (OwExprExpression argument : this.m_argumentsExpressions) {
            argumentValues[i] = argument.evaluate(scope_p);
            ++i;
        }
        return this.m_functionSymbol.getValue(scope_p, argumentValues);
    }

    @Override
    public OwExprExpressionType type() throws OwExprTypeMissmatchException {
        if (!this.m_typeError) {
            OwExprExpressionType[] argumentTypes = new OwExprExpressionType[this.m_argumentsExpressions.size()];
            int i = 0;
            for (OwExprExpression argument : this.m_argumentsExpressions) {
                argumentTypes[i] = argument.type();
                ++i;
            }
            this.m_functionSymbol.setArgumentTypes(argumentTypes);
            return this.m_functionSymbol.getType();
        }
        return OwExprExpressionType.NOTYPE;
    }

    @Override
    public OwExprExpression expression() {
        if (!this.m_typeError) {
            try {
                if (this.m_functionSymbol == null) {
                    this.m_functionSymbol = this.m_prefix.regressToFunction();
                }
                this.initType();
            }
            catch (OwExprTypeMissmatchException e) {
                this.m_errorTable.add(e);
                this.m_typeError = true;
            }
        }
        return this;
    }

    @Override
    public OwExprFunctionSymbol regressToFunction() throws OwExprTypeMissmatchException {
        throw new OwExprTypeMissmatchException("Invalid function on function call!");
    }

    @Override
    public OwExprPropertySymbol regressToPorperty() throws OwExprTypeMissmatchException {
        throw new OwExprTypeMissmatchException("Invalid function call !");
    }

    @Override
    public OwExprSymbolScope regressToScope() throws OwExprTypeMissmatchException {
        if (this.m_prefix != null) {
            this.m_functionSymbol = this.m_prefix.regressToFunction();
            OwExprSymbolScope symbolScope = new OwExprSymbolScope(true, this.m_functionSymbol, this.expression());
            return symbolScope;
        }
        throw new OwExprTypeMissmatchException("Invalid function call!");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        if (this.m_argumentsExpressions.size() > 0) {
            sb.append(this.m_argumentsExpressions.get(0).toString());
        }
        for (int i = 1; i < this.m_argumentsExpressions.size(); ++i) {
            sb.append(",");
            sb.append(this.m_argumentsExpressions.get(i));
        }
        sb.append(")");
        return this.m_prefix.toString() + sb.toString();
    }
}

