/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprErrorTable;
import com.wewebu.expression.language.OwExprEvaluationException;
import com.wewebu.expression.language.OwExprExpressionType;
import com.wewebu.expression.language.OwExprExternalScope;
import com.wewebu.expression.language.OwExprScope;
import com.wewebu.expression.language.OwExprSymbol;
import com.wewebu.expression.language.OwExprSymbolTable;
import com.wewebu.expression.language.OwExprSystem;
import com.wewebu.expression.language.OwExprTypeMissmatchException;
import com.wewebu.expression.language.OwExprValue;

public abstract class OwExprExpression {
    private static final OwExprExternalScope[] NO_EX_SCOPES = new OwExprExternalScope[0];
    protected OwExprSymbolTable m_symbolTable;
    protected OwExprErrorTable m_errorTable;
    protected boolean m_typeError = false;

    public OwExprExpression(OwExprSymbolTable symbolTable_p, OwExprErrorTable errorTable_p) {
        this.m_symbolTable = symbolTable_p;
        this.m_errorTable = errorTable_p;
    }

    protected final void initType() {
        try {
            this.type();
        }
        catch (OwExprTypeMissmatchException e) {
            this.m_errorTable.add(e);
            this.m_typeError = true;
        }
    }

    public OwExprValue evaluate() throws OwExprEvaluationException {
        return this.evaluate(NO_EX_SCOPES);
    }

    public OwExprValue evaluate(OwExprExternalScope[] externalScopes_p) throws OwExprEvaluationException {
        OwExprSystem system = new OwExprSystem();
        for (int i = 0; i < externalScopes_p.length; ++i) {
            system.addScope(externalScopes_p[i]);
        }
        return this.evaluate(system);
    }

    public abstract OwExprValue evaluate(OwExprScope var1) throws OwExprEvaluationException;

    public abstract OwExprExpressionType type() throws OwExprTypeMissmatchException;

    public final OwExprSymbolTable getSymbolTable() {
        return this.m_symbolTable;
    }

    public final boolean symbolsVisibleInScopes(OwExprExternalScope[] externalScopes_p) throws OwExprEvaluationException {
        OwExprSystem system = new OwExprSystem();
        for (int i = 0; i < externalScopes_p.length; ++i) {
            system.addScope(externalScopes_p[i]);
        }
        return this.m_symbolTable.matchesScope(system);
    }

    public final OwExprErrorTable getErrorTable() {
        return this.m_errorTable;
    }

    public final boolean hasErrors() {
        return this.m_errorTable.hasErrors();
    }

    public final int errCount() {
        return this.m_errorTable.errCount();
    }

    public final OwExprSymbol getSymbol(String symbolName_p) {
        return this.m_symbolTable.getSymbol(symbolName_p);
    }
}

