/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprEvaluationException;
import com.wewebu.expression.language.OwExprExpressionType;
import com.wewebu.expression.language.OwExprFunction;
import com.wewebu.expression.language.OwExprProperty;
import com.wewebu.expression.language.OwExprScope;
import com.wewebu.expression.language.OwExprScopeValue;
import com.wewebu.expression.language.OwExprScopedProperty;
import com.wewebu.expression.language.OwExprType;
import com.wewebu.expression.language.OwExprValue;
import java.util.HashMap;
import java.util.Map;

public class OwExprExternalScope
implements OwExprScope {
    private Map m_functions = new HashMap();
    private Map m_properties = new HashMap();
    private String m_name;

    public OwExprExternalScope(String name_p) {
        this.m_name = name_p;
    }

    public final void addScope(final OwExprExternalScope externalScope_p) {
        this.m_properties.put(externalScope_p.getName(), new OwExprScopedProperty(){

            @Override
            public OwExprType type() throws OwExprEvaluationException {
                return OwExprType.SCOPE;
            }

            @Override
            public OwExprValue value() throws OwExprEvaluationException {
                return new OwExprScopeValue(externalScope_p);
            }

            @Override
            public Class<?> javaType() throws OwExprEvaluationException {
                return OwExprExternalScope.class;
            }
        });
    }

    @Override
    public final OwExprFunction function(String functionName_p, OwExprExpressionType[] argunmentTypes_p) throws OwExprEvaluationException {
        OwExprFunction function = this.prelevateFunction(functionName_p, argunmentTypes_p);
        if (function == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("(");
            if (argunmentTypes_p.length > 0) {
                sb.append(argunmentTypes_p[0].toString());
            }
            for (int i = 1; i < argunmentTypes_p.length; ++i) {
                sb.append(",");
                sb.append(argunmentTypes_p[i].toString());
            }
            sb.append(")");
            throw new OwExprEvaluationException("No such function : " + functionName_p + sb.toString());
        }
        return function;
    }

    @Override
    public final OwExprProperty property(String propertyName_p) throws OwExprEvaluationException {
        OwExprProperty property = this.prelevateProperty(propertyName_p);
        if (property == null) {
            throw new OwExprEvaluationException("No such property : " + propertyName_p);
        }
        return property;
    }

    protected OwExprFunction prelevateFunction(String functionName_p, OwExprExpressionType[] argumentTypes_p) throws OwExprEvaluationException {
        return null;
    }

    protected OwExprProperty prelevateProperty(String propertyName_p) throws OwExprEvaluationException {
        return (OwExprProperty)this.m_properties.get(propertyName_p);
    }

    public final String getName() {
        return this.m_name;
    }

    public String toString() {
        return "$" + this.m_name;
    }

    @Override
    public OwExprProperty at(int index_p) throws OwExprEvaluationException {
        throw new OwExprEvaluationException("Array access on non array scope!");
    }

    @Override
    public int length() throws OwExprEvaluationException {
        return 0;
    }

    @Override
    public boolean hasProperty(String propertyName_p) throws OwExprEvaluationException {
        return this.m_properties.containsKey(propertyName_p);
    }
}

