/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprConstantSymbol;
import com.wewebu.expression.language.OwExprErrorTable;
import com.wewebu.expression.language.OwExprEvaluationException;
import com.wewebu.expression.language.OwExprExpression;
import com.wewebu.expression.language.OwExprExpressionType;
import com.wewebu.expression.language.OwExprFunctionSymbol;
import com.wewebu.expression.language.OwExprPrimaryPrefix;
import com.wewebu.expression.language.OwExprPropertySymbol;
import com.wewebu.expression.language.OwExprScope;
import com.wewebu.expression.language.OwExprSymbolScope;
import com.wewebu.expression.language.OwExprSymbolTable;
import com.wewebu.expression.language.OwExprType;
import com.wewebu.expression.language.OwExprTypeMissmatchException;
import com.wewebu.expression.language.OwExprValue;

public abstract class OwExprLiteral
extends OwExprExpression
implements OwExprPrimaryPrefix {
    protected OwExprConstantSymbol m_symbol;
    private OwExprValue m_value;

    protected static final OwExprConstantSymbol symbolInstance(String image_p, OwExprSymbolTable symbolTable_p, OwExprErrorTable errorTable_p) {
        try {
            return (OwExprConstantSymbol)symbolTable_p.getSymbol(image_p);
        }
        catch (ClassCastException e) {
            errorTable_p.add(new OwExprTypeMissmatchException("Imvalid symbol : " + image_p, e));
            return null;
        }
    }

    public OwExprLiteral(String symbolName_p, OwExprValue value_p, OwExprType symbolType_p, OwExprSymbolTable symbolTable_p, OwExprErrorTable errorTable_p) {
        super(symbolTable_p, errorTable_p);
        this.m_value = value_p;
        try {
            this.m_symbol = symbolTable_p.addConstantSymbol(this, symbolName_p, symbolType_p);
        }
        catch (OwExprTypeMissmatchException e) {
            errorTable_p.add(e);
        }
    }

    @Override
    public final OwExprExpressionType type() throws OwExprTypeMissmatchException {
        return this.m_symbol.getType();
    }

    public final OwExprValue getValue() {
        return this.m_value;
    }

    @Override
    public final OwExprValue evaluate(OwExprScope scope_p) throws OwExprEvaluationException {
        return this.m_value;
    }

    @Override
    public final OwExprPropertySymbol regressToPorperty() throws OwExprTypeMissmatchException {
        throw new OwExprTypeMissmatchException("Invalid property access on literal " + this);
    }

    @Override
    public final OwExprFunctionSymbol regressToFunction() throws OwExprTypeMissmatchException {
        throw new OwExprTypeMissmatchException("Invalid function call on literal " + this);
    }

    @Override
    public OwExprSymbolScope regressToScope() throws OwExprTypeMissmatchException {
        return new OwExprSymbolScope(true, this.m_symbol, this);
    }

    @Override
    public final OwExprExpression expression() {
        return this;
    }

    public String toString() {
        return this.m_symbol.getName();
    }
}

