/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprBinaryConversionTable;
import com.wewebu.expression.language.OwExprBinaryOperator;
import com.wewebu.expression.language.OwExprBooleanValue;
import com.wewebu.expression.language.OwExprDateValue;
import com.wewebu.expression.language.OwExprEvaluationException;
import com.wewebu.expression.language.OwExprNumericValue;
import com.wewebu.expression.language.OwExprStringValue;
import com.wewebu.expression.language.OwExprTime;
import com.wewebu.expression.language.OwExprTimeValue;
import com.wewebu.expression.language.OwExprType;
import com.wewebu.expression.language.OwExprValue;
import java.util.Calendar;

public class OwExprPlusOperator
extends OwExprBinaryOperator {
    private static final OwExprBinaryConversionTable CONVERSION_TABLE = new OwExprBinaryConversionTable();
    public static final OwExprPlusOperator INSTANCE;

    private OwExprPlusOperator(OwExprBinaryConversionTable conversionTable_p) {
        super("+", conversionTable_p);
    }

    @Override
    public OwExprValue evaluate(OwExprNumericValue v1_p, OwExprNumericValue v2_p) throws OwExprEvaluationException {
        return v1_p.add(v2_p);
    }

    @Override
    public OwExprValue evaluate(OwExprNumericValue v1_p, OwExprStringValue v2_p) throws OwExprEvaluationException {
        return new OwExprStringValue(v1_p.toString() + v2_p.getString());
    }

    @Override
    public OwExprValue evaluate(OwExprStringValue v1_p, OwExprNumericValue v2_p) throws OwExprEvaluationException {
        return new OwExprStringValue(v1_p.getString() + v2_p.toString());
    }

    @Override
    public OwExprValue evaluate(OwExprStringValue v1_p, OwExprStringValue v2_p) throws OwExprEvaluationException {
        return new OwExprStringValue(v1_p.getString() + v2_p.getString());
    }

    @Override
    public OwExprValue evaluate(OwExprDateValue v1_p, OwExprTimeValue v2_p) throws OwExprEvaluationException {
        Calendar calendar = v1_p.getCalendar();
        OwExprTime time = v2_p.getTime();
        Calendar value = time.addTo(calendar);
        OwExprDateValue dateValue = new OwExprDateValue(value);
        return dateValue;
    }

    @Override
    public OwExprValue evaluate(OwExprTimeValue v1_p, OwExprDateValue v2_p) throws OwExprEvaluationException {
        Calendar calendar = v2_p.getCalendar();
        OwExprTime time = v1_p.getTime();
        Calendar value = time.addTo(calendar);
        OwExprDateValue dateValue = new OwExprDateValue(value);
        return dateValue;
    }

    @Override
    public OwExprValue evaluate(OwExprTimeValue v1_p, OwExprTimeValue v2_p) throws OwExprEvaluationException {
        OwExprTime t1 = v1_p.getTime();
        OwExprTime t2 = v2_p.getTime();
        OwExprTime time = t1.add(t2);
        return new OwExprTimeValue(time);
    }

    @Override
    public OwExprValue evaluate(OwExprStringValue v1_p, OwExprBooleanValue v2_p) throws OwExprEvaluationException {
        return new OwExprStringValue(v1_p.getString() + v2_p.getBoolean());
    }

    @Override
    public OwExprValue evaluate(OwExprBooleanValue v1_p, OwExprStringValue v2_p) throws OwExprEvaluationException {
        return new OwExprStringValue(v1_p.getBoolean() + v2_p.getString());
    }

    @Override
    public OwExprValue evaluate(OwExprStringValue v1_p, OwExprDateValue v2_p) throws OwExprEvaluationException {
        return new OwExprStringValue(v1_p.getString() + v2_p.toString());
    }

    @Override
    public OwExprValue evaluate(OwExprDateValue v1_p, OwExprStringValue v2_p) throws OwExprEvaluationException {
        return new OwExprStringValue(v1_p.toString() + v2_p.getString());
    }

    @Override
    public OwExprValue evaluate(OwExprStringValue v1_p, OwExprTimeValue v2_p) throws OwExprEvaluationException {
        return new OwExprStringValue(v1_p.getString() + v2_p.toString());
    }

    @Override
    public OwExprValue evaluate(OwExprTimeValue v1_p, OwExprStringValue v2_p) throws OwExprEvaluationException {
        return new OwExprStringValue(v1_p.toString() + v2_p.getString());
    }

    static {
        CONVERSION_TABLE.add(OwExprType.STRING, new OwExprType[]{OwExprType.STRING, OwExprType.NUMERIC, OwExprType.TIME, OwExprType.DATE, OwExprType.BOOLEAN}, OwExprType.STRING);
        CONVERSION_TABLE.add(new OwExprType[]{OwExprType.NUMERIC, OwExprType.TIME, OwExprType.DATE, OwExprType.BOOLEAN}, OwExprType.STRING, OwExprType.STRING);
        CONVERSION_TABLE.add(OwExprType.NUMERIC, OwExprType.NUMERIC, OwExprType.NUMERIC);
        CONVERSION_TABLE.add(OwExprType.TIME, OwExprType.TIME, OwExprType.TIME);
        CONVERSION_TABLE.add(OwExprType.TIME, OwExprType.DATE, OwExprType.DATE);
        CONVERSION_TABLE.add(OwExprType.DATE, OwExprType.TIME, OwExprType.DATE);
        INSTANCE = new OwExprPlusOperator(CONVERSION_TABLE);
    }
}

