/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprEvaluationException;
import com.wewebu.expression.language.OwExprExpressionType;
import com.wewebu.expression.language.OwExprFunction;
import com.wewebu.expression.language.OwExprProperty;
import com.wewebu.expression.language.OwExprScope;
import com.wewebu.expression.language.OwExprScopedProperty;
import com.wewebu.expression.language.OwExprType;
import com.wewebu.expression.language.OwExprValue;
import java.lang.reflect.Method;

public class OwExprReflectiveProperty
implements OwExprProperty {
    private Object m_javaObject;
    private Method m_propertyMethod;
    private String m_name;

    public OwExprReflectiveProperty(String name_p, Object javaObject_p, Method propertyMethod_p) {
        this.m_javaObject = javaObject_p;
        this.m_propertyMethod = propertyMethod_p;
        this.m_name = name_p;
    }

    @Override
    public OwExprType type() throws OwExprEvaluationException {
        return OwExprType.fromJavaType(this.m_propertyMethod.getReturnType());
    }

    private final Object javaValue() throws OwExprEvaluationException {
        try {
            Object javaValue = this.m_propertyMethod.invoke(this.m_javaObject, new Object[0]);
            return javaValue;
        }
        catch (Exception e) {
            throw new OwExprEvaluationException(e);
        }
    }

    @Override
    public final OwExprValue value() throws OwExprEvaluationException {
        return OwExprValue.fromJavaValue(this.javaValue(), this.javaType());
    }

    private OwExprScope valueScope() throws OwExprEvaluationException {
        return this.value();
    }

    @Override
    public final OwExprFunction function(String functionName_p, OwExprExpressionType[] argunmentTypes_p) throws OwExprEvaluationException {
        return this.valueScope().function(functionName_p, argunmentTypes_p);
    }

    @Override
    public OwExprProperty property(String propertyName_p) throws OwExprEvaluationException {
        return this.valueScope().property(propertyName_p);
    }

    public OwExprScope solveScope(String name_p) throws OwExprEvaluationException {
        return this.valueScope().property(name_p);
    }

    @Override
    public OwExprProperty at(int index_p) throws OwExprEvaluationException {
        Object javaValue = this.javaValue();
        if (javaValue.getClass().isArray()) {
            Object[] javaArray = (Object[])javaValue;
            if (javaArray.length <= index_p) {
                throw new OwExprEvaluationException("Index out of bounds : " + index_p + " for property " + this.m_name);
            }
            final Object javaIndexedObject = javaArray[index_p];
            final Class<?> javaClass = javaIndexedObject == null ? null : javaIndexedObject.getClass();
            final OwExprValue value = OwExprValue.fromJavaValue(javaIndexedObject, javaClass);
            OwExprScopedProperty valueScope = new OwExprScopedProperty(){

                @Override
                public OwExprType type() throws OwExprEvaluationException {
                    return OwExprType.fromJavaType(javaIndexedObject.getClass());
                }

                @Override
                public OwExprValue value() throws OwExprEvaluationException {
                    return value;
                }

                @Override
                public Class<?> javaType() throws OwExprEvaluationException {
                    return javaClass;
                }
            };
            return valueScope;
        }
        throw new OwExprEvaluationException("Array access on non array scope!");
    }

    @Override
    public int length() throws OwExprEvaluationException {
        Object javaValue = this.javaValue();
        if (javaValue.getClass().isArray()) {
            Object[] javaArray = (Object[])javaValue;
            return javaArray.length;
        }
        return 0;
    }

    @Override
    public boolean hasProperty(String propertyName_p) throws OwExprEvaluationException {
        return this.value().hasProperty(propertyName_p);
    }

    @Override
    public Class<?> javaType() throws OwExprEvaluationException {
        Object v = this.javaValue();
        return v == null ? null : v.getClass();
    }
}

