/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprEvaluationException;
import com.wewebu.expression.language.OwExprExpressionType;
import com.wewebu.expression.language.OwExprFunctionSymbol;
import com.wewebu.expression.language.OwExprPropertySymbol;
import com.wewebu.expression.language.OwExprScope;
import com.wewebu.expression.language.OwExprSymbolTable;
import com.wewebu.expression.language.OwExprType;
import com.wewebu.expression.language.OwExprTypeMissmatchException;

public abstract class OwExprSymbol {
    protected OwExprSymbol m_parent;
    private String m_name;
    private OwExprExpressionType m_symbolExpressionType;
    private OwExprSymbolTable m_symbolTable = new OwExprSymbolTable();

    public OwExprSymbol(OwExprSymbol parent_p, String name_p, OwExprType type_p) {
        this(parent_p, name_p, new OwExprType[]{type_p});
    }

    public OwExprSymbol(OwExprSymbol parent_p, String name_p, OwExprType[] types_p) {
        this.m_name = name_p;
        this.m_symbolExpressionType = new OwExprExpressionType(types_p);
        this.m_parent = parent_p;
    }

    public OwExprSymbol(OwExprSymbol parent_p, String name_p, OwExprExpressionType type_p) {
        this.m_name = name_p;
        this.m_symbolExpressionType = type_p;
    }

    public final OwExprPropertySymbol addPropertySymbol(String name_p, OwExprType[] types_p) throws OwExprTypeMissmatchException {
        return this.m_symbolTable.addPropertySymbol(this, name_p, types_p);
    }

    public final OwExprSymbol addAnonymousSymbol(String name_p, OwExprExpressionType type_p) throws OwExprTypeMissmatchException {
        return this.m_symbolTable.addAnonymousSymbol(this, name_p, type_p);
    }

    public final OwExprFunctionSymbol addFunctionSymbol(String name_p, OwExprType[] types_p) throws OwExprTypeMissmatchException {
        return this.m_symbolTable.addFunctionSymbol(this, name_p, types_p);
    }

    public final String issueRuntimeSymbolName() {
        return this.m_symbolTable.issueRuntimeSymbolName();
    }

    public final String getName() {
        return this.m_name;
    }

    public final OwExprExpressionType getType() {
        return this.m_symbolExpressionType;
    }

    public final OwExprSymbol getSymbol(String name_p) {
        return this.m_symbolTable.getSymbol(name_p);
    }

    public final OwExprSymbolTable getSymbolTable() {
        return this.m_symbolTable;
    }

    protected void toPrettyPrintString(StringBuffer sb_p, StringBuffer tabs_p) {
        sb_p.append(this.m_name);
        sb_p.append(":");
        sb_p.append(this.m_symbolExpressionType.toString());
        sb_p.append("\n");
        StringBuffer newTabs = new StringBuffer();
        newTabs.append(tabs_p);
        newTabs.append("\t");
        this.m_symbolTable.toPrettyPrintString(sb_p, newTabs);
    }

    public String getSymbolFQN() {
        String fqn = this.m_parent != null ? this.m_parent.getSymbolFQN() + "." + this.getName() : this.getName();
        return fqn;
    }

    public abstract boolean matches(OwExprScope var1) throws OwExprEvaluationException;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.toPrettyPrintString(sb, new StringBuffer());
        return sb.toString();
    }
}

