/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import java.util.Calendar;
import java.util.TimeZone;

public class OwExprTime
implements Comparable {
    public static final double SECONDS_IN_MINUTE = 60.0;
    public static final double SECONDS_IN_HOUR = 3600.0;
    public static final double SECONDS_IN_DAY = 86400.0;
    public static final double MILISECONDS_IN_HOUR = 3600000.0;
    public static final double MILISECONDS_IN_MINUTE = 60000.0;
    public static final double MILLISECONDS_IN_DAY = 8.64E7;
    private int m_years;
    private int m_months;
    private int m_days;
    private double m_inDays;
    private double m_inUTCDays;
    private int m_hours;
    private int m_minutes;
    private int m_seconds;

    public static final OwExprTime seconds(int seconds_p) {
        return OwExprTime.time(0, 0, seconds_p);
    }

    public static final OwExprTime minutes(int minutes_p) {
        return OwExprTime.time(0, minutes_p, 0);
    }

    public static final OwExprTime hours(int hours_p) {
        return OwExprTime.time(hours_p, 0, 0);
    }

    public static final OwExprTime time(int hours_p, int minutes_p, int seconds_p) {
        int minutesInSeconds = seconds_p / 60;
        int secondsRest = seconds_p % 60;
        int hoursInMinutes = (minutes_p + minutesInSeconds) / 60;
        int minutesRest = (minutes_p + minutesInSeconds) % 60;
        int daysInHours = (hours_p + hoursInMinutes) / 24;
        int hours = (hours_p + hoursInMinutes) % 24;
        double inDays = ((double)daysInHours + (double)hours * 3600.0 + (double)(60 * minutesRest) + (double)secondsRest) / 86400.0;
        return new OwExprTime(0, 0, daysInHours, inDays, hours, minutesRest, secondsRest);
    }

    public static final OwExprTime timeInDays(double days_p) {
        double flooredDays = Math.floor(days_p);
        double restOfDay = days_p - flooredDays;
        double hours = restOfDay * 24.0;
        double flooredHours = Math.floor(hours);
        double restOfHour = hours - flooredHours;
        double minutes = restOfHour * 60.0;
        double flooredMinutes = Math.floor(minutes);
        double restOfMinute = minutes - flooredMinutes;
        long seconds = (long)Math.floor(restOfMinute * 60.0);
        return new OwExprTime(0, 0, (int)flooredDays, days_p, (int)flooredHours, (int)flooredMinutes, (int)seconds);
    }

    public static final OwExprTime diff(Calendar c1_p, Calendar c2_p) {
        int y1 = c1_p.get(1);
        int mo1 = c1_p.get(2);
        int d1 = c1_p.get(5);
        int h1 = c1_p.get(11);
        int mi1 = c1_p.get(12);
        int s1 = c1_p.get(13);
        int y2 = c2_p.get(1);
        int mo2 = c2_p.get(2);
        int d2 = c2_p.get(5);
        int h2 = c2_p.get(11);
        int mi2 = c2_p.get(12);
        int s2 = c2_p.get(13);
        int dy = 0;
        int dmo = 0;
        int dd = 0;
        int dh = 0;
        int dmi = 0;
        int ds = s1 - s2;
        if (ds < 0) {
            dmo = -1;
            ds = 60 + ds;
        }
        if ((dmi += mi1 - mi2) < 0) {
            dh = -1;
            dmi = 60 + dmo;
        }
        if ((dh += h1 - h2) < 0) {
            dd = -1;
            dh = 24 + dh;
        }
        if ((dd += d1 - d2) < 0) {
            dmo = -1;
            Calendar c1Clone = (Calendar)c1_p.clone();
            c1Clone.add(2, -1);
            int daysPrevMonth = c1Clone.getActualMaximum(5);
            dd = daysPrevMonth + dd;
        }
        if ((dmo += mo1 - mo2) < 0) {
            dy = -1;
            dmo = 13 + dmo;
        }
        dy += y1 - y2;
        long c1UTCMs = c1_p.getTimeInMillis();
        long c2UTCMs = c2_p.getTimeInMillis();
        long c1ms = c1UTCMs + (long)c1_p.getTimeZone().getOffset(c1UTCMs);
        long c2ms = c2UTCMs + (long)c2_p.getTimeZone().getOffset(c2UTCMs);
        long difms = c1ms - c2ms;
        long difUTCms = c1UTCMs - c2UTCMs;
        double difInDays = (double)difms / 8.64E7;
        double difInUTCDays = (double)difUTCms / 8.64E7;
        return new OwExprTime(dy, dmo, dd, difInDays, difInUTCDays, dh, dmi, ds);
    }

    public OwExprTime(int years_p, int months_p, int days_p, double inDays_p) {
        this(years_p, months_p, days_p, inDays_p, 0, 0, 0);
    }

    public OwExprTime(int hours_p, int minutes_p, int seconds_p) {
        this(0, 0, 0, (double)(seconds_p + minutes_p * 60 + hours_p * 60 * 60) / 86400.0, hours_p, minutes_p, seconds_p);
    }

    public OwExprTime(int years_p, int months_p, int days_p, double inDays_p, int hours_p, int minutes_p, int seconds_p) {
        this(years_p, months_p, days_p, inDays_p, inDays_p, hours_p, minutes_p, seconds_p);
    }

    public OwExprTime(int years_p, int months_p, int days_p, double inDays_p, double inUTCDays_p, int hours_p, int minutes_p, int seconds_p) {
        this.m_years = years_p;
        this.m_months = months_p;
        this.m_days = days_p;
        this.m_inDays = inDays_p;
        this.m_inUTCDays = inUTCDays_p;
        this.m_hours = hours_p;
        this.m_minutes = minutes_p;
        this.m_seconds = seconds_p;
    }

    public final int getYears() {
        return this.m_years;
    }

    public final int getMonths() {
        return this.m_months;
    }

    public final int getDays() {
        return this.m_days;
    }

    public final double getInDays() {
        return this.m_inDays;
    }

    public final double getInUTCDays() {
        return this.m_inUTCDays;
    }

    public final int getHours() {
        return this.m_hours;
    }

    public final int getMinutes() {
        return this.m_minutes;
    }

    public final int getSeconds() {
        return this.m_seconds;
    }

    public final Calendar addTo(Calendar calendar_p) {
        Calendar clone = (Calendar)calendar_p.clone();
        TimeZone zone = calendar_p.getTimeZone();
        clone.setTimeZone(zone);
        long utcMs = clone.getTimeInMillis();
        long zoneMs = utcMs + (long)zone.getOffset(utcMs);
        long longTime = (long)(this.m_inDays * 8.64E7);
        long sumInMs = zoneMs + longTime;
        clone.setTimeInMillis(sumInMs - (long)zone.getOffset(utcMs + longTime));
        return clone;
    }

    public final Calendar substractFrom(Calendar calendar_p) {
        Calendar clone = (Calendar)calendar_p.clone();
        TimeZone zone = calendar_p.getTimeZone();
        clone.setTimeZone(zone);
        long utcMs = clone.getTimeInMillis();
        long zoneMs = utcMs + (long)zone.getOffset(utcMs);
        long longTime = (long)(this.m_inDays * 8.64E7);
        long difInMs = zoneMs - longTime;
        clone.setTimeInMillis(difInMs - (long)zone.getOffset(utcMs - longTime));
        return clone;
    }

    public final OwExprTime substract(OwExprTime time_p) {
        return OwExprTime.timeInDays(this.m_inDays - time_p.m_inDays);
    }

    public final OwExprTime add(OwExprTime t_p) {
        OwExprTime newTime = OwExprTime.timeInDays(this.m_inDays + t_p.m_inDays);
        newTime.m_inUTCDays = this.m_inUTCDays + t_p.m_inUTCDays;
        return newTime;
    }

    public boolean equals(Object obj_p) {
        if (obj_p instanceof OwExprTime) {
            OwExprTime timeObject = (OwExprTime)obj_p;
            return this.m_inDays == timeObject.m_inDays;
        }
        return false;
    }

    public int hashCode() {
        return new Double(this.m_inDays).hashCode();
    }

    public String toString() {
        return "" + this.m_years + ":" + this.m_months + ":" + this.m_days + "(" + this.m_inDays + "~" + this.m_inUTCDays + "):" + this.m_hours + ":" + this.m_minutes + ":" + this.m_seconds;
    }

    public int compareTo(Object object_p) {
        if (object_p instanceof OwExprTime) {
            OwExprTime timeObject = (OwExprTime)object_p;
            return new Double(this.m_inDays).compareTo(new Double(timeObject.m_inDays));
        }
        return 1;
    }
}

