/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprScope;
import com.wewebu.expression.language.OwExprTime;
import java.util.Calendar;
import java.util.Date;

public class OwExprType {
    public static final OwExprType STRING = new OwExprType(0, "string");
    public static final OwExprType NUMERIC = new OwExprType(1, "numeric");
    public static final OwExprType TIME = new OwExprType(2, "time");
    public static final OwExprType DATE = new OwExprType(3, "date");
    public static final OwExprType BOOLEAN = new OwExprType(4, "boolean");
    public static final OwExprType SCOPE = new OwExprType(5, "scope");
    public static final OwExprType NULL = new OwExprType(6, "null");
    public static final OwExprType NOTYPE = new OwExprType(7, "notype");
    public static final OwExprType[] ALL_TYPES = new OwExprType[]{STRING, NUMERIC, TIME, DATE, BOOLEAN, NULL, SCOPE, NOTYPE};
    public static final OwExprType[] ALL_TYPE_TYPES = new OwExprType[]{STRING, NUMERIC, TIME, DATE, BOOLEAN, SCOPE, NULL};
    final int m_conversionIndex;
    private String m_name;

    public static final OwExprType fromJavaType(Object javaObject_p) {
        if (javaObject_p == null) {
            return NULL;
        }
        if (javaObject_p instanceof Number) {
            return NUMERIC;
        }
        if (javaObject_p instanceof String) {
            return STRING;
        }
        if (javaObject_p instanceof Character) {
            return STRING;
        }
        if (javaObject_p instanceof Calendar) {
            return DATE;
        }
        if (javaObject_p instanceof OwExprTime) {
            return TIME;
        }
        if (javaObject_p instanceof Date) {
            return DATE;
        }
        if (javaObject_p instanceof Boolean) {
            return BOOLEAN;
        }
        if (javaObject_p instanceof OwExprScope) {
            return SCOPE;
        }
        return SCOPE;
    }

    private OwExprType(int conversionIndex_p, String name_p) {
        this.m_conversionIndex = conversionIndex_p;
        this.m_name = name_p;
    }

    public String toString() {
        return this.m_name;
    }

    public int hashCode() {
        return this.m_conversionIndex;
    }

    public boolean equals(Object obj_p) {
        if (obj_p instanceof OwExprType) {
            OwExprType typeObj = (OwExprType)obj_p;
            return typeObj.m_conversionIndex == this.m_conversionIndex;
        }
        return false;
    }
}

