/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OwExprUnaryConversionTable {
    private static final Set NO_CONVERSION = new HashSet();
    private OwExprType[] m_conversionTable = new OwExprType[OwExprType.ALL_TYPES.length];
    private Map m_typeConversions = new HashMap();

    public OwExprUnaryConversionTable() {
        Arrays.fill(this.m_conversionTable, OwExprType.NOTYPE);
    }

    private static void addDirectionalConversion(Map conversionsMap_p, OwExprType conversion_p, OwExprType type_p) {
        HashSet<OwExprType> conversionFromType = (HashSet<OwExprType>)conversionsMap_p.get(conversion_p);
        if (conversionFromType == null) {
            conversionFromType = new HashSet<OwExprType>();
            conversionsMap_p.put(conversion_p, conversionFromType);
        }
        conversionFromType.add(type_p);
    }

    public Set getConversionsType(Set types_p) {
        HashSet conversions = new HashSet();
        for (OwExprType type : types_p) {
            conversions.addAll(this.getConversionsType(type));
        }
        return conversions;
    }

    public Set getConversionsType(OwExprType type_p) {
        Set typeConversions = (Set)this.m_typeConversions.get(type_p);
        return typeConversions != null ? typeConversions : NO_CONVERSION;
    }

    public final void add(OwExprType[] types_p, OwExprType conversion_p) {
        for (int i = 0; i < types_p.length; ++i) {
            this.add(types_p[i], conversion_p);
        }
    }

    public final void add(OwExprType type_p, OwExprType conversion_p) {
        if (!conversion_p.equals(OwExprType.NOTYPE)) {
            if (!this.m_conversionTable[type_p.m_conversionIndex].equals(OwExprType.NOTYPE)) {
                throw new RuntimeException("The unary conversion table only supports NOTYPE-overrite !");
            }
        } else {
            throw new IllegalArgumentException("The binary conversion table does not support delete-conversion-by-NOTYPE!");
        }
        this.m_conversionTable[type_p.m_conversionIndex] = conversion_p;
        OwExprUnaryConversionTable.addDirectionalConversion(this.m_typeConversions, conversion_p, type_p);
    }

    public final OwExprType convert(OwExprType type_p) {
        return this.m_conversionTable[type_p.m_conversionIndex];
    }
}

