/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprErrorTable;
import com.wewebu.expression.language.OwExprEvaluationException;
import com.wewebu.expression.language.OwExprExpression;
import com.wewebu.expression.language.OwExprExpressionType;
import com.wewebu.expression.language.OwExprScope;
import com.wewebu.expression.language.OwExprSymbolTable;
import com.wewebu.expression.language.OwExprTypeMissmatchException;
import com.wewebu.expression.language.OwExprUnaryOperator;
import com.wewebu.expression.language.OwExprValue;

public class OwExprUnaryExpression
extends OwExprExpression {
    private OwExprExpression m_operand;
    private OwExprUnaryOperator m_operator;

    public OwExprUnaryExpression(OwExprSymbolTable symTable_p, OwExprErrorTable errorTable_p, OwExprUnaryOperator operator_p, OwExprExpression operand_p) {
        super(symTable_p, errorTable_p);
        this.m_operator = operator_p;
        this.m_operand = operand_p;
        this.initType();
    }

    @Override
    public OwExprValue evaluate(OwExprScope scope_p) throws OwExprEvaluationException {
        return this.m_operator.evaluate(scope_p, this.m_operand);
    }

    @Override
    public OwExprExpressionType type() throws OwExprTypeMissmatchException {
        if (!this.m_typeError) {
            return this.m_operator.computeExpressionType(this.m_operand);
        }
        return OwExprExpressionType.NOTYPE;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_operator.toString());
        sb.append(this.m_operand.toString());
        return sb.toString();
    }
}

