/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis;

import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISDMSID;
import com.wewebu.ow.server.util.OwObjectIDCodeUtil;

public class OwCMISSimpleDMSID
implements OwCMISDMSID {
    private String dmsPrefix;
    private String cmisID;
    private String resourceID;

    public OwCMISSimpleDMSID(String dmsPrefix_p, String resourceID_p, String cmisID_p) {
        this.dmsPrefix = dmsPrefix_p;
        this.cmisID = OwObjectIDCodeUtil.decode((String)cmisID_p);
        this.resourceID = resourceID_p;
    }

    @Override
    public String getCMISID() {
        return this.cmisID;
    }

    @Override
    public String getDMSIDString() {
        return OwCMISSimpleDMSID.createDMSID(this.dmsPrefix, this.resourceID, this.cmisID);
    }

    @Override
    public String getResourceID() {
        return this.resourceID;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.cmisID.hashCode();
        result = 31 * result + (this.dmsPrefix == null ? 0 : this.dmsPrefix.hashCode());
        result = 31 * result + (this.resourceID == null ? 0 : this.resourceID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OwCMISSimpleDMSID other = (OwCMISSimpleDMSID)obj;
        if (!this.cmisID.equals(other.cmisID)) {
            return false;
        }
        if (this.resourceID == null ? other.resourceID != null : !this.resourceID.equals(other.resourceID)) {
            return false;
        }
        return !(this.dmsPrefix == null ? other.dmsPrefix != null : !this.dmsPrefix.equals(other.dmsPrefix));
    }

    public static String createDMSID(String dmsPrefix_p, String resourceID_p, String cmisID_p) {
        StringBuilder builder = new StringBuilder(dmsPrefix_p);
        builder.append(",");
        builder.append(resourceID_p);
        builder.append(",");
        builder.append(OwObjectIDCodeUtil.encode((String)cmisID_p));
        return builder.toString();
    }
}

