/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis;

import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISNativePropertyClassFactory;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISSession;
import com.wewebu.ow.server.ecmimpl.opencmis.aspects.OwCMISExceptionManagement;
import com.wewebu.ow.server.ecmimpl.opencmis.conf.OwCMISNetworkCfg;
import com.wewebu.ow.server.ecmimpl.opencmis.converter.OwCMISDateConverter;
import com.wewebu.ow.server.ecmimpl.opencmis.converter.OwCMISIdObjectConverter;
import com.wewebu.ow.server.ecmimpl.opencmis.converter.OwCMISSameTypeConverter;
import com.wewebu.ow.server.ecmimpl.opencmis.converter.OwCMISValueConverter;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISNativeObjectClass;
import com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISAbstractNativePropertyClass;
import com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISBooleanPropertyClassImpl;
import com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISDateTimePropertyClassImpl;
import com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISDecimalPropertyClassImpl;
import com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISHtmlPropertyClassImpl;
import com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISIdPropertyClassImpl;
import com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISIntegerPropertyClassImpl;
import com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISNativePropertyClass;
import com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISStringPropertyClassImpl;
import com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISUriPropertyClassImpl;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwServerException;
import org.apache.chemistry.opencmis.commons.definitions.PropertyBooleanDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDateTimeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDecimalDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyHtmlDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIdDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIntegerDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyStringDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyUriDefinition;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class OwCMISSimplePropertyClassFactory
implements OwCMISNativePropertyClassFactory {
    private static final Logger LOG;
    private OwCMISSession session;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    static {
        OwCMISSimplePropertyClassFactory.ajc$preClinit();
        LOG = OwLog.getLogger(OwCMISSimplePropertyClassFactory.class);
    }

    public OwCMISSimplePropertyClassFactory(OwCMISSession session_p) throws OwInvalidOperationException {
        this.session = session_p;
    }

    @Override
    public OwCMISNativePropertyClass<?, ?, PropertyDefinition<?>> createPropertyClass(String className, PropertyDefinition<?> propertyDefinition, OwCMISNativeObjectClass<?, ?> objectClass) throws OwException {
        String string = className;
        PropertyDefinition<?> propertyDefinition2 = propertyDefinition;
        OwCMISNativeObjectClass<?, ?> owCMISNativeObjectClass = objectClass;
        try {
            OwCMISAbstractNativePropertyClass owCMISAbstractNativePropertyClass;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                OwCMISAbstractNativePropertyClass propertyClass = null;
                try {
                    switch (propertyDefinition.getPropertyType()) {
                        case BOOLEAN: {
                            propertyClass = new OwCMISBooleanPropertyClassImpl(className, (PropertyBooleanDefinition)propertyDefinition, objectClass);
                            break;
                        }
                        case DATETIME: {
                            propertyClass = new OwCMISDateTimePropertyClassImpl(className, (PropertyDateTimeDefinition)propertyDefinition, new OwCMISDateConverter(this.session.getTimeZone()), objectClass);
                            break;
                        }
                        case DECIMAL: {
                            propertyClass = new OwCMISDecimalPropertyClassImpl(className, (PropertyDecimalDefinition)propertyDefinition, objectClass);
                            break;
                        }
                        case INTEGER: {
                            propertyClass = new OwCMISIntegerPropertyClassImpl(className, (PropertyIntegerDefinition)propertyDefinition, objectClass);
                            break;
                        }
                        case STRING: {
                            propertyClass = new OwCMISStringPropertyClassImpl(className, (PropertyStringDefinition)propertyDefinition, objectClass, this.session.getLocale());
                            break;
                        }
                        case ID: {
                            String propertyID = propertyDefinition.getId();
                            OwCMISValueConverter<String, OwObjectReference> objectConverter = this.getIdConverter(propertyID, objectClass);
                            if (objectConverter == null) {
                                propertyClass = new OwCMISIdPropertyClassImpl<String>(className, (PropertyIdDefinition)propertyDefinition, new OwCMISSameTypeConverter<String>(String.class), String.class, objectClass);
                                break;
                            }
                            propertyClass = new OwCMISIdPropertyClassImpl<OwObjectReference>(className, (PropertyIdDefinition)propertyDefinition, objectConverter, OwObjectReference.class, objectClass);
                            break;
                        }
                        case HTML: {
                            propertyClass = new OwCMISHtmlPropertyClassImpl(className, (PropertyHtmlDefinition)propertyDefinition, objectClass);
                            break;
                        }
                        case URI: {
                            propertyClass = new OwCMISUriPropertyClassImpl(className, (PropertyUriDefinition)propertyDefinition, objectClass);
                            break;
                        }
                        default: {
                            LOG.fatal((Object)("OwCMISStandardPropertyClassFactory.createPropertyClass(): Unknown property type " + propertyDefinition.getPropertyType()));
                            throw new OwInvalidOperationException("Unknown property type : " + propertyDefinition.getPropertyType());
                        }
                    }
                    owCMISAbstractNativePropertyClass = propertyClass;
                }
                catch (ClassCastException castEx) {
                    String msg = "Type of property = " + objectClass.getQueryName() + " property " + propertyDefinition.getId() + " not matching instance! type = " + propertyDefinition.getPropertyType().value();
                    LOG.fatal((Object)("OwCMISSimplePropertyClassFactory.createPropertyClass():" + msg), (Throwable)castEx);
                    throw new OwServerException(String.valueOf(msg) + " but is: " + castEx.getMessage(), (Throwable)castEx);
                }
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISAbstractNativePropertyClass;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                Object[] objectArray = new Object[]{string, propertyDefinition2, owCMISNativeObjectClass};
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw cmisBaseException;
        }
    }

    protected OwCMISValueConverter<String, OwObjectReference> getIdConverter(String propertyId, OwCMISNativeObjectClass<?, ?> objectClass) throws OwException {
        String string = propertyId;
        OwCMISNativeObjectClass<?, ?> owCMISNativeObjectClass = objectClass;
        try {
            OwCMISValueConverter<String, OwObjectReference> owCMISValueConverter;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                OwCMISNetworkCfg netCfg = this.session.getNetwork().getNetworkConfiguration();
                owCMISValueConverter = netCfg.getNonSerializedPropertyIds().contains(propertyId) ? null : this.createIdConverter(this.session);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISValueConverter;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string, owCMISNativeObjectClass));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public OwCMISValueConverter<String, OwObjectReference> createIdConverter(OwCMISSession currentSession) throws OwException {
        OwCMISSession owCMISSession = currentSession;
        try {
            OwCMISIdObjectConverter owCMISIdObjectConverter;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                String resourceId = currentSession.getResourceInfo().getId();
                OwCMISNetworkCfg configuration = currentSession.getNetwork().getNetworkConfiguration();
                OwCMISValueConverter<String, String> converter = configuration.getIdDMSIDConverter(resourceId);
                owCMISIdObjectConverter = new OwCMISIdObjectConverter(currentSession, converter);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISIdObjectConverter;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)owCMISSession));
            }
            throw cmisBaseException;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwCMISSimplePropertyClassFactory.java", OwCMISSimplePropertyClassFactory.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createPropertyClass", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISSimplePropertyClassFactory", "java.lang.String:org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition:com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISNativeObjectClass", "className:propertyDefinition:objectClass", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISNativePropertyClass"), 61);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getIdConverter", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISSimplePropertyClassFactory", "java.lang.String:com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISNativeObjectClass", "propertyId:objectClass", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.converter.OwCMISValueConverter"), 124);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createIdConverter", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISSimplePropertyClassFactory", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISSession", "currentSession", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.converter.OwCMISValueConverter"), 137);
    }
}

