/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.alfresco;

import com.wewebu.ow.csqlc.OwCSQLCProcessor;
import com.wewebu.ow.csqlc.OwSQLEntitiesResolver;
import com.wewebu.ow.csqlc.ast.OwCharacterStringLiteral;
import com.wewebu.ow.server.ecmimpl.opencmis.aspects.OwCMISExceptionManagement;
import com.wewebu.ow.server.ecmimpl.opencmis.search.OwCMISCSQLCProcessor;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwSearchCriteria;
import com.wewebu.ow.server.util.OwString;
import java.util.LinkedList;
import java.util.List;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class OwCMISAlfrescoCSQLCProcessor
extends OwCMISCSQLCProcessor {
    protected static final String[] ESCAPE_KEY_WORDS;
    private static final String ALL = "ALL:";
    private static final char TILDE = '~';
    private static final char COLON = ':';
    private static final char SPACE = ' ';
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        OwCMISAlfrescoCSQLCProcessor.ajc$preClinit();
        ESCAPE_KEY_WORDS = new String[]{"and", "or", "not"};
    }

    public OwCMISAlfrescoCSQLCProcessor(OwSQLEntitiesResolver entitiesResolver_p) {
        super(entitiesResolver_p);
    }

    private String textSearchValue(Object value_p) {
        String value = "'" + (value_p == null ? "" : value_p.toString()) + "'";
        return this.escape(value);
    }

    private String escape(String string_p) {
        StringBuilder builder = new StringBuilder(string_p);
        OwString.replaceAll((StringBuilder)builder, (String)"\\", (String)"\\\\");
        OwString.replaceAll((StringBuilder)builder, (String)"'", (String)"\\'");
        return builder.toString();
    }

    protected String createCBRAllExpression(OwSearchCriteria criteria_p, OwCSQLCProcessor.OwProcessContext context_p) throws OwException {
        OwSearchCriteria owSearchCriteria = criteria_p;
        OwCSQLCProcessor.OwProcessContext owProcessContext = context_p;
        try {
            String string;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                Object criteriaValue = criteria_p.getValue();
                string = criteriaValue == null || criteriaValue.toString().length() == 0 ? null : ALL + this.textSearchValue(criteriaValue);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return string;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)owSearchCriteria, (Object)owProcessContext));
            }
            throw cmisBaseException;
        }
    }

    protected String createCBRInExpression(OwSearchCriteria criteria_p, OwCSQLCProcessor.OwProcessContext context_p) throws OwException {
        OwSearchCriteria owSearchCriteria = criteria_p;
        OwCSQLCProcessor.OwProcessContext owProcessContext = context_p;
        try {
            String string;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                Object criteriaValue = criteria_p.getValue();
                if (criteriaValue == null || criteriaValue.toString().length() == 0) {
                    string = null;
                } else {
                    OwFieldDefinition fieldDefinition = this.retrieveDefinition(criteria_p);
                    String fieldName = this.createQueryFieldName(fieldDefinition, context_p);
                    String value = this.textSearchValue(criteriaValue);
                    string = String.valueOf('~') + fieldName + ':' + value;
                }
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return string;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)owSearchCriteria, (Object)owProcessContext));
            }
            throw cmisBaseException;
        }
    }

    protected OwCharacterStringLiteral createContentSearchLiteral(List<String> textSearchExpressions_p, OwSearchCriteria criteria_p) {
        return super.createContentSearchLiteral(this.processContentLiteralValues(textSearchExpressions_p, criteria_p), criteria_p);
    }

    protected List<String> processContentLiteralValues(List<String> textSearchExpressions_p, OwSearchCriteria criteria_p) {
        LinkedList<String> escapedStrings = new LinkedList<String>();
        for (String value : textSearchExpressions_p) {
            String lowerCaseValue = value.toLowerCase();
            String newValue = value;
            String[] stringArray = ESCAPE_KEY_WORDS;
            int n = ESCAPE_KEY_WORDS.length;
            int n2 = 0;
            while (n2 < n) {
                String match = stringArray[n2];
                if (lowerCaseValue.equals(match) && lowerCaseValue.length() == match.length()) {
                    newValue = String.valueOf("\"".intern()) + value + "\"".intern();
                    break;
                }
                int cursor = 0;
                int idx = -1;
                do {
                    idx = lowerCaseValue.indexOf(match, cursor);
                    cursor = idx + match.length();
                    if (idx != 0 && (idx <= 0 || lowerCaseValue.charAt(idx - 1) != ' ') || cursor != lowerCaseValue.length() && (cursor >= lowerCaseValue.length() || lowerCaseValue.charAt(cursor) != ' ')) continue;
                    StringBuilder build = new StringBuilder(newValue.substring(0, idx));
                    build.append("\"".intern());
                    build.append(newValue.substring(idx, cursor));
                    build.append("\"".intern());
                    if (cursor < lowerCaseValue.length()) {
                        build.append(newValue.substring(cursor));
                    }
                    newValue = build.toString();
                    lowerCaseValue = newValue.toLowerCase();
                } while (idx >= 0);
                ++n2;
            }
            escapedStrings.add(newValue);
        }
        return escapedStrings;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwCMISAlfrescoCSQLCProcessor.java", OwCMISAlfrescoCSQLCProcessor.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "createCBRAllExpression", "com.wewebu.ow.server.ecmimpl.opencmis.alfresco.OwCMISAlfrescoCSQLCProcessor", "com.wewebu.ow.server.field.OwSearchCriteria:com.wewebu.ow.csqlc.OwCSQLCProcessor$OwProcessContext", "criteria_p:context_p", "com.wewebu.ow.server.exceptions.OwException", "java.lang.String"), 58);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "createCBRInExpression", "com.wewebu.ow.server.ecmimpl.opencmis.alfresco.OwCMISAlfrescoCSQLCProcessor", "com.wewebu.ow.server.field.OwSearchCriteria:com.wewebu.ow.csqlc.OwCSQLCProcessor$OwProcessContext", "criteria_p:context_p", "com.wewebu.ow.server.exceptions.OwException", "java.lang.String"), 68);
    }
}

