/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.auth;

import com.wewebu.ow.server.app.OwConfiguration;
import com.wewebu.ow.server.conf.OwBaseInitializer;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.opencmis.aspects.OwCMISExceptionManagement;
import com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISAuthenticationInterceptor;
import com.wewebu.ow.server.ecmimpl.opencmis.conf.OwCMISNetworkCfg;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.util.OwAuthenticationConfiguration;
import com.wewebu.ow.server.util.OwXMLUtil;
import com.wewebu.ow.server.util.ldap.OwLdapConnector;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public abstract class OwCMISAbstractAuthenticator
implements OwCMISAuthenticationInterceptor {
    private static final String ECM_ADAPTER = "EcmAdapter";
    private OwBaseInitializer baseInitializer;
    private OwCMISNetwork network;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public OwCMISAbstractAuthenticator(OwBaseInitializer initializer) {
        this.baseInitializer = initializer;
    }

    public OwCMISAbstractAuthenticator(OwCMISNetwork network) {
        this.network = network;
    }

    protected OwCMISNetworkCfg getNetworkConfiguration() throws OwConfigurationException {
        if (this.network != null) {
            return this.network.getNetworkConfiguration();
        }
        OwXMLUtil bootstrapx = OwConfiguration.getBootstrap((OwBaseInitializer)this.baseInitializer);
        if (bootstrapx == null) {
            throw new OwConfigurationException("No bootstrap.");
        }
        try {
            return new OwCMISNetworkCfg(bootstrapx.getSubUtil(ECM_ADAPTER));
        }
        catch (Exception e) {
            throw new OwConfigurationException("Invalid bootstrap.", (Throwable)e);
        }
    }

    public Map<String, String> buildOpenCmisParameters(String user_p, String pwd_p, Locale currentLocale_p) throws OwConfigurationException {
        Map<String, String> opencmisParameters = this.getNetworkConfiguration().getBindingConfig();
        opencmisParameters.put("org.apache.chemistry.opencmis.user", user_p);
        opencmisParameters.put("org.apache.chemistry.opencmis.password", pwd_p);
        if (currentLocale_p != null && !"debugmode".equals(currentLocale_p.toString())) {
            opencmisParameters.put("org.apache.chemistry.opencmis.locale.iso3166", currentLocale_p.getCountry());
            opencmisParameters.put("org.apache.chemistry.opencmis.locale.iso639", currentLocale_p.getLanguage());
            opencmisParameters.put("org.apache.chemistry.opencmis.locale.variant", currentLocale_p.getVariant());
        }
        return opencmisParameters;
    }

    protected OwCMISNetwork getNetwork() {
        return this.network;
    }

    protected OwBaseInitializer getBaseInitialzier() {
        return this.baseInitializer;
    }

    protected OwLdapConnector createLDAPConnector(OwAuthenticationConfiguration authenticationConf_p) throws OwException {
        OwAuthenticationConfiguration owAuthenticationConfiguration = authenticationConf_p;
        try {
            OwLdapConnector owLdapConnector;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                owLdapConnector = new OwLdapConnector(authenticationConf_p.getConfiguration().getNode());
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owLdapConnector;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)owAuthenticationConfiguration));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public void init(OwXMLUtil configNode) throws OwException {
        OwXMLUtil owXMLUtil = configNode;
        try {
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)owXMLUtil));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public AuthenticationProvider createAuthenticationProvider(Map<String, String> information) throws OwException {
        Map<String, String> map = information;
        try {
            AuthenticationProvider authenticationProvider;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                authenticationProvider = null;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return authenticationProvider;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, map));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public boolean onRequest(HttpServletRequest req, HttpServletResponse resp) throws OwException, IOException {
        HttpServletRequest httpServletRequest = req;
        HttpServletResponse httpServletResponse = resp;
        try {
            boolean bl;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                bl = false;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return bl;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)httpServletRequest, (Object)httpServletResponse));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public boolean processRendering(HttpServletRequest req, HttpServletResponse resp) {
        return true;
    }

    static {
        OwCMISAbstractAuthenticator.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwCMISAbstractAuthenticator.java", OwCMISAbstractAuthenticator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "createLDAPConnector", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISAbstractAuthenticator", "com.wewebu.ow.server.util.OwAuthenticationConfiguration", "authenticationConf_p", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.util.ldap.OwLdapConnector"), 139);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "init", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISAbstractAuthenticator", "com.wewebu.ow.server.util.OwXMLUtil", "configNode", "com.wewebu.ow.server.exceptions.OwException", "void"), 145);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createAuthenticationProvider", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISAbstractAuthenticator", "java.util.Map", "information", "com.wewebu.ow.server.exceptions.OwException", "org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider"), 151);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onRequest", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISAbstractAuthenticator", "javax.servlet.http.HttpServletRequest:javax.servlet.http.HttpServletResponse", "req:resp", "com.wewebu.ow.server.exceptions.OwException:java.io.IOException", "boolean"), 157);
    }
}

