/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.auth;

import com.wewebu.ow.server.app.OwConfiguration;
import com.wewebu.ow.server.auth.OwAuthentication;
import com.wewebu.ow.server.auth.OwAuthenticator;
import com.wewebu.ow.server.conf.OwBaseInitializer;
import com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISCredentialsAuthenticator;
import com.wewebu.ow.server.ecmimpl.opencmis.conf.OwCMISNetworkCfg;
import com.wewebu.ow.server.exceptions.OwAuthenticationException;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.util.OwAuthenticationConfiguration;
import com.wewebu.ow.server.util.OwXMLUtil;

public class OwCMISAuthenticationFactoryAuthenticator
implements OwAuthenticator {
    private OwBaseInitializer initializer;

    public OwCMISAuthenticationFactoryAuthenticator(OwBaseInitializer initializer) {
        this.initializer = initializer;
    }

    public OwAuthentication authenticate(OwAuthentication authentication) throws OwAuthenticationException, OwConfigurationException, OwServerException {
        OwCMISCredentialsAuthenticator currentAuthenticator = this.createAuthenticator(authentication);
        return currentAuthenticator.authenticate(authentication);
    }

    protected OwCMISCredentialsAuthenticator createAuthenticator(OwAuthentication authentication) throws OwConfigurationException {
        OwAuthenticationConfiguration authConf = this.getNetworkConfiguration().getAuthenticationConfiguration();
        if (authConf.getMode() != null) {
            return new OwCMISCredentialsAuthenticator(this.initializer);
        }
        String msg = "Invalid CMIS authentication configuration! Invalid <Authentication> @mode : " + authConf.getMode();
        throw new OwConfigurationException(msg);
    }

    protected OwCMISNetworkCfg getNetworkConfiguration() throws OwConfigurationException {
        OwXMLUtil bootstrapx = OwConfiguration.getBootstrap((OwBaseInitializer)this.initializer);
        if (bootstrapx == null) {
            throw new OwConfigurationException("No bootstrap configuration found/available");
        }
        try {
            return new OwCMISNetworkCfg(bootstrapx.getSubUtil("EcmAdapter"));
        }
        catch (Exception e) {
            throw new OwConfigurationException("Invalid bootstrap.", (Throwable)e);
        }
    }
}

