/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.collections;

import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISNativeSession;
import com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISNativeObject;
import com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISObject;
import com.wewebu.ow.server.exceptions.OwException;
import java.util.Iterator;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.TransientCmisObject;

public class OwCMISObjectIterator
implements Iterator<OwCMISObject> {
    private Iterator<? extends CmisObject> iterator;
    private OwCMISNativeSession session;

    public OwCMISObjectIterator(Iterator<? extends CmisObject> iterator, OwCMISNativeSession session) {
        this.iterator = iterator;
        this.session = session;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public OwCMISObject next() {
        CmisObject child = this.iterator.next();
        return this.from(child);
    }

    private OwCMISObject from(CmisObject child) {
        try {
            TransientCmisObject transinetChild = child.getTransientObject();
            OwCMISNativeObject<TransientCmisObject> childObject = this.session.from(transinetChild, null);
            return childObject;
        }
        catch (OwException owe) {
            throw new RuntimeException(owe);
        }
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not supported yet!");
    }
}

