/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.converter;

import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISDMSID;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISDMSIDDecoder;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISSimpleDMSID;
import com.wewebu.ow.server.ecmimpl.opencmis.converter.OwCMISValueConverter;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.util.OwString;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class OwCMISIDDMSIDConverter
implements OwCMISValueConverter<String, String> {
    private static final Logger LOG = OwLog.getLogger(OwCMISIDDMSIDConverter.class);
    protected OwCMISDMSIDDecoder dmsidDecoder;
    protected String resourceID;

    public OwCMISIDDMSIDConverter(OwCMISDMSIDDecoder dmsidDecoder_p, String resourceID_p) {
        this.dmsidDecoder = dmsidDecoder_p;
        this.resourceID = resourceID_p;
    }

    @Override
    public List<String> fromArrayValue(Object[] owdValue_p) throws OwInvalidOperationException {
        LinkedList<String> list = new LinkedList<String>();
        if (owdValue_p != null) {
            int i = 0;
            while (i < owdValue_p.length) {
                try {
                    if (owdValue_p[i] != null) {
                        OwCMISDMSID dmsid = this.dmsidDecoder.createDMSID((String)owdValue_p[i]);
                        list.add(dmsid.getCMISID());
                    } else {
                        list.add(null);
                    }
                }
                catch (OwException e) {
                    LOG.error((Object)("OwCMISIdDMSIDConverter.fromArrayValue(): Invalid DMSID value : " + owdValue_p[i]), (Throwable)e);
                    throw new OwInvalidOperationException(new OwString("opencmis.OwCMISIdDMSIDConverter.err.invalid.dmsid", "Invalid DMSID found!"), (Throwable)e);
                }
                ++i;
            }
        }
        return list;
    }

    @Override
    public List<String> fromValue(String owdValue_p) throws OwInvalidOperationException {
        if (owdValue_p != null) {
            try {
                OwCMISDMSID dmsid = this.dmsidDecoder.createDMSID(owdValue_p);
                LinkedList<String> list = new LinkedList<String>();
                list.add(dmsid.getCMISID());
                return list;
            }
            catch (OwException e) {
                LOG.error((Object)("OwCMISIdDMSIDConverter.fromArrayValue(): Invalid DMSID value : " + owdValue_p), (Throwable)e);
                throw new OwInvalidOperationException(new OwString("opencmis.OwCMISIdDMSIDConverter.err.invalid.dmsid", "Invalid DMSID found!"), (Throwable)e);
            }
        }
        return new LinkedList<String>();
    }

    public Class<String> getOClass() {
        return String.class;
    }

    public String[] toArrayValue(List<String> cmisValue_p) {
        if (cmisValue_p == null || cmisValue_p.isEmpty()) {
            return null;
        }
        String[] stringValues = new String[cmisValue_p.size()];
        int i = 0;
        while (i < stringValues.length) {
            String id = cmisValue_p.get(i);
            if (id != null) {
                OwCMISDMSID dmsid = this.fromID(id);
                stringValues[i] = dmsid.getDMSIDString();
            } else {
                stringValues[i] = null;
            }
            ++i;
        }
        return stringValues;
    }

    protected OwCMISDMSID fromID(String id_p) {
        return new OwCMISSimpleDMSID(this.dmsidDecoder.getDMSIDPrefix(), this.resourceID, id_p);
    }

    @Override
    public String toValue(List<String> cmisValue_p) {
        if (cmisValue_p == null || cmisValue_p.isEmpty()) {
            return null;
        }
        String id = cmisValue_p.get(0);
        OwCMISDMSID dmsid = this.fromID(id);
        return dmsid.getDMSIDString();
    }

    public OwCMISValueConverter<String, String> newConverter(OwCMISNetwork network_p) {
        return this;
    }

    public String[] toStaticArrayValue(List<String> cmisValue_p) throws OwInvalidOperationException {
        if (cmisValue_p == null || cmisValue_p.isEmpty()) {
            return null;
        }
        String[] stringValues = new String[cmisValue_p.size()];
        int i = 0;
        while (i < stringValues.length) {
            String id = cmisValue_p.get(i);
            OwCMISSimpleDMSID dmsid = new OwCMISSimpleDMSID(this.dmsidDecoder.getDMSIDPrefix(), this.resourceID, id);
            stringValues[i] = dmsid.getDMSIDString();
            ++i;
        }
        return stringValues;
    }

    public String toStaticValue(List<String> cmisValue_p) throws OwInvalidOperationException {
        if (cmisValue_p == null || cmisValue_p.isEmpty()) {
            return null;
        }
        String id = cmisValue_p.get(0);
        OwCMISSimpleDMSID dmsid = new OwCMISSimpleDMSID(this.dmsidDecoder.getDMSIDPrefix(), this.resourceID, id);
        return dmsid.getDMSIDString();
    }
}

