/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.cross;

import com.wewebu.ow.csqlc.ast.OwExternal;
import com.wewebu.ow.csqlc.ast.OwQueryStatement;
import com.wewebu.ow.server.ao.OwAOSupport;
import com.wewebu.ow.server.ao.OwFileAOSupport;
import com.wewebu.ow.server.ao.OwVirtualFolderFactory;
import com.wewebu.ow.server.ao.OwVirtualFoldersManager;
import com.wewebu.ow.server.collections.OwIterable;
import com.wewebu.ow.server.collections.OwLoadContext;
import com.wewebu.ow.server.ecm.OwBatch;
import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwCredentials;
import com.wewebu.ow.server.ecm.OwCrossMappings;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectSkeleton;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwRepository;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.OwStandardCrossMappings;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecm.OwVirtualFolderObject;
import com.wewebu.ow.server.ecm.OwVirtualFolderObjectFactory;
import com.wewebu.ow.server.ecm.ui.OwUIAccessRightsModul;
import com.wewebu.ow.server.ecm.ui.OwUILoginModul;
import com.wewebu.ow.server.ecm.ui.OwUIUserSelectModul;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISAuthenticatedNetwork;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISDMSID;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISDMSIDDecoder;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISExternalEntitiesResolver;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISVirtualFolderFactory;
import com.wewebu.ow.server.ecmimpl.opencmis.aspects.OwCMISExceptionManagement;
import com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISAuthenticationInterceptor;
import com.wewebu.ow.server.ecmimpl.opencmis.conf.OwCMISNetworkCfg;
import com.wewebu.ow.server.ecmimpl.opencmis.cross.OwCMISCrossDomainFolder;
import com.wewebu.ow.server.ecmimpl.opencmis.cross.OwCMISCrossInvocationHandler;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISObject;
import com.wewebu.ow.server.ecmimpl.opencmis.search.OwCMISSearchResult;
import com.wewebu.ow.server.ecmimpl.opencmis.ui.OwCMISUILoginModule;
import com.wewebu.ow.server.event.OwEventManager;
import com.wewebu.ow.server.exceptions.OwAuthenticationException;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.role.OwRoleManager;
import com.wewebu.ow.server.util.OwNetworkConfiguration;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString1;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.w3c.dom.Node;

public class OwCMISCrossNetwork
implements OwCMISAuthenticatedNetwork,
OwCMISExternalEntitiesResolver,
OwVirtualFolderFactory {
    private static final Logger LOG;
    private OwCMISNetwork internalNetwork;
    private OwNetwork externalNetwork;
    private List<String> internalResourceIDs = new LinkedList<String>();
    private List<String> externalResourceIDs = new LinkedList<String>();
    private List<String> crossResourceIDs = new LinkedList<String>();
    private OwXMLUtil externalConfiguration;
    private OwCMISNetworkCfg crossConfiguration;
    private OwRoleManager roleManager;
    private OwStandardCrossMappings xMapping;
    private OwNetworkContext context;
    private OwObject domainFolder;
    private OwVirtualFoldersManager vfManager;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;

    static {
        OwCMISCrossNetwork.ajc$preClinit();
        LOG = OwLog.getLogger(OwCMISCrossNetwork.class);
    }

    public OwNetwork getNetwork(OwResource resource_p) throws Exception {
        if (resource_p == null) {
            return this.internalNetwork;
        }
        String rID = resource_p.getID();
        return this.getNetwork(rID);
    }

    private String removeResourcePrefix(OwNetwork network_p, String id_p) {
        if (id_p == null) {
            return null;
        }
        String prefix = String.valueOf(network_p.getDMSPrefix()) + "/";
        if (id_p.startsWith(prefix)) {
            id_p = id_p.substring(prefix.length());
        }
        return id_p;
    }

    public OwNetwork getNetwork(String resourceID_p) throws OwException {
        String string = resourceID_p;
        try {
            OwCMISNetwork owCMISNetwork;
            block13: {
                OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
                try {
                    block14: {
                        if (resourceID_p == null) {
                            owCMISNetwork = this.internalNetwork;
                            break block13;
                        }
                        if (this.internalResourceIDs.contains(resourceID_p)) {
                            owCMISNetwork = this.internalNetwork;
                            break block13;
                        }
                        if (this.externalNetwork != null && this.externalResourceIDs.contains(resourceID_p)) {
                            owCMISNetwork = this.externalNetwork;
                            break block13;
                        }
                        OwCMISResource resource = null;
                        try {
                            resource = this.internalNetwork.getResource(resourceID_p);
                            if (resource == null) break block14;
                            owCMISNetwork = this.internalNetwork;
                            break block13;
                        }
                        catch (OwObjectNotFoundException internalException) {
                            try {
                                resourceID_p = this.removeResourcePrefix(this.externalNetwork, resourceID_p);
                                resource = this.externalNetwork.getResource(resourceID_p);
                                if (resource == null) break block14;
                                owCMISNetwork = this.externalNetwork;
                                break block13;
                            }
                            catch (Exception externalException) {
                                LOG.error((Object)("Unknown internal resource " + resourceID_p), (Throwable)internalException);
                                LOG.error((Object)("Unknown external resource " + resourceID_p), (Throwable)externalException);
                                throw new OwObjectNotFoundException("Unknown resource " + resourceID_p, (Throwable)internalException);
                            }
                        }
                    }
                    LOG.error((Object)("OwCMISCrossNetwork.getNetwork(): Unknown resource " + resourceID_p));
                    throw new OwObjectNotFoundException("Unknown resource " + resourceID_p);
                }
                finally {
                    OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
                }
            }
            return owCMISNetwork;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string));
            }
            throw cmisBaseException;
        }
    }

    public boolean canCreateNewObject(OwResource resource_p, OwObject parent_p, int context_p) throws Exception {
        return this.getNetwork(resource_p).canCreateNewObject(resource_p, parent_p, context_p);
    }

    public boolean canCreateObjectCopy(OwObject parent_p, int[] childTypes_p, int context_p) throws Exception {
        if (parent_p.getResource() == null) {
            return true;
        }
        String rID = parent_p.getResourceID();
        return this.getNetwork(rID).canCreateObjectCopy(parent_p, childTypes_p, context_p);
    }

    public boolean canDo(OwObject obj_p, int functionCode_p, int context_p) throws Exception {
        String rID = obj_p.getResourceID();
        return this.getNetwork(rID).canDo(obj_p, functionCode_p, context_p);
    }

    public boolean canEditAccessRights(OwObject object_p) throws Exception {
        String rID = object_p.getResourceID();
        return this.getNetwork(rID).canEditAccessRights(object_p);
    }

    public String createNewObject(final OwResource resource_p, final String strObjectClassName_p, final OwPropertyCollection properties_p, final OwPermissionCollection permissions_p, final OwContentCollection content_p, final OwObject parent_p, final String strMimeType_p, final String strMimeParameter_p) throws Exception {
        OwNetwork network = this.getNetwork(resource_p);
        OwResource defaultResource = this.getResource(null);
        if (resource_p.getID().equals(defaultResource.getID())) {
            return network.createNewObject(resource_p, strObjectClassName_p, properties_p, permissions_p, content_p, parent_p, strMimeType_p, strMimeParameter_p);
        }
        final OwNetwork fnetwork = OwCMISCrossInvocationHandler.createCrossNetworkObject(this, this.getXMapping(), network, resource_p.getID());
        return (String)OwCMISCrossInvocationHandler.call(new OwCMISCrossInvocationHandler.CrossCall(){

            @Override
            public Object call() throws Exception {
                return fnetwork.createNewObject(resource_p, strObjectClassName_p, properties_p, permissions_p, content_p, parent_p, strMimeType_p, strMimeParameter_p);
            }
        }, defaultResource.getID());
    }

    public String createNewObject(final boolean fPromote_p, final Object mode_p, final OwResource resource_p, final String strObjectClassName_p, final OwPropertyCollection properties_p, final OwPermissionCollection permissions_p, final OwContentCollection content_p, final OwObject parent_p, final String strMimeType_p, final String strMimeParameter_p) throws Exception {
        OwNetwork network = this.getNetwork(resource_p);
        OwResource defaultResource = this.getResource(null);
        if (resource_p.getID().equals(defaultResource.getID())) {
            return network.createNewObject(fPromote_p, mode_p, resource_p, strObjectClassName_p, properties_p, permissions_p, content_p, parent_p, strMimeType_p, strMimeParameter_p);
        }
        final OwNetwork fnetwork = OwCMISCrossInvocationHandler.createCrossNetworkObject(this, this.getXMapping(), network, resource_p.getID());
        return (String)OwCMISCrossInvocationHandler.call(new OwCMISCrossInvocationHandler.CrossCall(){

            @Override
            public Object call() throws Exception {
                return fnetwork.createNewObject(fPromote_p, mode_p, resource_p, strObjectClassName_p, properties_p, permissions_p, content_p, parent_p, strMimeType_p, strMimeParameter_p);
            }
        }, defaultResource.getID());
    }

    public String createNewObject(boolean promote_p, Object mode_p, OwResource resource_p, String strObjectClassName_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p, OwContentCollection content_p, OwObject parent_p, String strMimeType_p, String strMimeParameter_p, boolean keepCheckedOut_p) throws Exception {
        OwNetwork network = this.getNetwork(resource_p);
        return network.createNewObject(promote_p, mode_p, resource_p, strObjectClassName_p, properties_p, permissions_p, content_p, parent_p, strMimeType_p, strMimeParameter_p, keepCheckedOut_p);
    }

    public String createObjectCopy(OwObject obj_p, final OwPropertyCollection properties_p, final OwPermissionCollection permissions_p, final OwObject parent_p, final int[] childTypes_p) throws Exception {
        OwNetwork network = this.getNetwork(parent_p.getResourceID());
        if (!obj_p.getResourceID().equals(parent_p.getResourceID())) {
            final OwObject fobj = OwCMISCrossInvocationHandler.createCrossNetworkObject(this, this.getXMapping(), obj_p, obj_p.getResourceID());
            final OwNetwork fnetwork = OwCMISCrossInvocationHandler.createCrossNetworkObject(this, this.getXMapping(), network, parent_p.getResourceID());
            return (String)OwCMISCrossInvocationHandler.call(new OwCMISCrossInvocationHandler.CrossCall(){

                @Override
                public Object call() throws Exception {
                    return fnetwork.createObjectCopy(fobj, properties_p, permissions_p, parent_p, childTypes_p);
                }
            }, obj_p.getResourceID());
        }
        return network.createObjectCopy(obj_p, properties_p, permissions_p, parent_p, childTypes_p);
    }

    public OwObjectSkeleton createObjectSkeleton(OwObjectClass objectclass_p, OwResource resource_p) throws Exception {
        OwNetwork network = this.getNetwork(resource_p);
        return network.createObjectSkeleton(objectclass_p, resource_p);
    }

    public Object getApplicationObject(int typ_p, String strName_p, Object param_p, boolean forceUserSpecificObject_p, boolean createIfNotExist_p) throws Exception {
        if (typ_p == 1) {
            return this.getVFManager().getApplicationObject(strName_p, param_p, forceUserSpecificObject_p, createIfNotExist_p);
        }
        return this.internalNetwork.getApplicationObject(typ_p, strName_p, param_p, forceUserSpecificObject_p, createIfNotExist_p);
    }

    public Object getApplicationObject(int typ_p, String strName_p, boolean forceUserSpecificObject_p, boolean createIfNotExist_p) throws Exception {
        if (typ_p == 1) {
            return this.getVFManager().getApplicationObject(strName_p, forceUserSpecificObject_p, createIfNotExist_p);
        }
        return this.internalNetwork.getApplicationObject(typ_p, strName_p, forceUserSpecificObject_p, createIfNotExist_p);
    }

    public Collection getApplicationObjects(int typ_p, String strName_p, boolean forceUserSpecificObject_p) throws Exception {
        return this.internalNetwork.getApplicationObjects(typ_p, strName_p, forceUserSpecificObject_p);
    }

    public OwUIAccessRightsModul getEditAccessRightsSubModul(OwObject object_p) throws Exception {
        String rID = object_p.getResourceID();
        return this.getNetwork(rID).getEditAccessRightsSubModul(object_p);
    }

    public Object getInterface(String strInterfaceName_p, Object object_p) throws Exception {
        return this.internalNetwork.getInterface(strInterfaceName_p, object_p);
    }

    public OwCMISNetwork getInternalNetwork() {
        return this.internalNetwork;
    }

    public OwNetwork getExternalNetwork() {
        return this.externalNetwork;
    }

    public Locale getLocale() {
        return this.internalNetwork.getLocale();
    }

    public boolean hasInterface(String strInterfaceName_p) {
        return this.internalNetwork.hasInterface(strInterfaceName_p);
    }

    public void init(OwNetworkContext context_p, OwXMLUtil networkSettings_p) throws Exception {
        this.crossConfiguration = new OwCMISNetworkCfg(networkSettings_p);
        this.context = context_p;
        this.internalNetwork = new OwCMISNetwork(this, new OwCMISVirtualFolderFactory(this));
        this.internalNetwork.init(context_p, networkSettings_p);
        OwXMLUtil externalConfiguration = networkSettings_p.getSubUtil("ExternalCrossAdapter");
        if (externalConfiguration != null) {
            this.externalInit(context_p, externalConfiguration);
        }
    }

    protected void externalInit(OwNetworkContext context_p, OwXMLUtil networkSettings_p) throws OwException {
        OwNetworkContext owNetworkContext = context_p;
        OwXMLUtil owXMLUtil = networkSettings_p;
        try {
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                this.externalConfiguration = networkSettings_p;
                OwXMLUtil adapterConfiguration = null;
                try {
                    adapterConfiguration = networkSettings_p.getSubUtil("XEcmAdapter");
                }
                catch (Exception e) {
                    LOG.error((Object)"OwCMISCrossNetwork.externalInit(): The external ECM Adapter could not be loaded.", (Throwable)e);
                    throw new OwConfigurationException(new OwString("opencmis.cross.OwCMISCrossNetwork.err.read.xecmadapter", "Could not read CMIS cross configuration!"), (Throwable)e);
                }
                if (adapterConfiguration == null) {
                    LOG.error((Object)"OwCMISCrossNetwork.externalInit(): The external ECM Adapter configuration could not be found.");
                    throw new OwConfigurationException(new OwString("opencmis.cross.OwCMISCrossNetwork.err.invalid.conf", "Missing CMIS cross configuration!"));
                }
                String strNetworkClassName = "";
                try {
                    strNetworkClassName = adapterConfiguration.getSafeTextValue("ClassName", null);
                    Class<?> NetworkClass = Class.forName(strNetworkClassName);
                    this.externalNetwork = (OwNetwork)NetworkClass.newInstance();
                    this.externalNetwork.init(context_p, adapterConfiguration);
                    this.externalNetwork.setEventManager(this.getEventManager());
                    this.externalNetwork.setRoleManager(this.roleManager);
                }
                catch (Exception e) {
                    LOG.error((Object)("OwCMISCrossNetwork.externalInit(): The external ECM Adapter could not be loaded: " + strNetworkClassName), (Throwable)e);
                    throw new OwConfigurationException(new OwString("opencmis.cross.OwCMISCrossNetwork.err.externalClass", "Invalid CMIS NetworkClass configuration!"), (Throwable)e);
                }
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)owNetworkContext, (Object)owXMLUtil));
            }
            throw cmisBaseException;
        }
    }

    public void setEventManager(OwEventManager eventManager_p) {
        this.internalNetwork.setEventManager(eventManager_p);
        if (this.externalNetwork != null) {
            this.externalNetwork.setEventManager(eventManager_p);
        }
    }

    public void setRoleManager(OwRoleManager roleManager_p) {
        this.roleManager = roleManager_p;
        this.internalNetwork.setRoleManager(roleManager_p);
        if (this.externalNetwork != null) {
            this.externalNetwork.setRoleManager(roleManager_p);
        }
    }

    public boolean canBatch() {
        return this.internalNetwork.canBatch();
    }

    public boolean canRefreshStaticClassdescriptions() throws Exception {
        return this.internalNetwork.canRefreshStaticClassdescriptions();
    }

    public void closeBatch(OwBatch batch_p) throws OwException {
        OwBatch owBatch = batch_p;
        try {
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                this.internalNetwork.closeBatch(batch_p);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)owBatch));
            }
            throw cmisBaseException;
        }
    }

    public OwObjectCollection doSearch(OwSearchNode searchCriteria_p, OwSort sortCriteria_p, Collection propertyNames_p, int maxSize_p, int versionSelection_p) throws Exception {
        OwCMISSearchResult result = this.internalNetwork.doCMISSearch(searchCriteria_p, sortCriteria_p, propertyNames_p, maxSize_p, versionSelection_p);
        OwExternal<List<OwQueryStatement>> exStatements = result.getExternalStatements();
        if (exStatements.hasExternalObjectStores()) {
            OwStandardObjectCollection crossCollection = new OwStandardObjectCollection();
            List externalObjectStores = exStatements.getExternalObjectStores();
            for (String[] xStore : externalObjectStores) {
                OwObjectCollection externalResults = this.doExternalRepositorySearch(xStore[0], searchCriteria_p, sortCriteria_p, propertyNames_p, maxSize_p, versionSelection_p);
                crossCollection.addAll((Collection)result.getCmisSearchResult());
                crossCollection.addAll((Collection)externalResults);
            }
            return crossCollection;
        }
        return result.getCmisSearchResult();
    }

    protected OwObjectCollection doExternalRepositorySearch(String xStore_p, OwSearchNode searchNode_p, OwSort sort_p, Collection propertyNames_p, int maxSize_p, int versionSelection_p) throws Exception {
        OwCrossMappings xMapping = this.getXMapping();
        OwSearchNode xSearchNode = xMapping.getXSearch(searchNode_p, xStore_p, this.externalNetwork);
        OwSort xSort = xMapping.getXSort(sort_p);
        Collection xProperties = xMapping.getXProperties(propertyNames_p);
        OwObjectCollection result = this.externalNetwork.doSearch(xSearchNode, xSort, xProperties, maxSize_p, versionSelection_p);
        int i = 0;
        while (i < result.size()) {
            OwObject obj = (OwObject)result.get(i);
            OwObject crossObject = OwCMISCrossInvocationHandler.createCrossNetworkObject(this, xMapping, obj, obj.getResourceID());
            result.set(i, (Object)crossObject);
            ++i;
        }
        return result;
    }

    public synchronized OwCrossMappings getXMapping() throws OwException {
        try {
            OwStandardCrossMappings owStandardCrossMappings;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                if (this.xMapping == null) {
                    OwXMLUtil xconfig = null;
                    try {
                        xconfig = this.externalConfiguration.getSubUtil("XMapping");
                    }
                    catch (OwException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new OwConfigurationException(this.getContext().localize("opencmis.cross.OwCMISCrossNetwork.err.read.xmapping", "Could not read XMapping."), (Throwable)e);
                    }
                    if (xconfig == null) {
                        LOG.error((Object)"OwCMISCrossNetwork.getXMapping: The external ECM Adapter could not be loaded (is null), please define XMapping.");
                        throw new OwConfigurationException(this.getContext().localize("opencmis.cross.OwCMISCrossNetwork.err.no.xmapping", "The external ECM adapter could not be loaded, please define XMapping."));
                    }
                    this.xMapping = new OwStandardCrossMappings(xconfig);
                }
                owStandardCrossMappings = this.xMapping;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owStandardCrossMappings;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    public String getDMSPrefix() {
        return this.internalNetwork.getDMSPrefix();
    }

    public OwEventManager getEventManager() {
        return this.internalNetwork.getEventManager();
    }

    public OwObjectClass getObjectClass(String strClassName_p, OwResource resource_p) throws Exception {
        OwNetwork network = this.getNetwork(resource_p);
        OwObjectClass clazz = network.getObjectClass(strClassName_p, resource_p);
        return OwCMISCrossInvocationHandler.createCrossNetworkObject(this, this.getXMapping(), clazz, resource_p.getID());
    }

    public Map getObjectClassNames(int[] types_p, boolean excludeHiddenAndNonInstantiable_p, boolean rootOnly_p, OwResource resource_p) throws Exception {
        return this.getNetwork(resource_p).getObjectClassNames(types_p, excludeHiddenAndNonInstantiable_p, rootOnly_p, resource_p);
    }

    public OwObject getObjectFromDMSID(String strDMSID_p, boolean refresh_p) throws Exception {
        OwCMISDMSIDDecoder decoder = this.internalNetwork.getNetworkConfiguration().getDMSIDDecoder();
        OwException cmisDecodeException = null;
        OwCMISDMSID dmsid = null;
        try {
            dmsid = decoder.createDMSID(strDMSID_p);
            String rID = dmsid.getResourceID();
            if (this.internalResourceIDs.contains(rID)) {
                OwObject iObject = this.internalNetwork.getObjectFromDMSID(strDMSID_p, refresh_p);
                return OwCMISCrossInvocationHandler.createCrossNetworkObject(this, this.getXMapping(), iObject, rID);
            }
        }
        catch (OwException e) {
            if (dmsid != null) {
                throw e;
            }
            cmisDecodeException = e;
        }
        if (this.externalNetwork != null) {
            OwObject exObject = this.externalNetwork.getObjectFromDMSID(strDMSID_p, refresh_p);
            return OwCMISCrossInvocationHandler.createCrossNetworkObject(this, this.getXMapping(), exObject, exObject.getResourceID());
        }
        if (cmisDecodeException != null) {
            throw cmisDecodeException;
        }
        LOG.error((Object)("OwCMISCrossNetwork.getObjectFromDMSID() : Invalid DMSID " + strDMSID_p));
        throw new OwInvalidOperationException((OwString)new OwString1("opencmis.cross.OwCMISCrossNetwork.err.invalid.dmsid", "Invalid DMSID %1 .", strDMSID_p));
    }

    public OwObject getObjectFromPath(String strPath_p, boolean refresh_p) throws Exception {
        if (strPath_p.equals("/")) {
            return this.domainFolder;
        }
        OwObject iObject = this.internalNetwork.getObjectFromPath(strPath_p, refresh_p);
        return OwCMISCrossInvocationHandler.createCrossNetworkObject(this, this.getXMapping(), iObject, iObject.getResourceID());
    }

    public OwResource getResource(String strID_p) throws Exception {
        OwNetwork network = this.getNetwork(strID_p);
        return network.getResource(this.removeResourcePrefix(network, strID_p));
    }

    public Iterator getResourceIDs() throws Exception {
        return this.crossResourceIDs.iterator();
    }

    public OwBatch openBatch() throws OwException {
        try {
            OwBatch owBatch;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                owBatch = this.internalNetwork.openBatch();
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owBatch;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    public void refreshStaticClassdescriptions() throws Exception {
        this.internalNetwork.refreshStaticClassdescriptions();
    }

    public void releaseResources() throws Exception {
        this.internalNetwork.releaseResources();
    }

    private String toExternalField(String strFieldDefinitionName_p) throws OwException {
        String string = strFieldDefinitionName_p;
        try {
            String string2;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                OwCrossMappings mapping = this.getXMapping();
                string2 = mapping.getXProperty(strFieldDefinitionName_p);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return string2;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string));
            }
            throw cmisBaseException;
        }
    }

    public OwFieldDefinition getFieldDefinition(String strFieldDefinitionName_p, String strResourceName_p) throws Exception, OwObjectNotFoundException {
        OwNetwork network = this.getNetwork(strResourceName_p);
        OwFieldDefinition definition = network.getFieldDefinition(strFieldDefinitionName_p, this.removeResourcePrefix(network, strResourceName_p));
        return definition;
    }

    public Collection getWildCardDefinitions(String strFieldDefinitionName_p, String strResourceName_p, int op_p) throws Exception {
        OwNetwork network = this.getNetwork(strResourceName_p);
        if (network == this.externalNetwork) {
            strFieldDefinitionName_p = this.toExternalField(strFieldDefinitionName_p);
        }
        return network.getWildCardDefinitions(strFieldDefinitionName_p, this.removeResourcePrefix(network, strResourceName_p), op_p);
    }

    public boolean canUserSelect() throws Exception {
        return this.internalNetwork.canUserSelect();
    }

    public OwCredentials getCredentials() throws Exception {
        return this.internalNetwork.getCredentials();
    }

    public OwUILoginModul<?> getLoginSubModul() throws Exception {
        OwCMISUILoginModule<OwCMISCrossNetwork> loginSubModul = new OwCMISUILoginModule<OwCMISCrossNetwork>();
        loginSubModul.init(this);
        return loginSubModul;
    }

    public String getRoleDisplayName(String strRoleName_p) throws Exception {
        return this.internalNetwork.getRoleDisplayName(strRoleName_p);
    }

    public OwUserInfo getUserFromID(String strID_p) throws Exception {
        return this.internalNetwork.getUserFromID(strID_p);
    }

    public OwUIUserSelectModul getUserSelectSubModul(String strID_p, int[] types_p) throws Exception {
        return this.internalNetwork.getUserSelectSubModul(strID_p, types_p);
    }

    public void loginDefault(String user_p, String password_p) throws Exception {
        this.internalNetwork.loginDefault(user_p, password_p);
        if (this.externalNetwork != null) {
            try {
                this.getXMapping().doXLogin(this.externalNetwork, (OwNetwork)this, user_p, password_p);
            }
            catch (Exception e) {
                String msg = "Your X Login information is invalid or the X Server is not available. Please make sure that name and password are correct and the X Server is running.";
                LOG.debug((Object)msg, (Throwable)e);
                throw new OwAuthenticationException(msg, (Throwable)e);
            }
            Iterator xResources = this.externalNetwork.getResourceIDs();
            while (xResources.hasNext()) {
                String xResourceID = (String)xResources.next();
                this.externalResourceIDs.add(xResourceID);
                this.externalNetwork.getResource(xResourceID);
            }
        }
        Iterator<String> iResources = this.internalNetwork.getResourceIDs();
        while (iResources.hasNext()) {
            String iResource = iResources.next();
            this.internalResourceIDs.add(iResource);
        }
        this.crossResourceIDs.addAll(this.internalResourceIDs);
        this.crossResourceIDs.addAll(this.externalResourceIDs);
        this.domainFolder = this.createDomainFolder();
    }

    protected OwObject createDomainFolder() throws OwException {
        try {
            OwObject owObject;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                owObject = this.externalNetwork != null ? (this.domainFolder = new OwCMISCrossDomainFolder(this)) : this.internalNetwork.getObjectFromPath("/", true);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owObject;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    public void logout() throws Exception {
        this.internalNetwork.logout();
        if (this.externalNetwork != null) {
            this.externalNetwork.logout();
        }
    }

    @Override
    public String resolveRepositoryID(String repositoryName_p) throws OwException {
        String string = repositoryName_p;
        try {
            String string2;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                OwNetwork network = this.getNetwork(repositoryName_p);
                try {
                    OwResource resource = network.getResource(this.removeResourcePrefix(network, repositoryName_p));
                    string2 = resource.getID();
                }
                catch (Exception e) {
                    LOG.error((Object)"OwCMISCrossNetwork.resolveRepositoryID():");
                    throw new OwObjectNotFoundException(this.getContext().localize1("opencmis.cross.OwCMISCrossNetwork.err.resolveRepositoryID", "Could not find resource %1 !", repositoryName_p), (Throwable)e);
                }
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return string2;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string));
            }
            throw cmisBaseException;
        }
    }

    public OwNetworkContext getContext() {
        return this.context;
    }

    public OwObject createVirtualFolder(Node xmlVirtualFolderDescriptionNode_p, String strName_p, String strDmsIDPart_p) throws OwException {
        Node node = xmlVirtualFolderDescriptionNode_p;
        String string = strName_p;
        String string2 = strDmsIDPart_p;
        try {
            OwVirtualFolderObject owVirtualFolderObject;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                try {
                    OwStandardXMLUtil description = new OwStandardXMLUtil(xmlVirtualFolderDescriptionNode_p);
                    String strVirtualFolderClassName = description.getSafeTextValue("ClassName", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISVirtualFolderFactory");
                    Class<?> virtualFolderClass = Class.forName(strVirtualFolderClassName);
                    OwVirtualFolderObjectFactory retObject = (OwVirtualFolderObjectFactory)virtualFolderClass.newInstance();
                    Node rootNode = description.getSubNode("root");
                    retObject.init(this.getContext(), (OwRepository)this, String.valueOf(this.getInternalNetwork().getDMSPrefix()) + "," + "vf" + "," + strName_p, strName_p, rootNode);
                    owVirtualFolderObject = retObject.getInstance(strDmsIDPart_p);
                }
                catch (OwException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error((Object)("OwCMISCrossNetwork.createVirtualFolder():Could not create virtual folder named " + strName_p + " and dmisd part " + strDmsIDPart_p));
                    throw new OwInvalidOperationException(this.getContext().localize("opencmis.cross.OwCMISCrossNetwork.err.createVirtualFolder", "Could not create virtual folder!"), (Throwable)e);
                }
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owVirtualFolderObject;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                Object[] objectArray = new Object[]{node, string, string2};
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw cmisBaseException;
        }
    }

    protected OwVirtualFoldersManager getVFManager() throws OwException {
        try {
            OwVirtualFoldersManager owVirtualFoldersManager;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                if (this.vfManager == null) {
                    OwCMISNetwork internalNetowrk = this.getInternalNetwork();
                    OwCMISNetworkCfg configuration = internalNetowrk.getNetworkConfiguration();
                    OwFileAOSupport fileAOSupport = new OwFileAOSupport((OwNetwork)this, (OwNetworkConfiguration)configuration, "WEB-INF/cmis");
                    this.vfManager = new OwVirtualFoldersManager((OwAOSupport)fileAOSupport, (OwVirtualFolderFactory)this, this.roleManager, configuration.getVirtualFoldersContainer(null));
                }
                owVirtualFoldersManager = this.vfManager;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owVirtualFoldersManager;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public OwCMISAuthenticationInterceptor getAuthInterceptor() throws OwException {
        try {
            OwCMISAuthenticationInterceptor owCMISAuthenticationInterceptor;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                owCMISAuthenticationInterceptor = this.internalNetwork.getAuthInterceptor();
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISAuthenticationInterceptor;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    public OwRoleManager getRoleManager() {
        return this.roleManager;
    }

    public OwIterable<OwCMISObject> doSearch(OwSearchNode searchClause, OwLoadContext loadContext) throws OwException {
        OwSearchNode owSearchNode = searchClause;
        OwLoadContext owLoadContext = loadContext;
        try {
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                throw new OwNotSupportedException("The Open CMIS cross-adapter does not suppport PageSearch.");
            }
            catch (Throwable throwable) {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
                throw throwable;
            }
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)owSearchNode, (Object)owLoadContext));
            }
            throw cmisBaseException;
        }
    }

    public boolean canPageSearch() {
        return false;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwCMISCrossNetwork.java", OwCMISCrossNetwork.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNetwork", "com.wewebu.ow.server.ecmimpl.opencmis.cross.OwCMISCrossNetwork", "java.lang.String", "resourceID_p", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecm.OwNetwork"), 139);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "externalInit", "com.wewebu.ow.server.ecmimpl.opencmis.cross.OwCMISCrossNetwork", "com.wewebu.ow.server.ecm.OwNetworkContext:com.wewebu.ow.server.util.OwXMLUtil", "context_p:networkSettings_p", "com.wewebu.ow.server.exceptions.OwException", "void"), 383);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAuthInterceptor", "com.wewebu.ow.server.ecmimpl.opencmis.cross.OwCMISCrossNetwork", "", "", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISAuthenticationInterceptor"), 856);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "doSearch", "com.wewebu.ow.server.ecmimpl.opencmis.cross.OwCMISCrossNetwork", "com.wewebu.ow.server.field.OwSearchNode:com.wewebu.ow.server.collections.OwLoadContext", "searchClause:loadContext", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.collections.OwIterable"), 869);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "closeBatch", "com.wewebu.ow.server.ecmimpl.opencmis.cross.OwCMISCrossNetwork", "com.wewebu.ow.server.ecm.OwBatch", "batch_p", "com.wewebu.ow.server.exceptions.OwException", "void"), 450);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "getXMapping", "com.wewebu.ow.server.ecmimpl.opencmis.cross.OwCMISCrossNetwork", "", "", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecm.OwCrossMappings"), 513);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "openBatch", "com.wewebu.ow.server.ecmimpl.opencmis.cross.OwCMISCrossNetwork", "", "", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecm.OwBatch"), 636);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toExternalField", "com.wewebu.ow.server.ecmimpl.opencmis.cross.OwCMISCrossNetwork", "java.lang.String", "strFieldDefinitionName_p", "com.wewebu.ow.server.exceptions.OwException", "java.lang.String"), 651);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "createDomainFolder", "com.wewebu.ow.server.ecmimpl.opencmis.cross.OwCMISCrossNetwork", "", "", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecm.OwObject"), 752);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "resolveRepositoryID", "com.wewebu.ow.server.ecmimpl.opencmis.cross.OwCMISCrossNetwork", "java.lang.String", "repositoryName_p", "com.wewebu.ow.server.exceptions.OwException", "java.lang.String"), 775);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createVirtualFolder", "com.wewebu.ow.server.ecmimpl.opencmis.cross.OwCMISCrossNetwork", "org.w3c.dom.Node:java.lang.String:java.lang.String", "xmlVirtualFolderDescriptionNode_p:strName_p:strDmsIDPart_p", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecm.OwObject"), 804);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getVFManager", "com.wewebu.ow.server.ecmimpl.opencmis.cross.OwCMISCrossNetwork", "", "", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ao.OwVirtualFoldersManager"), 841);
    }
}

