/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.info;

import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecmimpl.opencmis.aspects.OwCMISExceptionManagement;
import com.wewebu.ow.server.ecmimpl.opencmis.info.OwCMISLDAPGroupInfo;
import com.wewebu.ow.server.ecmimpl.opencmis.info.OwCMISUserInfo;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.mandator.OwMandator;
import com.wewebu.ow.server.util.ldap.OwLdapConnector;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class OwCMISLDAPUserInfo
extends OwCMISUserInfo {
    private OwLdapConnector ldapConnector;
    private Collection<OwUserInfo> groups;
    private Collection<String> roles;
    private boolean adminGroupInterogation;
    private OwUserInfo userInfo;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public OwCMISLDAPUserInfo(String userName_p, OwLdapConnector ldapConnector_p) {
        this(userName_p, null, ldapConnector_p);
    }

    public OwCMISLDAPUserInfo(String userName_p, OwMandator mandator_p, OwLdapConnector ldapConnector_p) {
        this(userName_p, mandator_p, ldapConnector_p, false);
    }

    public OwCMISLDAPUserInfo(String userName_p, OwMandator mandator_p, OwLdapConnector ldapConnector_p, boolean adminGroupInterogation_p) {
        super(userName_p, mandator_p);
        this.ldapConnector = ldapConnector_p;
        this.adminGroupInterogation = adminGroupInterogation_p;
    }

    @Override
    public synchronized Collection<OwUserInfo> getGroups() throws OwException {
        try {
            Collection<OwUserInfo> collection;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                if (this.groups == null) {
                    Collection<OwUserInfo> superGroups = super.getGroups();
                    this.groups = new HashSet<OwUserInfo>(superGroups);
                    if (this.ldapConnector != null) {
                        Collection ldapShortGroupNames = this.ldapConnector.getShortGroupNames(this.adminGroupInterogation);
                        for (Object object : ldapShortGroupNames) {
                            String groupName = object.toString();
                            OwCMISLDAPGroupInfo groupInfo = this.createGroupInfo(groupName);
                            this.groups.add(groupInfo);
                        }
                    }
                    this.groups.addAll(this.getDefaulfGroups());
                }
                collection = this.groups;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return collection;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public synchronized Collection<String> getRoleNames() throws OwException {
        try {
            Collection<String> collection;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                if (this.roles == null) {
                    this.roles = new HashSet<String>();
                    List<String> superRoles = this.getDefaultRoleNames();
                    Collection ldapShortGroupNames = this.ldapConnector.getShortGroupNames(this.adminGroupInterogation);
                    if (this.getMandator() == null) {
                        this.roles.addAll(superRoles);
                        this.roles.addAll(ldapShortGroupNames);
                    } else {
                        for (String superRole : superRoles) {
                            this.roles.add(this.getMandator().filterRoleName(superRole));
                        }
                        for (Object ldapRole : ldapShortGroupNames) {
                            this.roles.add(this.getMandator().filterRoleName(ldapRole.toString()));
                        }
                    }
                    this.roles.addAll(this.getDefaultRoleNames());
                }
                collection = this.roles;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return collection;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    protected OwCMISLDAPGroupInfo createGroupInfo(String groupName_p) {
        return new OwCMISLDAPGroupInfo(groupName_p);
    }

    @Override
    public String getUserLongName() throws OwException {
        try {
            String string;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                try {
                    string = this.getUserInfo().getUserLongName();
                }
                catch (OwException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new OwServerException("Unable to retrieve LongName", (Throwable)e);
                }
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return string;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public String getUserShortName() throws Exception {
        return this.getUserInfo().getUserShortName();
    }

    @Override
    public String getUserDisplayName() throws Exception {
        return this.getUserInfo().getUserDisplayName();
    }

    @Override
    public String getUserID() {
        try {
            String userId = this.getUserInfo().getUserID();
            if (userId != null) {
                return userId;
            }
            return super.getUserID();
        }
        catch (OwException e) {
            throw new RuntimeException("Could not get userId from LDAP.", e);
        }
    }

    protected OwUserInfo getUserInfo() throws OwException {
        try {
            OwUserInfo owUserInfo;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                if (this.userInfo == null) {
                    this.userInfo = this.ldapConnector.findUserByLoginAnonymously(super.getUserName());
                }
                owUserInfo = this.userInfo;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owUserInfo;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    static {
        OwCMISLDAPUserInfo.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwCMISLDAPUserInfo.java", OwCMISLDAPUserInfo.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "getGroups", "com.wewebu.ow.server.ecmimpl.opencmis.info.OwCMISLDAPUserInfo", "", "", "com.wewebu.ow.server.exceptions.OwException", "java.util.Collection"), 72);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "getRoleNames", "com.wewebu.ow.server.ecmimpl.opencmis.info.OwCMISLDAPUserInfo", "", "", "com.wewebu.ow.server.exceptions.OwException", "java.util.Collection"), 95);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserLongName", "com.wewebu.ow.server.ecmimpl.opencmis.info.OwCMISLDAPUserInfo", "", "", "com.wewebu.ow.server.exceptions.OwException", "java.lang.String"), 138);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getUserInfo", "com.wewebu.ow.server.ecmimpl.opencmis.info.OwCMISLDAPUserInfo", "", "", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecm.OwUserInfo"), 193);
    }
}

