/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.object;

import com.wewebu.ow.server.ecmimpl.opencmis.aspects.OwCMISExceptionManagement;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISContextBoundObject;
import com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISTransientObject;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.Rendition;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.TransientCmisObject;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public abstract class OwCMISAbstractTransientObject<N extends TransientCmisObject>
implements OwCMISTransientObject<N> {
    private static final Logger LOG;
    protected Session session;
    protected OwCMISContextBoundObject<N> contextBoundObject;
    private boolean detached = false;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        OwCMISAbstractTransientObject.ajc$preClinit();
        LOG = OwLog.getLogger(OwCMISAbstractTransientObject.class);
    }

    public OwCMISAbstractTransientObject(N transientCmisObject, OperationContext creationContext, Session session) {
        this.contextBoundObject = new OwCMISContextBoundObject<N>(transientCmisObject, creationContext);
        this.session = session;
    }

    @Override
    public synchronized void detach() {
        this.detached = true;
    }

    @Override
    public boolean isDetached() {
        return this.detached;
    }

    protected Session getSession() {
        return this.session;
    }

    @Override
    public OperationContext getTransientContext() {
        return this.contextBoundObject.context;
    }

    @Override
    public N getTransientCmisObject() {
        return this.contextBoundObject.object;
    }

    protected abstract OwCMISContextBoundObject<N> retrieveProperties(Set<String> var1) throws OwException;

    protected abstract OwCMISContextBoundObject<N> retrieveRenditions(Set<String> var1) throws OwException;

    protected OperationContext addPropertyFilter(OperationContext context, Set<String> nativePropertyFilter, Set<String> nativeRenditionFilter) {
        HashSet<String> oldFilter;
        HashSet<String> oldRenditionFilter;
        boolean includeAcls = context.isIncludeAcls();
        boolean includeAllowableActions = context.isIncludeAllowableActions();
        boolean includePolicies = context.isIncludePolicies();
        IncludeRelationships includeRelationships = context.getIncludeRelationships();
        HashSet<String> renditionFilter = oldRenditionFilter = context.getRenditionFilter();
        if (nativeRenditionFilter != null) {
            renditionFilter = renditionFilter == null ? new HashSet<String>() : new HashSet(oldRenditionFilter);
            renditionFilter.addAll(nativeRenditionFilter);
            if (renditionFilter.size() > 1) {
                renditionFilter.remove("cmis:none");
            }
        }
        boolean includePathSegments = context.isIncludePathSegments();
        String orderBy = context.getOrderBy();
        boolean cacheEnabled = context.isCacheEnabled();
        int maxItemsPerPage = context.getMaxItemsPerPage();
        HashSet<String> filter = oldFilter = context.getFilter();
        if (nativePropertyFilter != null) {
            HashSet<String> hashSet = filter = oldFilter == null ? new HashSet<String>() : new HashSet(oldFilter);
            if (oldFilter == null || !oldFilter.containsAll(nativePropertyFilter)) {
                cacheEnabled = false;
            }
            filter.addAll(nativePropertyFilter);
        }
        OperationContext newContext = this.session.createOperationContext(filter, includeAcls, includeAllowableActions, includePolicies, includeRelationships, renditionFilter, includePathSegments, orderBy, cacheEnabled, maxItemsPerPage);
        return newContext;
    }

    @Override
    public synchronized N secureObject(String ... propertyNames) throws OwException {
        String[] stringArray = propertyNames;
        try {
            N n;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                n = this.secureObject(Arrays.asList(propertyNames));
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return n;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)stringArray));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public synchronized N secureObject(Collection<String> propertyNames) throws OwException {
        Collection<String> collection = propertyNames;
        try {
            Object n;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                this.secureProperties(propertyNames);
                n = this.contextBoundObject.object;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return n;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, collection));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public synchronized Map<String, Property<?>> secureProperties(Collection<String> propertyNames) throws OwException {
        Collection<String> collection = propertyNames;
        try {
            HashMap hashMap;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                Property nativeProperty;
                HashMap requestedProperties = new HashMap();
                HashMap<String, String> unfetchedPropertyNames = new HashMap<String, String>();
                for (String nativePropertyName : propertyNames) {
                    nativeProperty = this.contextBoundObject.object.getProperty(nativePropertyName);
                    if (nativeProperty == null) {
                        PropertyDefinition<?> propDef = this.getUnfetchedPropertyDefinition(nativePropertyName);
                        if (propDef != null) {
                            unfetchedPropertyNames.put(nativePropertyName, propDef.getQueryName());
                            continue;
                        }
                        LOG.debug((Object)("OwCMISAbstractTransientObject.secureProperties: Could not get query name, trying to retrieve property by id = " + nativePropertyName));
                        unfetchedPropertyNames.put(nativePropertyName, nativePropertyName);
                        continue;
                    }
                    requestedProperties.put(nativePropertyName, nativeProperty);
                }
                if (!unfetchedPropertyNames.isEmpty()) {
                    this.contextBoundObject = this.retrieveProperties(new HashSet<String>(unfetchedPropertyNames.values()));
                    for (String propertyName : unfetchedPropertyNames.keySet()) {
                        nativeProperty = this.contextBoundObject.object.getProperty(propertyName);
                        if (nativeProperty == null) {
                            if (LOG.isDebugEnabled()) {
                                String objectId = this.contextBoundObject.object.getId();
                                String repositoryId = this.getSession().getRepositoryInfo().getId();
                                ObjectType objectType = this.contextBoundObject.object.getType();
                                LOG.debug((Object)("Fetch fault : RID=" + repositoryId + " OID=" + objectId + " objectType=" + objectType.getId() + " propertyId=" + propertyName));
                            }
                            if (Boolean.getBoolean("com.wewebu.owd.opencmis.fetch.safety")) {
                                throw new OwServerException("Could not fetch property " + propertyName + " !");
                            }
                        }
                        requestedProperties.put(propertyName, nativeProperty);
                    }
                }
                hashMap = requestedProperties;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return hashMap;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, collection));
            }
            throw cmisBaseException;
        }
    }

    protected PropertyDefinition<?> getUnfetchedPropertyDefinition(String nativePropertyName) {
        return (PropertyDefinition)this.contextBoundObject.object.getType().getPropertyDefinitions().get(nativePropertyName);
    }

    @Override
    public synchronized Property<?> secureProperty(String propertyName) throws OwException {
        String string = propertyName;
        try {
            Property property;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                this.secureProperties(Arrays.asList(propertyName));
                property = this.contextBoundObject.object.getProperty(propertyName);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return property;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public void refresh(Collection<String> propertyNames) {
        if (propertyNames != null && !this.contextBoundObject.context.getFilter().containsAll(propertyNames)) {
            HashSet<String> propSet = new HashSet<String>(this.contextBoundObject.context.getFilter());
            propSet.addAll(propertyNames);
            this.contextBoundObject.context.setFilter(propSet);
        }
        this.contextBoundObject.object.refreshAndReset();
    }

    @Override
    public void setProperties(Map<String, Object> propertyValues) {
        Set<Map.Entry<String, Object>> propertyEntries = propertyValues.entrySet();
        for (Map.Entry<String, Object> entry : propertyEntries) {
            if (entry.getValue() == null) continue;
            this.contextBoundObject.object.setPropertyValue(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public List<Rendition> secureRenditions(Set<String> renditions, boolean refresh) throws OwException {
        Set<String> set = renditions;
        boolean bl = refresh;
        try {
            List list;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                Set renditionFilter = this.contextBoundObject.context.getRenditionFilter();
                if (!renditionFilter.containsAll(renditions) || refresh) {
                    HashSet<String> diff = new HashSet<String>(renditions);
                    diff.removeAll(renditionFilter);
                    this.contextBoundObject = this.retrieveRenditions(diff);
                }
                list = this.contextBoundObject.object.getRenditions();
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return list;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, set, (Object)Conversions.booleanObject((boolean)bl)));
            }
            throw cmisBaseException;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwCMISAbstractTransientObject.java", OwCMISAbstractTransientObject.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a1", "secureObject", "com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISAbstractTransientObject", "[Ljava.lang.String;", "propertyNames", "com.wewebu.ow.server.exceptions.OwException", "org.apache.chemistry.opencmis.client.api.TransientCmisObject"), 131);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "secureObject", "com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISAbstractTransientObject", "java.util.Collection", "propertyNames", "com.wewebu.ow.server.exceptions.OwException", "org.apache.chemistry.opencmis.client.api.TransientCmisObject"), 141);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "secureProperties", "com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISAbstractTransientObject", "java.util.Collection", "propertyNames", "com.wewebu.ow.server.exceptions.OwException", "java.util.Map"), 153);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "secureProperty", "com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISAbstractTransientObject", "java.lang.String", "propertyName", "com.wewebu.ow.server.exceptions.OwException", "org.apache.chemistry.opencmis.client.api.Property"), 236);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "secureRenditions", "com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISAbstractTransientObject", "java.util.Set:boolean", "renditions:refresh", "com.wewebu.ow.server.exceptions.OwException", "java.util.List"), 273);
    }
}

